/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Office365 app instance properties")
@JsonPropertyOrder(value={"domain", "msftTenant"})
public class Office365ApplicationSettingsApplication
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;
    public static final String JSON_PROPERTY_MSFT_TENANT = "msftTenant";
    private String msftTenant;

    public Office365ApplicationSettingsApplication domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The domain for your Office 365 account")
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Office365ApplicationSettingsApplication msftTenant(String msftTenant) {
        this.msftTenant = msftTenant;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Microsoft tenant name")
    @JsonProperty(value="msftTenant")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMsftTenant() {
        return this.msftTenant;
    }

    @JsonProperty(value="msftTenant")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMsftTenant(String msftTenant) {
        this.msftTenant = msftTenant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Office365ApplicationSettingsApplication office365ApplicationSettingsApplication = (Office365ApplicationSettingsApplication)o;
        return Objects.equals(this.domain, office365ApplicationSettingsApplication.domain) && Objects.equals(this.msftTenant, office365ApplicationSettingsApplication.msftTenant);
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.msftTenant);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Office365ApplicationSettingsApplication {\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    msftTenant: ").append(this.toIndentedString(this.msftTenant)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

