/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"client_secret", "status"})
public class OAuth2ClientSecretRequestBody
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
    private String clientSecret;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public OAuth2ClientSecretRequestBody clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="DRUFXGF9XbLn......a3x3POBiIxDreBCdZuFs5B", value="The OAuth 2.0 client secret string")
    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OAuth2ClientSecretRequestBody status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ACTIVE", value="Status of the OAuth 2.0 Client Secret")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2ClientSecretRequestBody oauth2ClientSecretRequestBody = (OAuth2ClientSecretRequestBody)o;
        return Objects.equals(this.clientSecret, oauth2ClientSecretRequestBody.clientSecret) && Objects.equals((Object)this.status, (Object)oauth2ClientSecretRequestBody.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientSecret, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2ClientSecretRequestBody {\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

