/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.OAuth2ClientLinks;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"client_id", "client_name", "client_uri", "logo_uri", "_links"})
public class OAuth2Client
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;
    public static final String JSON_PROPERTY_CLIENT_NAME = "client_name";
    private String clientName;
    public static final String JSON_PROPERTY_CLIENT_URI = "client_uri";
    private String clientUri;
    public static final String JSON_PROPERTY_LOGO_URI = "logo_uri";
    private String logoUri;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private OAuth2ClientLinks links;

    @Nullable
    @ApiModelProperty(example="0oabskvc6442nkvQO0h7", value="Unique key for the client application. The `client_id` is immutable.")
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    @Nullable
    @ApiModelProperty(example="My App", value="Human-readable string name of the client application")
    @JsonProperty(value="client_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientName() {
        return this.clientName;
    }

    @Nullable
    @ApiModelProperty(example="https://www.example.com", value="")
    @JsonProperty(value="client_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientUri() {
        return this.clientUri;
    }

    @Nullable
    @ApiModelProperty(example="https://www.example.com/logo.png", value="URL string that references a logo for the client consent dialog (not the sign-in dialog)")
    @JsonProperty(value="logo_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLogoUri() {
        return this.logoUri;
    }

    public OAuth2Client links(OAuth2ClientLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuth2ClientLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(OAuth2ClientLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2Client oauth2Client = (OAuth2Client)o;
        return Objects.equals(this.clientId, oauth2Client.clientId) && Objects.equals(this.clientName, oauth2Client.clientName) && Objects.equals(this.clientUri, oauth2Client.clientUri) && Objects.equals(this.logoUri, oauth2Client.logoUri) && Objects.equals(this.links, oauth2Client.links);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientName, this.clientUri, this.logoUri, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2Client {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientName: ").append(this.toIndentedString(this.clientName)).append("\n");
        sb.append("    clientUri: ").append(this.toIndentedString(this.clientUri)).append("\n");
        sb.append("    logoUri: ").append(this.toIndentedString(this.logoUri)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

