/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.MtlsTrustCredentialsRevocation;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"audience", "issuer", "kid", "revocation", "revocationCacheLifetime"})
public class MtlsTrustCredentials
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUDIENCE = "audience";
    private String audience;
    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;
    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;
    public static final String JSON_PROPERTY_REVOCATION = "revocation";
    private MtlsTrustCredentialsRevocation revocation;
    public static final String JSON_PROPERTY_REVOCATION_CACHE_LIFETIME = "revocationCacheLifetime";
    private BigDecimal revocationCacheLifetime;

    public MtlsTrustCredentials audience(String audience) {
        this.audience = audience;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Not used")
    @JsonProperty(value="audience")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAudience() {
        return this.audience;
    }

    @JsonProperty(value="audience")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAudience(String audience) {
        this.audience = audience;
    }

    public MtlsTrustCredentials issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CN=Test Smart Card, OU=Test OU, O=Test O, C=US", value="Description of the certificate issuer")
    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuer() {
        return this.issuer;
    }

    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public MtlsTrustCredentials kid(String kid) {
        this.kid = kid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-key-id", value="IdP Key Credential reference to the Okta X.509 signature certificate")
    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKid() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    public MtlsTrustCredentials revocation(MtlsTrustCredentialsRevocation revocation) {
        this.revocation = revocation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="revocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MtlsTrustCredentialsRevocation getRevocation() {
        return this.revocation;
    }

    @JsonProperty(value="revocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRevocation(MtlsTrustCredentialsRevocation revocation) {
        this.revocation = revocation;
    }

    public MtlsTrustCredentials revocationCacheLifetime(BigDecimal revocationCacheLifetime) {
        this.revocationCacheLifetime = revocationCacheLifetime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2880", value="Time in minutes to cache the certificate revocation information")
    @JsonProperty(value="revocationCacheLifetime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getRevocationCacheLifetime() {
        return this.revocationCacheLifetime;
    }

    @JsonProperty(value="revocationCacheLifetime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRevocationCacheLifetime(BigDecimal revocationCacheLifetime) {
        this.revocationCacheLifetime = revocationCacheLifetime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MtlsTrustCredentials mtlsTrustCredentials = (MtlsTrustCredentials)o;
        return Objects.equals(this.audience, mtlsTrustCredentials.audience) && Objects.equals(this.issuer, mtlsTrustCredentials.issuer) && Objects.equals(this.kid, mtlsTrustCredentials.kid) && Objects.equals((Object)this.revocation, (Object)mtlsTrustCredentials.revocation) && Objects.equals(this.revocationCacheLifetime, mtlsTrustCredentials.revocationCacheLifetime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.audience, this.issuer, this.kid, this.revocation, this.revocationCacheLifetime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MtlsTrustCredentials {\n");
        sb.append("    audience: ").append(this.toIndentedString(this.audience)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    revocation: ").append(this.toIndentedString((Object)this.revocation)).append("\n");
        sb.append("    revocationCacheLifetime: ").append(this.toIndentedString(this.revocationCacheLifetime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

