/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Elliptic Curve Key in JWK format, currently used during enrollment to encrypt fulfillment requests to Yubico, or during activation to verify Yubico's JWS objects in fulfillment responses. The currently agreed protocol uses P-384.")
@JsonPropertyOrder(value={"crv", "kid", "kty", "use", "x", "y"})
public class ECKeyJWK
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CRV = "crv";
    private CrvEnum crv;
    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;
    public static final String JSON_PROPERTY_KTY = "kty";
    private KtyEnum kty;
    public static final String JSON_PROPERTY_USE = "use";
    private UseEnum use;
    public static final String JSON_PROPERTY_X = "x";
    private String x;
    public static final String JSON_PROPERTY_Y = "y";
    private String y;

    public ECKeyJWK crv(CrvEnum crv) {
        this.crv = crv;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="crv")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CrvEnum getCrv() {
        return this.crv;
    }

    @JsonProperty(value="crv")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCrv(CrvEnum crv) {
        this.crv = crv;
    }

    public ECKeyJWK kid(String kid) {
        this.kid = kid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The unique identifier of the key")
    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getKid() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    public ECKeyJWK kty(KtyEnum kty) {
        this.kty = kty;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of public key")
    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public KtyEnum getKty() {
        return this.kty;
    }

    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKty(KtyEnum kty) {
        this.kty = kty;
    }

    public ECKeyJWK use(UseEnum use) {
        this.use = use;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The intended use for the key. The ECKeyJWK is always `enc` because Okta uses it to encrypt requests to Yubico.")
    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UseEnum getUse() {
        return this.use;
    }

    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUse(UseEnum use) {
        this.use = use;
    }

    public ECKeyJWK x(String x) {
        this.x = x;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The public x coordinate for the elliptic curve point")
    @JsonProperty(value="x")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getX() {
        return this.x;
    }

    @JsonProperty(value="x")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setX(String x) {
        this.x = x;
    }

    public ECKeyJWK y(String y) {
        this.y = y;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The public y coordinate for the elliptic curve point")
    @JsonProperty(value="y")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getY() {
        return this.y;
    }

    @JsonProperty(value="y")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setY(String y) {
        this.y = y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECKeyJWK ecKeyJWK = (ECKeyJWK)o;
        return Objects.equals((Object)this.crv, (Object)ecKeyJWK.crv) && Objects.equals(this.kid, ecKeyJWK.kid) && Objects.equals((Object)this.kty, (Object)ecKeyJWK.kty) && Objects.equals((Object)this.use, (Object)ecKeyJWK.use) && Objects.equals(this.x, ecKeyJWK.x) && Objects.equals(this.y, ecKeyJWK.y);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.crv, this.kid, this.kty, this.use, this.x, this.y});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ECKeyJWK {\n");
        sb.append("    crv: ").append(this.toIndentedString((Object)this.crv)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    kty: ").append(this.toIndentedString((Object)this.kty)).append("\n");
        sb.append("    use: ").append(this.toIndentedString((Object)this.use)).append("\n");
        sb.append("    x: ").append(this.toIndentedString(this.x)).append("\n");
        sb.append("    y: ").append(this.toIndentedString(this.y)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CrvEnum {
        P_384("P-384"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private CrvEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CrvEnum fromValue(String value) {
            for (CrvEnum b : CrvEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum KtyEnum {
        EC("EC"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private KtyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KtyEnum fromValue(String value) {
            for (KtyEnum b : KtyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum UseEnum {
        ENC("enc"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private UseEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UseEnum fromValue(String value) {
            for (UseEnum b : UseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

