/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.AuthorizationServerPolicyRule;
import com.okta.sdk.resource.model.AuthorizationServerPolicyRuleRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class AuthorizationServerRulesApi {
    private ApiClient apiClient;

    public AuthorizationServerRulesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationServerRulesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void activateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId) throws ApiException {
        this.activateAuthorizationServerPolicyRule(authServerId, policyId, ruleId, Collections.emptyMap());
    }

    public void activateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling activateAuthorizationServerPolicyRule");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling activateAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling activateAuthorizationServerPolicyRule");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/activate".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public AuthorizationServerPolicyRule createAuthorizationServerPolicyRule(String authServerId, String policyId, AuthorizationServerPolicyRuleRequest policyRule) throws ApiException {
        return this.createAuthorizationServerPolicyRule(authServerId, policyId, policyRule, Collections.emptyMap());
    }

    public AuthorizationServerPolicyRule createAuthorizationServerPolicyRule(String authServerId, String policyId, AuthorizationServerPolicyRuleRequest policyRule, Map<String, String> additionalHeaders) throws ApiException {
        AuthorizationServerPolicyRuleRequest localVarPostBody = policyRule;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicyRule");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling createAuthorizationServerPolicyRule");
        }
        if (policyRule == null) {
            throw new ApiException(400, "Missing the required parameter 'policyRule' when calling createAuthorizationServerPolicyRule");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthorizationServerPolicyRule> localVarReturnType = new TypeReference<AuthorizationServerPolicyRule>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deactivateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId) throws ApiException {
        this.deactivateAuthorizationServerPolicyRule(authServerId, policyId, ruleId, Collections.emptyMap());
    }

    public void deactivateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deactivateAuthorizationServerPolicyRule");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deactivateAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling deactivateAuthorizationServerPolicyRule");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/deactivate".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId) throws ApiException {
        this.deleteAuthorizationServerPolicyRule(authServerId, policyId, ruleId, Collections.emptyMap());
    }

    public void deleteAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deleteAuthorizationServerPolicyRule");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deleteAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteAuthorizationServerPolicyRule");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public AuthorizationServerPolicyRule getAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId) throws ApiException {
        return this.getAuthorizationServerPolicyRule(authServerId, policyId, ruleId, Collections.emptyMap());
    }

    public AuthorizationServerPolicyRule getAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling getAuthorizationServerPolicyRule");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling getAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling getAuthorizationServerPolicyRule");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthorizationServerPolicyRule> localVarReturnType = new TypeReference<AuthorizationServerPolicyRule>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AuthorizationServerPolicyRule> listAuthorizationServerPolicyRules(String authServerId, String policyId) throws ApiException {
        return this.listAuthorizationServerPolicyRules(authServerId, policyId, Collections.emptyMap());
    }

    public List<AuthorizationServerPolicyRule> listAuthorizationServerPolicyRules(String authServerId, String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling listAuthorizationServerPolicyRules");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling listAuthorizationServerPolicyRules");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AuthorizationServerPolicyRule>> localVarReturnType = new TypeReference<List<AuthorizationServerPolicyRule>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthorizationServerPolicyRule replaceAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId, AuthorizationServerPolicyRuleRequest policyRule) throws ApiException {
        return this.replaceAuthorizationServerPolicyRule(authServerId, policyId, ruleId, policyRule, Collections.emptyMap());
    }

    public AuthorizationServerPolicyRule replaceAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId, AuthorizationServerPolicyRuleRequest policyRule, Map<String, String> additionalHeaders) throws ApiException {
        AuthorizationServerPolicyRuleRequest localVarPostBody = policyRule;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicyRule");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling replaceAuthorizationServerPolicyRule");
        }
        if (policyRule == null) {
            throw new ApiException(400, "Missing the required parameter 'policyRule' when calling replaceAuthorizationServerPolicyRule");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthorizationServerPolicyRule> localVarReturnType = new TypeReference<AuthorizationServerPolicyRule>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

