/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.DefaultApp;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"agreeToCustomPrivacyPolicy", "customPrivacyPolicyUrl", "defaultApp", "emailDomainId", "locale", "name", "removePoweredByOkta"})
public class BrandRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AGREE_TO_CUSTOM_PRIVACY_POLICY = "agreeToCustomPrivacyPolicy";
    private Boolean agreeToCustomPrivacyPolicy;
    public static final String JSON_PROPERTY_CUSTOM_PRIVACY_POLICY_URL = "customPrivacyPolicyUrl";
    private String customPrivacyPolicyUrl;
    public static final String JSON_PROPERTY_DEFAULT_APP = "defaultApp";
    private DefaultApp defaultApp;
    public static final String JSON_PROPERTY_EMAIL_DOMAIN_ID = "emailDomainId";
    private String emailDomainId;
    public static final String JSON_PROPERTY_LOCALE = "locale";
    private String locale;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_REMOVE_POWERED_BY_OKTA = "removePoweredByOkta";
    private Boolean removePoweredByOkta = false;

    public BrandRequest agreeToCustomPrivacyPolicy(Boolean agreeToCustomPrivacyPolicy) {
        this.agreeToCustomPrivacyPolicy = agreeToCustomPrivacyPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Consent for updating the custom privacy URL. Not required when resetting the URL.")
    @JsonProperty(value="agreeToCustomPrivacyPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAgreeToCustomPrivacyPolicy() {
        return this.agreeToCustomPrivacyPolicy;
    }

    @JsonProperty(value="agreeToCustomPrivacyPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAgreeToCustomPrivacyPolicy(Boolean agreeToCustomPrivacyPolicy) {
        this.agreeToCustomPrivacyPolicy = agreeToCustomPrivacyPolicy;
    }

    public BrandRequest customPrivacyPolicyUrl(String customPrivacyPolicyUrl) {
        this.customPrivacyPolicyUrl = customPrivacyPolicyUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Custom privacy policy URL")
    @JsonProperty(value="customPrivacyPolicyUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomPrivacyPolicyUrl() {
        return this.customPrivacyPolicyUrl;
    }

    @JsonProperty(value="customPrivacyPolicyUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomPrivacyPolicyUrl(String customPrivacyPolicyUrl) {
        this.customPrivacyPolicyUrl = customPrivacyPolicyUrl;
    }

    public BrandRequest defaultApp(DefaultApp defaultApp) {
        this.defaultApp = defaultApp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="defaultApp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DefaultApp getDefaultApp() {
        return this.defaultApp;
    }

    @JsonProperty(value="defaultApp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultApp(DefaultApp defaultApp) {
        this.defaultApp = defaultApp;
    }

    public BrandRequest emailDomainId(String emailDomainId) {
        this.emailDomainId = emailDomainId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the email domain")
    @JsonProperty(value="emailDomainId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmailDomainId() {
        return this.emailDomainId;
    }

    @JsonProperty(value="emailDomainId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmailDomainId(String emailDomainId) {
        this.emailDomainId = emailDomainId;
    }

    public BrandRequest locale(String locale) {
        this.locale = locale;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The language specified as an [IETF BCP 47 language tag](https://datatracker.ietf.org/doc/html/rfc5646)")
    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocale() {
        return this.locale;
    }

    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocale(String locale) {
        this.locale = locale;
    }

    public BrandRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The name of the Brand")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public BrandRequest removePoweredByOkta(Boolean removePoweredByOkta) {
        this.removePoweredByOkta = removePoweredByOkta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Removes \"Powered by Okta\" from the sign-in page in redirect authentication deployments, and \"\u00a9 [current year] Okta, Inc.\" from the Okta End-User Dashboard")
    @JsonProperty(value="removePoweredByOkta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRemovePoweredByOkta() {
        return this.removePoweredByOkta;
    }

    @JsonProperty(value="removePoweredByOkta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemovePoweredByOkta(Boolean removePoweredByOkta) {
        this.removePoweredByOkta = removePoweredByOkta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrandRequest brandRequest = (BrandRequest)o;
        return Objects.equals(this.agreeToCustomPrivacyPolicy, brandRequest.agreeToCustomPrivacyPolicy) && Objects.equals(this.customPrivacyPolicyUrl, brandRequest.customPrivacyPolicyUrl) && Objects.equals(this.defaultApp, brandRequest.defaultApp) && Objects.equals(this.emailDomainId, brandRequest.emailDomainId) && Objects.equals(this.locale, brandRequest.locale) && Objects.equals(this.name, brandRequest.name) && Objects.equals(this.removePoweredByOkta, brandRequest.removePoweredByOkta);
    }

    public int hashCode() {
        return Objects.hash(this.agreeToCustomPrivacyPolicy, this.customPrivacyPolicyUrl, this.defaultApp, this.emailDomainId, this.locale, this.name, this.removePoweredByOkta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BrandRequest {\n");
        sb.append("    agreeToCustomPrivacyPolicy: ").append(this.toIndentedString(this.agreeToCustomPrivacyPolicy)).append("\n");
        sb.append("    customPrivacyPolicyUrl: ").append(this.toIndentedString(this.customPrivacyPolicyUrl)).append("\n");
        sb.append("    defaultApp: ").append(this.toIndentedString(this.defaultApp)).append("\n");
        sb.append("    emailDomainId: ").append(this.toIndentedString(this.emailDomainId)).append("\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    removePoweredByOkta: ").append(this.toIndentedString(this.removePoweredByOkta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

