/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.ResourceSetBindingCreateRequest;
import com.okta.sdk.resource.model.ResourceSetBindingResponse;
import com.okta.sdk.resource.model.ResourceSetBindings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class RoleDResourceSetBindingApi {
    private ApiClient apiClient;

    public RoleDResourceSetBindingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleDResourceSetBindingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ResourceSetBindingResponse createResourceSetBinding(String resourceSetIdOrLabel, ResourceSetBindingCreateRequest instance) throws ApiException {
        return this.createResourceSetBinding(resourceSetIdOrLabel, instance, Collections.emptyMap());
    }

    public ResourceSetBindingResponse createResourceSetBinding(String resourceSetIdOrLabel, ResourceSetBindingCreateRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        ResourceSetBindingCreateRequest localVarPostBody = instance;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling createResourceSetBinding");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling createResourceSetBinding");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetBindingResponse> localVarReturnType = new TypeReference<ResourceSetBindingResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteBinding(String resourceSetIdOrLabel, String roleIdOrLabel) throws ApiException {
        this.deleteBinding(resourceSetIdOrLabel, roleIdOrLabel, Collections.emptyMap());
    }

    public void deleteBinding(String resourceSetIdOrLabel, String roleIdOrLabel, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling deleteBinding");
        }
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling deleteBinding");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel}".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString())).replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ResourceSetBindingResponse getBinding(String resourceSetIdOrLabel, String roleIdOrLabel) throws ApiException {
        return this.getBinding(resourceSetIdOrLabel, roleIdOrLabel, Collections.emptyMap());
    }

    public ResourceSetBindingResponse getBinding(String resourceSetIdOrLabel, String roleIdOrLabel, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling getBinding");
        }
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling getBinding");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel}".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString())).replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetBindingResponse> localVarReturnType = new TypeReference<ResourceSetBindingResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSetBindings listBindings(String resourceSetIdOrLabel, String after) throws ApiException {
        return this.listBindings(resourceSetIdOrLabel, after, Collections.emptyMap());
    }

    public ResourceSetBindings listBindings(String resourceSetIdOrLabel, String after, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling listBindings");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetBindings> localVarReturnType = new TypeReference<ResourceSetBindings>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

