/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CaepDeviceComplianceChangeEventReasonAdmin;
import com.okta.sdk.resource.model.CaepDeviceComplianceChangeEventReasonUser;
import com.okta.sdk.resource.model.SecurityEventSubject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="The user risk level changed")
@JsonPropertyOrder(value={"current_level", "event_timestamp", "initiating_entity", "previous_level", "reason_admin", "reason_user", "subject"})
public class OktaUserRiskChangeEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CURRENT_LEVEL = "current_level";
    private CurrentLevelEnum currentLevel;
    public static final String JSON_PROPERTY_EVENT_TIMESTAMP = "event_timestamp";
    private Long eventTimestamp;
    public static final String JSON_PROPERTY_INITIATING_ENTITY = "initiating_entity";
    private InitiatingEntityEnum initiatingEntity;
    public static final String JSON_PROPERTY_PREVIOUS_LEVEL = "previous_level";
    private PreviousLevelEnum previousLevel;
    public static final String JSON_PROPERTY_REASON_ADMIN = "reason_admin";
    private CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin;
    public static final String JSON_PROPERTY_REASON_USER = "reason_user";
    private CaepDeviceComplianceChangeEventReasonUser reasonUser;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private SecurityEventSubject subject;

    public OktaUserRiskChangeEvent currentLevel(CurrentLevelEnum currentLevel) {
        this.currentLevel = currentLevel;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="low", required=true, value="Current risk level of the user")
    @JsonProperty(value="current_level")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CurrentLevelEnum getCurrentLevel() {
        return this.currentLevel;
    }

    @JsonProperty(value="current_level")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrentLevel(CurrentLevelEnum currentLevel) {
        this.currentLevel = currentLevel;
    }

    public OktaUserRiskChangeEvent eventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1702448550", required=true, value="The time of the event (UNIX timestamp)")
    @JsonProperty(value="event_timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getEventTimestamp() {
        return this.eventTimestamp;
    }

    @JsonProperty(value="event_timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    public OktaUserRiskChangeEvent initiatingEntity(InitiatingEntityEnum initiatingEntity) {
        this.initiatingEntity = initiatingEntity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The entity that initiated the event")
    @JsonProperty(value="initiating_entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public InitiatingEntityEnum getInitiatingEntity() {
        return this.initiatingEntity;
    }

    @JsonProperty(value="initiating_entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitiatingEntity(InitiatingEntityEnum initiatingEntity) {
        this.initiatingEntity = initiatingEntity;
    }

    public OktaUserRiskChangeEvent previousLevel(PreviousLevelEnum previousLevel) {
        this.previousLevel = previousLevel;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="medium", required=true, value="Previous risk level of the user")
    @JsonProperty(value="previous_level")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PreviousLevelEnum getPreviousLevel() {
        return this.previousLevel;
    }

    @JsonProperty(value="previous_level")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPreviousLevel(PreviousLevelEnum previousLevel) {
        this.previousLevel = previousLevel;
    }

    public OktaUserRiskChangeEvent reasonAdmin(CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin) {
        this.reasonAdmin = reasonAdmin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="reason_admin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CaepDeviceComplianceChangeEventReasonAdmin getReasonAdmin() {
        return this.reasonAdmin;
    }

    @JsonProperty(value="reason_admin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReasonAdmin(CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin) {
        this.reasonAdmin = reasonAdmin;
    }

    public OktaUserRiskChangeEvent reasonUser(CaepDeviceComplianceChangeEventReasonUser reasonUser) {
        this.reasonUser = reasonUser;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="reason_user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CaepDeviceComplianceChangeEventReasonUser getReasonUser() {
        return this.reasonUser;
    }

    @JsonProperty(value="reason_user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReasonUser(CaepDeviceComplianceChangeEventReasonUser reasonUser) {
        this.reasonUser = reasonUser;
    }

    public OktaUserRiskChangeEvent subject(SecurityEventSubject subject) {
        this.subject = subject;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SecurityEventSubject getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubject(SecurityEventSubject subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OktaUserRiskChangeEvent oktaUserRiskChangeEvent = (OktaUserRiskChangeEvent)o;
        return Objects.equals((Object)this.currentLevel, (Object)oktaUserRiskChangeEvent.currentLevel) && Objects.equals(this.eventTimestamp, oktaUserRiskChangeEvent.eventTimestamp) && Objects.equals((Object)this.initiatingEntity, (Object)oktaUserRiskChangeEvent.initiatingEntity) && Objects.equals((Object)this.previousLevel, (Object)oktaUserRiskChangeEvent.previousLevel) && Objects.equals(this.reasonAdmin, oktaUserRiskChangeEvent.reasonAdmin) && Objects.equals(this.reasonUser, oktaUserRiskChangeEvent.reasonUser) && Objects.equals(this.subject, oktaUserRiskChangeEvent.subject);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.currentLevel, this.eventTimestamp, this.initiatingEntity, this.previousLevel, this.reasonAdmin, this.reasonUser, this.subject});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OktaUserRiskChangeEvent {\n");
        sb.append("    currentLevel: ").append(this.toIndentedString((Object)this.currentLevel)).append("\n");
        sb.append("    eventTimestamp: ").append(this.toIndentedString(this.eventTimestamp)).append("\n");
        sb.append("    initiatingEntity: ").append(this.toIndentedString((Object)this.initiatingEntity)).append("\n");
        sb.append("    previousLevel: ").append(this.toIndentedString((Object)this.previousLevel)).append("\n");
        sb.append("    reasonAdmin: ").append(this.toIndentedString(this.reasonAdmin)).append("\n");
        sb.append("    reasonUser: ").append(this.toIndentedString(this.reasonUser)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CurrentLevelEnum {
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high"),
        SECURE("secure"),
        NONE("none"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private CurrentLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CurrentLevelEnum fromValue(String value) {
            for (CurrentLevelEnum b : CurrentLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum InitiatingEntityEnum {
        ADMIN("admin"),
        USER("user"),
        POLICY("policy"),
        SYSTEM("system"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private InitiatingEntityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InitiatingEntityEnum fromValue(String value) {
            for (InitiatingEntityEnum b : InitiatingEntityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum PreviousLevelEnum {
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high"),
        SECURE("secure"),
        NONE("none"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private PreviousLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PreviousLevelEnum fromValue(String value) {
            for (PreviousLevelEnum b : PreviousLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

