/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.OAuthAuthorizationEndpoint;
import com.okta.sdk.resource.model.OAuthTokenEndpoint;
import com.okta.sdk.resource.model.OidcJwksEndpoint;
import com.okta.sdk.resource.model.OidcUserInfoEndpoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The `OAUTH2` and `OIDC` protocols support the `authorization` and `token` endpoints. Also, the `OIDC` protocol supports the `userInfo` and `jwks` endpoints.  The IdP Authorization Server (AS) endpoints are currently defined as part of the [IdP provider]((https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/createIdentityProvider!path=type&t=request)) and are read-only.")
@JsonPropertyOrder(value={"authorization", "jwks", "token", "userInfo"})
public class OAuthEndpoints
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTHORIZATION = "authorization";
    private OAuthAuthorizationEndpoint authorization;
    public static final String JSON_PROPERTY_JWKS = "jwks";
    private OidcJwksEndpoint jwks;
    public static final String JSON_PROPERTY_TOKEN = "token";
    private OAuthTokenEndpoint token;
    public static final String JSON_PROPERTY_USER_INFO = "userInfo";
    private OidcUserInfoEndpoint userInfo;

    public OAuthEndpoints authorization(OAuthAuthorizationEndpoint authorization) {
        this.authorization = authorization;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="authorization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuthAuthorizationEndpoint getAuthorization() {
        return this.authorization;
    }

    @JsonProperty(value="authorization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorization(OAuthAuthorizationEndpoint authorization) {
        this.authorization = authorization;
    }

    public OAuthEndpoints jwks(OidcJwksEndpoint jwks) {
        this.jwks = jwks;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="jwks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OidcJwksEndpoint getJwks() {
        return this.jwks;
    }

    @JsonProperty(value="jwks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJwks(OidcJwksEndpoint jwks) {
        this.jwks = jwks;
    }

    public OAuthEndpoints token(OAuthTokenEndpoint token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuthTokenEndpoint getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setToken(OAuthTokenEndpoint token) {
        this.token = token;
    }

    public OAuthEndpoints userInfo(OidcUserInfoEndpoint userInfo) {
        this.userInfo = userInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="userInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OidcUserInfoEndpoint getUserInfo() {
        return this.userInfo;
    }

    @JsonProperty(value="userInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserInfo(OidcUserInfoEndpoint userInfo) {
        this.userInfo = userInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthEndpoints oauthEndpoints = (OAuthEndpoints)o;
        return Objects.equals(this.authorization, oauthEndpoints.authorization) && Objects.equals(this.jwks, oauthEndpoints.jwks) && Objects.equals(this.token, oauthEndpoints.token) && Objects.equals(this.userInfo, oauthEndpoints.userInfo);
    }

    public int hashCode() {
        return Objects.hash(this.authorization, this.jwks, this.token, this.userInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthEndpoints {\n");
        sb.append("    authorization: ").append(this.toIndentedString(this.authorization)).append("\n");
        sb.append("    jwks: ").append(this.toIndentedString(this.jwks)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    userInfo: ").append(this.toIndentedString(this.userInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

