/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Error object thrown when parsing the Security Event Token")
@JsonPropertyOrder(value={"description", "err"})
public class SecurityEventTokenError
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ERR = "err";
    private ErrEnum err;

    public SecurityEventTokenError description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Failed claim validation in security event token. 'events.mediationDeviceComplianceChangeEvent.previousStatus': The field cannot be left blank", value="Describes the error > **Note:** SET claim fields with underscores (snake case) are presented in camelcase. For example, `previous_status` appears as `previousStatus`. ")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public SecurityEventTokenError err(ErrEnum err) {
        this.err = err;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="invalid_request", value="A code that describes the category of the error")
    @JsonProperty(value="err")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ErrEnum getErr() {
        return this.err;
    }

    @JsonProperty(value="err")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErr(ErrEnum err) {
        this.err = err;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityEventTokenError securityEventTokenError = (SecurityEventTokenError)o;
        return Objects.equals(this.description, securityEventTokenError.description) && Objects.equals((Object)this.err, (Object)securityEventTokenError.err);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.err});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventTokenError {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    err: ").append(this.toIndentedString((Object)this.err)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ErrEnum {
        AUTHENTICATION_FAILED("authentication_failed"),
        INVALID_AUDIENCE("invalid_audience"),
        INVALID_ISSUER("invalid_issuer"),
        INVALID_KEY("invalid_key"),
        INVALID_REQUEST("invalid_request"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ErrEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ErrEnum fromValue(String value) {
            for (ErrEnum b : ErrEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

