/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.GrantOrTokenStatus;
import com.okta.sdk.resource.model.OAuth2RefreshTokenEmbedded;
import com.okta.sdk.resource.model.OAuth2RefreshTokenLinks;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"clientId", "created", "expiresAt", "id", "issuer", "lastUpdated", "scopes", "status", "userId", "_embedded", "_links"})
public class OAuth2RefreshToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    private String clientId;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private GrantOrTokenStatus status;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;
    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private OAuth2RefreshTokenEmbedded embedded;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private OAuth2RefreshTokenLinks links;

    public OAuth2RefreshToken clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Client ID")
    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Nullable
    @ApiModelProperty(example="2017-03-28T01:11:10Z", value="Timestamp when the object was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(value="Expiration time of the OAuth 2.0 Token")
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @Nullable
    @ApiModelProperty(example="oar579Mcp7OUsNTlo0g3", value="ID of the Token object")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public OAuth2RefreshToken issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://{yourOktaDomain}/oauth2/ausain6z9zIedDCxB0h7", value="The complete URL of the authorization server that issued the Token")
    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuer() {
        return this.issuer;
    }

    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the object was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public OAuth2RefreshToken scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public OAuth2RefreshToken addscopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The scope names attached to the Token")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public OAuth2RefreshToken status(GrantOrTokenStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GrantOrTokenStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(GrantOrTokenStatus status) {
        this.status = status;
    }

    public OAuth2RefreshToken userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00u5t60iloOHN9pBi0h7", value="The ID of the user associated with the Token")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public OAuth2RefreshToken embedded(OAuth2RefreshTokenEmbedded embedded) {
        this.embedded = embedded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_embedded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuth2RefreshTokenEmbedded getEmbedded() {
        return this.embedded;
    }

    @JsonProperty(value="_embedded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmbedded(OAuth2RefreshTokenEmbedded embedded) {
        this.embedded = embedded;
    }

    public OAuth2RefreshToken links(OAuth2RefreshTokenLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuth2RefreshTokenLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(OAuth2RefreshTokenLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2RefreshToken oauth2RefreshToken = (OAuth2RefreshToken)o;
        return Objects.equals(this.clientId, oauth2RefreshToken.clientId) && Objects.equals(this.created, oauth2RefreshToken.created) && Objects.equals(this.expiresAt, oauth2RefreshToken.expiresAt) && Objects.equals(this.id, oauth2RefreshToken.id) && Objects.equals(this.issuer, oauth2RefreshToken.issuer) && Objects.equals(this.lastUpdated, oauth2RefreshToken.lastUpdated) && Objects.equals(this.scopes, oauth2RefreshToken.scopes) && Objects.equals((Object)this.status, (Object)oauth2RefreshToken.status) && Objects.equals(this.userId, oauth2RefreshToken.userId) && Objects.equals(this.embedded, oauth2RefreshToken.embedded) && Objects.equals(this.links, oauth2RefreshToken.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.created, this.expiresAt, this.id, this.issuer, this.lastUpdated, this.scopes, this.status, this.userId, this.embedded, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2RefreshToken {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    embedded: ").append(this.toIndentedString(this.embedded)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

