/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticatorMethodConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the authenticators permitted for the initial authentication step of password recovery")
@JsonPropertyOrder(value={"methodConstraints", "methods"})
public class SsprPrimaryRequirement
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_METHOD_CONSTRAINTS = "methodConstraints";
    private List<AuthenticatorMethodConstraint> methodConstraints = null;
    public static final String JSON_PROPERTY_METHODS = "methods";
    private List<MethodsEnum> methods = null;

    public SsprPrimaryRequirement methodConstraints(List<AuthenticatorMethodConstraint> methodConstraints) {
        this.methodConstraints = methodConstraints;
        return this;
    }

    public SsprPrimaryRequirement addmethodConstraintsItem(AuthenticatorMethodConstraint methodConstraintsItem) {
        if (this.methodConstraints == null) {
            this.methodConstraints = new ArrayList<AuthenticatorMethodConstraint>();
        }
        this.methodConstraints.add(methodConstraintsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Constraints on the values specified in the `methods` array. Specifying a constraint limits methods to specific authenticator(s). Currently, Google OTP is the only accepted constraint.")
    @JsonProperty(value="methodConstraints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AuthenticatorMethodConstraint> getMethodConstraints() {
        return this.methodConstraints;
    }

    @JsonProperty(value="methodConstraints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMethodConstraints(List<AuthenticatorMethodConstraint> methodConstraints) {
        this.methodConstraints = methodConstraints;
    }

    public SsprPrimaryRequirement methods(List<MethodsEnum> methods) {
        this.methods = methods;
        return this;
    }

    public SsprPrimaryRequirement addmethodsItem(MethodsEnum methodsItem) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodsEnum>();
        }
        this.methods.add(methodsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Authenticator methods allowed for the initial authentication step of password recovery")
    @JsonProperty(value="methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MethodsEnum> getMethods() {
        return this.methods;
    }

    @JsonProperty(value="methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMethods(List<MethodsEnum> methods) {
        this.methods = methods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SsprPrimaryRequirement ssprPrimaryRequirement = (SsprPrimaryRequirement)o;
        return Objects.equals(this.methodConstraints, ssprPrimaryRequirement.methodConstraints) && Objects.equals(this.methods, ssprPrimaryRequirement.methods);
    }

    public int hashCode() {
        return Objects.hash(this.methodConstraints, this.methods);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SsprPrimaryRequirement {\n");
        sb.append("    methodConstraints: ").append(this.toIndentedString(this.methodConstraints)).append("\n");
        sb.append("    methods: ").append(this.toIndentedString(this.methods)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MethodsEnum {
        PUSH("push"),
        SMS("sms"),
        VOICE("voice"),
        EMAIL("email"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private MethodsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodsEnum fromValue(String value) {
            for (MethodsEnum b : MethodsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

