/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum PasswordCredentialHashAlgorithm {
    BCRYPT("BCRYPT"),
    MD5("MD5"),
    PBKDF2("PBKDF2"),
    SHA_1("SHA-1"),
    SHA_256("SHA-256"),
    SHA_512("SHA-512");

    private String value;

    private PasswordCredentialHashAlgorithm(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static PasswordCredentialHashAlgorithm fromValue(String value) {
        for (PasswordCredentialHashAlgorithm b : PasswordCredentialHashAlgorithm.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString().toString());
    }
}

