/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.EmailCustomizationAllOfLinks;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"body", "subject", "created", "id", "isDefault", "language", "lastUpdated", "_links"})
public class EmailCustomization
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_BODY = "body";
    private String body;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_IS_DEFAULT = "isDefault";
    private Boolean isDefault;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private EmailCustomizationAllOfLinks links;

    public EmailCustomization body(String body) {
        this.body = body;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The email's HTML body. May contain [variable references](https://velocity.apache.org/engine/1.7/user-guide.html#references).")
    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBody() {
        return this.body;
    }

    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBody(String body) {
        this.body = body;
    }

    public EmailCustomization subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The email's subject. May contain [variable references](https://velocity.apache.org/engine/1.7/user-guide.html#references).")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Nullable
    @ApiModelProperty(value="The UTC time at which this email customization was created.")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(value="A unique identifier for this email customization")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public EmailCustomization isDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this is the default customization for the email template. Each customized email template must have exactly one default customization. Defaults to `true` for the first customization and `false` thereafter.")
    @JsonProperty(value="isDefault")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    @JsonProperty(value="isDefault")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public EmailCustomization language(String language) {
        this.language = language;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The language specified as an [IETF BCP 47 language tag](https://datatracker.ietf.org/doc/html/rfc5646)")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLanguage(String language) {
        this.language = language;
    }

    @Nullable
    @ApiModelProperty(value="The UTC time at which this email customization was last updated.")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public EmailCustomization links(EmailCustomizationAllOfLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EmailCustomizationAllOfLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(EmailCustomizationAllOfLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailCustomization emailCustomization = (EmailCustomization)o;
        return Objects.equals(this.body, emailCustomization.body) && Objects.equals(this.subject, emailCustomization.subject) && Objects.equals(this.created, emailCustomization.created) && Objects.equals(this.id, emailCustomization.id) && Objects.equals(this.isDefault, emailCustomization.isDefault) && Objects.equals(this.language, emailCustomization.language) && Objects.equals(this.lastUpdated, emailCustomization.lastUpdated) && Objects.equals(this.links, emailCustomization.links);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.subject, this.created, this.id, this.isDefault, this.language, this.lastUpdated, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailCustomization {\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

