/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.AssociatedServerMediated;
import com.okta.sdk.resource.model.AuthorizationServer;
import com.okta.sdk.resource.model.AuthorizationServerPolicy;
import com.okta.sdk.resource.model.AuthorizationServerPolicyRule;
import com.okta.sdk.resource.model.JsonWebKey;
import com.okta.sdk.resource.model.JwkUse;
import com.okta.sdk.resource.model.OAuth2Claim;
import com.okta.sdk.resource.model.OAuth2Client;
import com.okta.sdk.resource.model.OAuth2RefreshToken;
import com.okta.sdk.resource.model.OAuth2Scope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class AuthorizationServerApi {
    private ApiClient apiClient;

    public AuthorizationServerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationServerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void activateAuthorizationServer(String authServerId) throws ApiException {
        this.activateAuthorizationServer(authServerId, Collections.emptyMap());
    }

    public void activateAuthorizationServer(String authServerId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling activateAuthorizationServer");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/lifecycle/activate".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void activateAuthorizationServerPolicy(String authServerId, String policyId) throws ApiException {
        this.activateAuthorizationServerPolicy(authServerId, policyId, Collections.emptyMap());
    }

    public void activateAuthorizationServerPolicy(String authServerId, String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling activateAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling activateAuthorizationServerPolicy");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/lifecycle/activate".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void activateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId) throws ApiException {
        this.activateAuthorizationServerPolicyRule(authServerId, policyId, ruleId, Collections.emptyMap());
    }

    public void activateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling activateAuthorizationServerPolicyRule");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling activateAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling activateAuthorizationServerPolicyRule");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/activate".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<AuthorizationServer> createAssociatedServers(String authServerId, AssociatedServerMediated associatedServerMediated) throws ApiException {
        return this.createAssociatedServers(authServerId, associatedServerMediated, Collections.emptyMap());
    }

    public List<AuthorizationServer> createAssociatedServers(String authServerId, AssociatedServerMediated associatedServerMediated, Map<String, String> additionalHeaders) throws ApiException {
        AssociatedServerMediated localVarPostBody = associatedServerMediated;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling createAssociatedServers");
        }
        if (associatedServerMediated == null) {
            throw new ApiException(400, "Missing the required parameter 'associatedServerMediated' when calling createAssociatedServers");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/associatedServers".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AuthorizationServer>> localVarReturnType = new TypeReference<List<AuthorizationServer>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthorizationServer createAuthorizationServer(AuthorizationServer authorizationServer) throws ApiException {
        return this.createAuthorizationServer(authorizationServer, Collections.emptyMap());
    }

    public AuthorizationServer createAuthorizationServer(AuthorizationServer authorizationServer, Map<String, String> additionalHeaders) throws ApiException {
        AuthorizationServer localVarPostBody = authorizationServer;
        if (authorizationServer == null) {
            throw new ApiException(400, "Missing the required parameter 'authorizationServer' when calling createAuthorizationServer");
        }
        String localVarPath = "/api/v1/authorizationServers";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthorizationServer> localVarReturnType = new TypeReference<AuthorizationServer>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthorizationServerPolicy createAuthorizationServerPolicy(String authServerId, AuthorizationServerPolicy policy) throws ApiException {
        return this.createAuthorizationServerPolicy(authServerId, policy, Collections.emptyMap());
    }

    public AuthorizationServerPolicy createAuthorizationServerPolicy(String authServerId, AuthorizationServerPolicy policy, Map<String, String> additionalHeaders) throws ApiException {
        AuthorizationServerPolicy localVarPostBody = policy;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicy");
        }
        if (policy == null) {
            throw new ApiException(400, "Missing the required parameter 'policy' when calling createAuthorizationServerPolicy");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthorizationServerPolicy> localVarReturnType = new TypeReference<AuthorizationServerPolicy>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthorizationServerPolicyRule createAuthorizationServerPolicyRule(String authServerId, String policyId, AuthorizationServerPolicyRule policyRule) throws ApiException {
        return this.createAuthorizationServerPolicyRule(authServerId, policyId, policyRule, Collections.emptyMap());
    }

    public AuthorizationServerPolicyRule createAuthorizationServerPolicyRule(String authServerId, String policyId, AuthorizationServerPolicyRule policyRule, Map<String, String> additionalHeaders) throws ApiException {
        AuthorizationServerPolicyRule localVarPostBody = policyRule;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicyRule");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling createAuthorizationServerPolicyRule");
        }
        if (policyRule == null) {
            throw new ApiException(400, "Missing the required parameter 'policyRule' when calling createAuthorizationServerPolicyRule");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthorizationServerPolicyRule> localVarReturnType = new TypeReference<AuthorizationServerPolicyRule>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OAuth2Claim createOAuth2Claim(String authServerId, OAuth2Claim oAuth2Claim) throws ApiException {
        return this.createOAuth2Claim(authServerId, oAuth2Claim, Collections.emptyMap());
    }

    public OAuth2Claim createOAuth2Claim(String authServerId, OAuth2Claim oAuth2Claim, Map<String, String> additionalHeaders) throws ApiException {
        OAuth2Claim localVarPostBody = oAuth2Claim;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling createOAuth2Claim");
        }
        if (oAuth2Claim == null) {
            throw new ApiException(400, "Missing the required parameter 'oAuth2Claim' when calling createOAuth2Claim");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/claims".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OAuth2Claim> localVarReturnType = new TypeReference<OAuth2Claim>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OAuth2Scope createOAuth2Scope(String authServerId, OAuth2Scope oAuth2Scope) throws ApiException {
        return this.createOAuth2Scope(authServerId, oAuth2Scope, Collections.emptyMap());
    }

    public OAuth2Scope createOAuth2Scope(String authServerId, OAuth2Scope oAuth2Scope, Map<String, String> additionalHeaders) throws ApiException {
        OAuth2Scope localVarPostBody = oAuth2Scope;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling createOAuth2Scope");
        }
        if (oAuth2Scope == null) {
            throw new ApiException(400, "Missing the required parameter 'oAuth2Scope' when calling createOAuth2Scope");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/scopes".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OAuth2Scope> localVarReturnType = new TypeReference<OAuth2Scope>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deactivateAuthorizationServer(String authServerId) throws ApiException {
        this.deactivateAuthorizationServer(authServerId, Collections.emptyMap());
    }

    public void deactivateAuthorizationServer(String authServerId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deactivateAuthorizationServer");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/lifecycle/deactivate".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deactivateAuthorizationServerPolicy(String authServerId, String policyId) throws ApiException {
        this.deactivateAuthorizationServerPolicy(authServerId, policyId, Collections.emptyMap());
    }

    public void deactivateAuthorizationServerPolicy(String authServerId, String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deactivateAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deactivateAuthorizationServerPolicy");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/lifecycle/deactivate".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deactivateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId) throws ApiException {
        this.deactivateAuthorizationServerPolicyRule(authServerId, policyId, ruleId, Collections.emptyMap());
    }

    public void deactivateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deactivateAuthorizationServerPolicyRule");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deactivateAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling deactivateAuthorizationServerPolicyRule");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/deactivate".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteAssociatedServer(String authServerId, String associatedServerId) throws ApiException {
        this.deleteAssociatedServer(authServerId, associatedServerId, Collections.emptyMap());
    }

    public void deleteAssociatedServer(String authServerId, String associatedServerId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deleteAssociatedServer");
        }
        if (associatedServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'associatedServerId' when calling deleteAssociatedServer");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/associatedServers/{associatedServerId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{associatedServerId\\}", this.apiClient.escapeString(associatedServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteAuthorizationServer(String authServerId) throws ApiException {
        this.deleteAuthorizationServer(authServerId, Collections.emptyMap());
    }

    public void deleteAuthorizationServer(String authServerId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deleteAuthorizationServer");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteAuthorizationServerPolicy(String authServerId, String policyId) throws ApiException {
        this.deleteAuthorizationServerPolicy(authServerId, policyId, Collections.emptyMap());
    }

    public void deleteAuthorizationServerPolicy(String authServerId, String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deleteAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deleteAuthorizationServerPolicy");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId) throws ApiException {
        this.deleteAuthorizationServerPolicyRule(authServerId, policyId, ruleId, Collections.emptyMap());
    }

    public void deleteAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deleteAuthorizationServerPolicyRule");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deleteAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteAuthorizationServerPolicyRule");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteOAuth2Claim(String authServerId, String claimId) throws ApiException {
        this.deleteOAuth2Claim(authServerId, claimId, Collections.emptyMap());
    }

    public void deleteOAuth2Claim(String authServerId, String claimId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deleteOAuth2Claim");
        }
        if (claimId == null) {
            throw new ApiException(400, "Missing the required parameter 'claimId' when calling deleteOAuth2Claim");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/claims/{claimId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{claimId\\}", this.apiClient.escapeString(claimId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteOAuth2Scope(String authServerId, String scopeId) throws ApiException {
        this.deleteOAuth2Scope(authServerId, scopeId, Collections.emptyMap());
    }

    public void deleteOAuth2Scope(String authServerId, String scopeId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deleteOAuth2Scope");
        }
        if (scopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'scopeId' when calling deleteOAuth2Scope");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{scopeId\\}", this.apiClient.escapeString(scopeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public AuthorizationServer getAuthorizationServer(String authServerId) throws ApiException {
        return this.getAuthorizationServer(authServerId, Collections.emptyMap());
    }

    public AuthorizationServer getAuthorizationServer(String authServerId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling getAuthorizationServer");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthorizationServer> localVarReturnType = new TypeReference<AuthorizationServer>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthorizationServerPolicy getAuthorizationServerPolicy(String authServerId, String policyId) throws ApiException {
        return this.getAuthorizationServerPolicy(authServerId, policyId, Collections.emptyMap());
    }

    public AuthorizationServerPolicy getAuthorizationServerPolicy(String authServerId, String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling getAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling getAuthorizationServerPolicy");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthorizationServerPolicy> localVarReturnType = new TypeReference<AuthorizationServerPolicy>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthorizationServerPolicyRule getAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId) throws ApiException {
        return this.getAuthorizationServerPolicyRule(authServerId, policyId, ruleId, Collections.emptyMap());
    }

    public AuthorizationServerPolicyRule getAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling getAuthorizationServerPolicyRule");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling getAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling getAuthorizationServerPolicyRule");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthorizationServerPolicyRule> localVarReturnType = new TypeReference<AuthorizationServerPolicyRule>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OAuth2Claim getOAuth2Claim(String authServerId, String claimId) throws ApiException {
        return this.getOAuth2Claim(authServerId, claimId, Collections.emptyMap());
    }

    public OAuth2Claim getOAuth2Claim(String authServerId, String claimId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling getOAuth2Claim");
        }
        if (claimId == null) {
            throw new ApiException(400, "Missing the required parameter 'claimId' when calling getOAuth2Claim");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/claims/{claimId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{claimId\\}", this.apiClient.escapeString(claimId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OAuth2Claim> localVarReturnType = new TypeReference<OAuth2Claim>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OAuth2Scope getOAuth2Scope(String authServerId, String scopeId) throws ApiException {
        return this.getOAuth2Scope(authServerId, scopeId, Collections.emptyMap());
    }

    public OAuth2Scope getOAuth2Scope(String authServerId, String scopeId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling getOAuth2Scope");
        }
        if (scopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'scopeId' when calling getOAuth2Scope");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{scopeId\\}", this.apiClient.escapeString(scopeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OAuth2Scope> localVarReturnType = new TypeReference<OAuth2Scope>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OAuth2RefreshToken getRefreshTokenForAuthorizationServerAndClient(String authServerId, String clientId, String tokenId, String expand) throws ApiException {
        return this.getRefreshTokenForAuthorizationServerAndClient(authServerId, clientId, tokenId, expand, Collections.emptyMap());
    }

    public OAuth2RefreshToken getRefreshTokenForAuthorizationServerAndClient(String authServerId, String clientId, String tokenId, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling getRefreshTokenForAuthorizationServerAndClient");
        }
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling getRefreshTokenForAuthorizationServerAndClient");
        }
        if (tokenId == null) {
            throw new ApiException(400, "Missing the required parameter 'tokenId' when calling getRefreshTokenForAuthorizationServerAndClient");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString())).replaceAll("\\{tokenId\\}", this.apiClient.escapeString(tokenId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OAuth2RefreshToken> localVarReturnType = new TypeReference<OAuth2RefreshToken>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AuthorizationServer> listAssociatedServersByTrustedType(String authServerId, Boolean trusted, String q, Integer limit, String after) throws ApiException {
        return this.listAssociatedServersByTrustedType(authServerId, trusted, q, limit, after, Collections.emptyMap());
    }

    public List<AuthorizationServer> listAssociatedServersByTrustedType(String authServerId, Boolean trusted, String q, Integer limit, String after, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling listAssociatedServersByTrustedType");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/associatedServers".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("trusted", trusted));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AuthorizationServer>> localVarReturnType = new TypeReference<List<AuthorizationServer>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<JsonWebKey> listAuthorizationServerKeys(String authServerId) throws ApiException {
        return this.listAuthorizationServerKeys(authServerId, Collections.emptyMap());
    }

    public List<JsonWebKey> listAuthorizationServerKeys(String authServerId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling listAuthorizationServerKeys");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/credentials/keys".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<JsonWebKey>> localVarReturnType = new TypeReference<List<JsonWebKey>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AuthorizationServerPolicy> listAuthorizationServerPolicies(String authServerId) throws ApiException {
        return this.listAuthorizationServerPolicies(authServerId, Collections.emptyMap());
    }

    public List<AuthorizationServerPolicy> listAuthorizationServerPolicies(String authServerId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling listAuthorizationServerPolicies");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AuthorizationServerPolicy>> localVarReturnType = new TypeReference<List<AuthorizationServerPolicy>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AuthorizationServerPolicyRule> listAuthorizationServerPolicyRules(String authServerId, String policyId) throws ApiException {
        return this.listAuthorizationServerPolicyRules(authServerId, policyId, Collections.emptyMap());
    }

    public List<AuthorizationServerPolicyRule> listAuthorizationServerPolicyRules(String authServerId, String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling listAuthorizationServerPolicyRules");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling listAuthorizationServerPolicyRules");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AuthorizationServerPolicyRule>> localVarReturnType = new TypeReference<List<AuthorizationServerPolicyRule>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AuthorizationServer> listAuthorizationServers(String q, Integer limit, String after) throws ApiException {
        return this.listAuthorizationServers(q, limit, after, Collections.emptyMap());
    }

    public List<AuthorizationServer> listAuthorizationServers(String q, Integer limit, String after, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/authorizationServers";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AuthorizationServer>> localVarReturnType = new TypeReference<List<AuthorizationServer>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<OAuth2Claim> listOAuth2Claims(String authServerId) throws ApiException {
        return this.listOAuth2Claims(authServerId, Collections.emptyMap());
    }

    public List<OAuth2Claim> listOAuth2Claims(String authServerId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling listOAuth2Claims");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/claims".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<OAuth2Claim>> localVarReturnType = new TypeReference<List<OAuth2Claim>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<OAuth2Client> listOAuth2ClientsForAuthorizationServer(String authServerId) throws ApiException {
        return this.listOAuth2ClientsForAuthorizationServer(authServerId, Collections.emptyMap());
    }

    public List<OAuth2Client> listOAuth2ClientsForAuthorizationServer(String authServerId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling listOAuth2ClientsForAuthorizationServer");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/clients".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<OAuth2Client>> localVarReturnType = new TypeReference<List<OAuth2Client>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<OAuth2Scope> listOAuth2Scopes(String authServerId, String q, String filter, String cursor, Integer limit) throws ApiException {
        return this.listOAuth2Scopes(authServerId, q, filter, cursor, limit, Collections.emptyMap());
    }

    public List<OAuth2Scope> listOAuth2Scopes(String authServerId, String q, String filter, String cursor, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling listOAuth2Scopes");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/scopes".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<OAuth2Scope>> localVarReturnType = new TypeReference<List<OAuth2Scope>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<OAuth2RefreshToken> listRefreshTokensForAuthorizationServerAndClient(String authServerId, String clientId, String expand, String after, Integer limit) throws ApiException {
        return this.listRefreshTokensForAuthorizationServerAndClient(authServerId, clientId, expand, after, limit, Collections.emptyMap());
    }

    public List<OAuth2RefreshToken> listRefreshTokensForAuthorizationServerAndClient(String authServerId, String clientId, String expand, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling listRefreshTokensForAuthorizationServerAndClient");
        }
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling listRefreshTokensForAuthorizationServerAndClient");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<OAuth2RefreshToken>> localVarReturnType = new TypeReference<List<OAuth2RefreshToken>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthorizationServer replaceAuthorizationServer(String authServerId, AuthorizationServer authorizationServer) throws ApiException {
        return this.replaceAuthorizationServer(authServerId, authorizationServer, Collections.emptyMap());
    }

    public AuthorizationServer replaceAuthorizationServer(String authServerId, AuthorizationServer authorizationServer, Map<String, String> additionalHeaders) throws ApiException {
        AuthorizationServer localVarPostBody = authorizationServer;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServer");
        }
        if (authorizationServer == null) {
            throw new ApiException(400, "Missing the required parameter 'authorizationServer' when calling replaceAuthorizationServer");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthorizationServer> localVarReturnType = new TypeReference<AuthorizationServer>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthorizationServerPolicy replaceAuthorizationServerPolicy(String authServerId, String policyId, AuthorizationServerPolicy policy) throws ApiException {
        return this.replaceAuthorizationServerPolicy(authServerId, policyId, policy, Collections.emptyMap());
    }

    public AuthorizationServerPolicy replaceAuthorizationServerPolicy(String authServerId, String policyId, AuthorizationServerPolicy policy, Map<String, String> additionalHeaders) throws ApiException {
        AuthorizationServerPolicy localVarPostBody = policy;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicy");
        }
        if (policy == null) {
            throw new ApiException(400, "Missing the required parameter 'policy' when calling replaceAuthorizationServerPolicy");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthorizationServerPolicy> localVarReturnType = new TypeReference<AuthorizationServerPolicy>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AuthorizationServerPolicyRule replaceAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId, AuthorizationServerPolicyRule policyRule) throws ApiException {
        return this.replaceAuthorizationServerPolicyRule(authServerId, policyId, ruleId, policyRule, Collections.emptyMap());
    }

    public AuthorizationServerPolicyRule replaceAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId, AuthorizationServerPolicyRule policyRule, Map<String, String> additionalHeaders) throws ApiException {
        AuthorizationServerPolicyRule localVarPostBody = policyRule;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicyRule");
        }
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling replaceAuthorizationServerPolicyRule");
        }
        if (policyRule == null) {
            throw new ApiException(400, "Missing the required parameter 'policyRule' when calling replaceAuthorizationServerPolicyRule");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthorizationServerPolicyRule> localVarReturnType = new TypeReference<AuthorizationServerPolicyRule>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OAuth2Claim replaceOAuth2Claim(String authServerId, String claimId, OAuth2Claim oAuth2Claim) throws ApiException {
        return this.replaceOAuth2Claim(authServerId, claimId, oAuth2Claim, Collections.emptyMap());
    }

    public OAuth2Claim replaceOAuth2Claim(String authServerId, String claimId, OAuth2Claim oAuth2Claim, Map<String, String> additionalHeaders) throws ApiException {
        OAuth2Claim localVarPostBody = oAuth2Claim;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling replaceOAuth2Claim");
        }
        if (claimId == null) {
            throw new ApiException(400, "Missing the required parameter 'claimId' when calling replaceOAuth2Claim");
        }
        if (oAuth2Claim == null) {
            throw new ApiException(400, "Missing the required parameter 'oAuth2Claim' when calling replaceOAuth2Claim");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/claims/{claimId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{claimId\\}", this.apiClient.escapeString(claimId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OAuth2Claim> localVarReturnType = new TypeReference<OAuth2Claim>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OAuth2Scope replaceOAuth2Scope(String authServerId, String scopeId, OAuth2Scope oAuth2Scope) throws ApiException {
        return this.replaceOAuth2Scope(authServerId, scopeId, oAuth2Scope, Collections.emptyMap());
    }

    public OAuth2Scope replaceOAuth2Scope(String authServerId, String scopeId, OAuth2Scope oAuth2Scope, Map<String, String> additionalHeaders) throws ApiException {
        OAuth2Scope localVarPostBody = oAuth2Scope;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling replaceOAuth2Scope");
        }
        if (scopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'scopeId' when calling replaceOAuth2Scope");
        }
        if (oAuth2Scope == null) {
            throw new ApiException(400, "Missing the required parameter 'oAuth2Scope' when calling replaceOAuth2Scope");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{scopeId\\}", this.apiClient.escapeString(scopeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OAuth2Scope> localVarReturnType = new TypeReference<OAuth2Scope>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void revokeRefreshTokenForAuthorizationServerAndClient(String authServerId, String clientId, String tokenId) throws ApiException {
        this.revokeRefreshTokenForAuthorizationServerAndClient(authServerId, clientId, tokenId, Collections.emptyMap());
    }

    public void revokeRefreshTokenForAuthorizationServerAndClient(String authServerId, String clientId, String tokenId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling revokeRefreshTokenForAuthorizationServerAndClient");
        }
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling revokeRefreshTokenForAuthorizationServerAndClient");
        }
        if (tokenId == null) {
            throw new ApiException(400, "Missing the required parameter 'tokenId' when calling revokeRefreshTokenForAuthorizationServerAndClient");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString())).replaceAll("\\{tokenId\\}", this.apiClient.escapeString(tokenId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void revokeRefreshTokensForAuthorizationServerAndClient(String authServerId, String clientId) throws ApiException {
        this.revokeRefreshTokensForAuthorizationServerAndClient(authServerId, clientId, Collections.emptyMap());
    }

    public void revokeRefreshTokensForAuthorizationServerAndClient(String authServerId, String clientId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling revokeRefreshTokensForAuthorizationServerAndClient");
        }
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling revokeRefreshTokensForAuthorizationServerAndClient");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<JsonWebKey> rotateAuthorizationServerKeys(String authServerId, JwkUse use) throws ApiException {
        return this.rotateAuthorizationServerKeys(authServerId, use, Collections.emptyMap());
    }

    public List<JsonWebKey> rotateAuthorizationServerKeys(String authServerId, JwkUse use, Map<String, String> additionalHeaders) throws ApiException {
        JwkUse localVarPostBody = use;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling rotateAuthorizationServerKeys");
        }
        if (use == null) {
            throw new ApiException(400, "Missing the required parameter 'use' when calling rotateAuthorizationServerKeys");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/credentials/lifecycle/keyRotate".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<JsonWebKey>> localVarReturnType = new TypeReference<List<JsonWebKey>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

