/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.LinksSelf;
import org.openapitools.client.model.SessionAuthenticationMethod;
import org.openapitools.client.model.SessionIdentityProvider;
import org.openapitools.client.model.SessionStatus;

@JsonPropertyOrder(value={"amr", "createdAt", "expiresAt", "id", "idp", "lastFactorVerification", "lastPasswordVerification", "login", "status", "userId", "_links"})
public class Session
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AMR = "amr";
    private List<SessionAuthenticationMethod> amr = null;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_IDP = "idp";
    private SessionIdentityProvider idp;
    public static final String JSON_PROPERTY_LAST_FACTOR_VERIFICATION = "lastFactorVerification";
    private OffsetDateTime lastFactorVerification;
    public static final String JSON_PROPERTY_LAST_PASSWORD_VERIFICATION = "lastPasswordVerification";
    private OffsetDateTime lastPasswordVerification;
    public static final String JSON_PROPERTY_LOGIN = "login";
    private String login;
    public static final String JSON_PROPERTY_STATUS = "status";
    private SessionStatus status;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    @Nullable
    @ApiModelProperty(value="Authentication method reference")
    @JsonProperty(value="amr")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SessionAuthenticationMethod> getAmr() {
        return this.amr;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @ApiModelProperty(value="A timestamp when the Session expires")
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @Nullable
    @ApiModelProperty(value="A unique key for the Session")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public Session idp(SessionIdentityProvider idp) {
        this.idp = idp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="idp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SessionIdentityProvider getIdp() {
        return this.idp;
    }

    @JsonProperty(value="idp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdp(SessionIdentityProvider idp) {
        this.idp = idp;
    }

    @Nullable
    @ApiModelProperty(value="A timestamp when the user last performed multifactor authentication")
    @JsonProperty(value="lastFactorVerification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastFactorVerification() {
        return this.lastFactorVerification;
    }

    @Nullable
    @ApiModelProperty(value="A timestamp when the user last performed the primary or step-up authentication with a password")
    @JsonProperty(value="lastPasswordVerification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastPasswordVerification() {
        return this.lastPasswordVerification;
    }

    @Nullable
    @ApiModelProperty(value="A unique identifier for the user (username)")
    @JsonProperty(value="login")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLogin() {
        return this.login;
    }

    public Session status(SessionStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SessionStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(SessionStatus status) {
        this.status = status;
    }

    @Nullable
    @ApiModelProperty(value="A unique key for the user")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    public Session links(LinksSelf links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LinksSelf getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        return Objects.equals(this.amr, session.amr) && Objects.equals(this.createdAt, session.createdAt) && Objects.equals(this.expiresAt, session.expiresAt) && Objects.equals(this.id, session.id) && Objects.equals(this.idp, session.idp) && Objects.equals(this.lastFactorVerification, session.lastFactorVerification) && Objects.equals(this.lastPasswordVerification, session.lastPasswordVerification) && Objects.equals(this.login, session.login) && Objects.equals((Object)this.status, (Object)session.status) && Objects.equals(this.userId, session.userId) && Objects.equals(this.links, session.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amr, this.createdAt, this.expiresAt, this.id, this.idp, this.lastFactorVerification, this.lastPasswordVerification, this.login, this.status, this.userId, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Session {\n");
        sb.append("    amr: ").append(this.toIndentedString(this.amr)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    idp: ").append(this.toIndentedString(this.idp)).append("\n");
        sb.append("    lastFactorVerification: ").append(this.toIndentedString(this.lastFactorVerification)).append("\n");
        sb.append("    lastPasswordVerification: ").append(this.toIndentedString(this.lastPasswordVerification)).append("\n");
        sb.append("    login: ").append(this.toIndentedString(this.login)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

