/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.openapitools.client.model.LogStreamLinksSelfAndLifecycle;
import org.openapitools.client.model.LogStreamType;

@JsonPropertyOrder(value={"created", "id", "lastUpdated", "name", "status", "type", "_links"})
public class LogStream
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TYPE = "type";
    protected LogStreamType type;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private LogStreamLinksSelfAndLifecycle links;

    @Nonnull
    @ApiModelProperty(example="2022-10-21T16:59:59Z", required=true, value="Timestamp when the Log Stream object was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nonnull
    @ApiModelProperty(example="0oa1orzg0CHSgPcjZ0g4", required=true, value="Unique identifier for the Log Stream")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @Nonnull
    @ApiModelProperty(example="2022-10-21T17:15:10Z", required=true, value="Timestamp when the Log Stream object was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public LogStream name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="My AWS EventBridge log stream", required=true, value="Unique name for the Log Stream object")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Lifecycle status of the Log Stream object")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    public LogStream type(LogStreamType type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogStreamType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(LogStreamType type) {
        this.type = type;
    }

    public LogStream links(LogStreamLinksSelfAndLifecycle links) {
        this.links = links;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogStreamLinksSelfAndLifecycle getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLinks(LogStreamLinksSelfAndLifecycle links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogStream logStream = (LogStream)o;
        return Objects.equals(this.created, logStream.created) && Objects.equals(this.id, logStream.id) && Objects.equals(this.lastUpdated, logStream.lastUpdated) && Objects.equals(this.name, logStream.name) && Objects.equals((Object)this.status, (Object)logStream.status) && Objects.equals((Object)this.type, (Object)logStream.type) && Objects.equals(this.links, logStream.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.created, this.id, this.lastUpdated, this.name, this.status, this.type, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogStream {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

