/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.GroupOwnerOriginType;
import org.openapitools.client.model.GroupOwnerType;

@JsonPropertyOrder(value={"displayName", "id", "lastUpdated", "originId", "originType", "resolved", "type"})
public class GroupOwner
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_ORIGIN_ID = "originId";
    private String originId;
    public static final String JSON_PROPERTY_ORIGIN_TYPE = "originType";
    private GroupOwnerOriginType originType;
    public static final String JSON_PROPERTY_RESOLVED = "resolved";
    private Boolean resolved;
    public static final String JSON_PROPERTY_TYPE = "type";
    private GroupOwnerType type;

    @Nullable
    @ApiModelProperty(value="The display name of the group owner")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    public GroupOwner id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `id` of the group owner")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the group owner was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public GroupOwner originId(String originId) {
        this.originId = originId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the app instance if the `originType` is `APPLICATION`. This value is `NULL` if `originType` is `OKTA_DIRECTORY`.")
    @JsonProperty(value="originId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOriginId() {
        return this.originId;
    }

    @JsonProperty(value="originId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginId(String originId) {
        this.originId = originId;
    }

    public GroupOwner originType(GroupOwnerOriginType originType) {
        this.originType = originType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="originType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GroupOwnerOriginType getOriginType() {
        return this.originType;
    }

    @JsonProperty(value="originType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginType(GroupOwnerOriginType originType) {
        this.originType = originType;
    }

    public GroupOwner resolved(Boolean resolved) {
        this.resolved = resolved;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If `originType`is APPLICATION, this parameter is set to `FALSE` until the owner\u2019s `originId` is reconciled with an associated Okta ID.")
    @JsonProperty(value="resolved")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getResolved() {
        return this.resolved;
    }

    @JsonProperty(value="resolved")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResolved(Boolean resolved) {
        this.resolved = resolved;
    }

    public GroupOwner type(GroupOwnerType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GroupOwnerType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(GroupOwnerType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupOwner groupOwner = (GroupOwner)o;
        return Objects.equals(this.displayName, groupOwner.displayName) && Objects.equals(this.id, groupOwner.id) && Objects.equals(this.lastUpdated, groupOwner.lastUpdated) && Objects.equals(this.originId, groupOwner.originId) && Objects.equals((Object)this.originType, (Object)groupOwner.originType) && Objects.equals(this.resolved, groupOwner.resolved) && Objects.equals((Object)this.type, (Object)groupOwner.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.displayName, this.id, this.lastUpdated, this.originId, this.originType, this.resolved, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupOwner {\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    originId: ").append(this.toIndentedString(this.originId)).append("\n");
        sb.append("    originType: ").append(this.toIndentedString((Object)this.originType)).append("\n");
        sb.append("    resolved: ").append(this.toIndentedString(this.resolved)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

