/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.helper;

import com.okta.commons.lang.Assert;
import org.openapitools.client.model.AccessPolicy;
import org.openapitools.client.model.AccessPolicyRule;
import org.openapitools.client.model.Application;
import org.openapitools.client.model.AuthorizationServerPolicyRule;
import org.openapitools.client.model.AutoLoginApplication;
import org.openapitools.client.model.BasicAuthApplication;
import org.openapitools.client.model.BookmarkApplication;
import org.openapitools.client.model.BrowserPluginApplication;
import org.openapitools.client.model.CallUserFactor;
import org.openapitools.client.model.CustomHotpUserFactor;
import org.openapitools.client.model.EmailUserFactor;
import org.openapitools.client.model.HardwareUserFactor;
import org.openapitools.client.model.IdentityProviderPolicy;
import org.openapitools.client.model.MultifactorEnrollmentPolicy;
import org.openapitools.client.model.OktaSignOnPolicy;
import org.openapitools.client.model.OktaSignOnPolicyRule;
import org.openapitools.client.model.OpenIdConnectApplication;
import org.openapitools.client.model.PasswordPolicy;
import org.openapitools.client.model.PasswordPolicyRule;
import org.openapitools.client.model.Policy;
import org.openapitools.client.model.PolicyRule;
import org.openapitools.client.model.ProfileEnrollmentPolicy;
import org.openapitools.client.model.ProfileEnrollmentPolicyRule;
import org.openapitools.client.model.PushUserFactor;
import org.openapitools.client.model.SamlApplication;
import org.openapitools.client.model.SecurePasswordStoreApplication;
import org.openapitools.client.model.SecurityQuestionUserFactor;
import org.openapitools.client.model.SmsUserFactor;
import org.openapitools.client.model.TokenUserFactor;
import org.openapitools.client.model.TotpUserFactor;
import org.openapitools.client.model.U2fUserFactor;
import org.openapitools.client.model.UserFactor;
import org.openapitools.client.model.WebAuthnUserFactor;
import org.openapitools.client.model.WebUserFactor;
import org.openapitools.client.model.WsFederationApplication;

public class HelperUtil {
    public static Class<? extends Application> getApplicationType(Application application) {
        Assert.notNull((Object)application);
        Assert.notNull((Object)((Object)application.getSignOnMode()));
        switch (application.getSignOnMode()) {
            case AUTO_LOGIN: {
                return AutoLoginApplication.class;
            }
            case BASIC_AUTH: {
                return BasicAuthApplication.class;
            }
            case BOOKMARK: {
                return BookmarkApplication.class;
            }
            case BROWSER_PLUGIN: {
                return BrowserPluginApplication.class;
            }
            case OPENID_CONNECT: {
                return OpenIdConnectApplication.class;
            }
            case SAML_1_1: 
            case SAML_2_0: {
                return SamlApplication.class;
            }
            case SECURE_PASSWORD_STORE: {
                return SecurePasswordStoreApplication.class;
            }
            case WS_FEDERATION: {
                return WsFederationApplication.class;
            }
        }
        return Application.class;
    }

    public static Class<? extends Policy> getPolicyType(Policy policy) {
        Assert.notNull((Object)policy);
        Assert.notNull((Object)((Object)policy.getType()));
        switch (policy.getType()) {
            case ACCESS_POLICY: {
                return AccessPolicy.class;
            }
            case IDP_DISCOVERY: {
                return IdentityProviderPolicy.class;
            }
            case MFA_ENROLL: {
                return MultifactorEnrollmentPolicy.class;
            }
            case OKTA_SIGN_ON: {
                return OktaSignOnPolicy.class;
            }
            case PASSWORD: {
                return PasswordPolicy.class;
            }
            case PROFILE_ENROLLMENT: {
                return ProfileEnrollmentPolicy.class;
            }
        }
        return Policy.class;
    }

    public static Class<? extends UserFactor> getUserFactorType(UserFactor userFactor) {
        Assert.notNull((Object)userFactor);
        Assert.notNull((Object)((Object)userFactor.getFactorType()));
        switch (userFactor.getFactorType()) {
            case CALL: {
                return CallUserFactor.class;
            }
            case EMAIL: {
                return EmailUserFactor.class;
            }
            case PUSH: {
                return PushUserFactor.class;
            }
            case SMS: {
                return SmsUserFactor.class;
            }
            case QUESTION: {
                return SecurityQuestionUserFactor.class;
            }
            case TOKEN: {
                return TokenUserFactor.class;
            }
            case TOKEN_HARDWARE: {
                return HardwareUserFactor.class;
            }
            case TOKEN_HOTP: {
                return CustomHotpUserFactor.class;
            }
            case TOKEN_SOFTWARE_TOTP: {
                return TotpUserFactor.class;
            }
            case U2F: {
                return U2fUserFactor.class;
            }
            case WEB: {
                return WebUserFactor.class;
            }
            case WEBAUTHN: {
                return WebAuthnUserFactor.class;
            }
        }
        return UserFactor.class;
    }

    public static Class<? extends PolicyRule> getPolicyRuleType(PolicyRule policyRule) {
        Assert.notNull((Object)policyRule);
        Assert.notNull((Object)((Object)policyRule.getType()));
        switch (policyRule.getType()) {
            case ACCESS_POLICY: {
                return AccessPolicyRule.class;
            }
            case IDP_DISCOVERY: {
                return AuthorizationServerPolicyRule.class;
            }
            case PASSWORD: {
                return PasswordPolicyRule.class;
            }
            case PROFILE_ENROLLMENT: {
                return ProfileEnrollmentPolicyRule.class;
            }
            case SIGN_ON: {
                return OktaSignOnPolicyRule.class;
            }
        }
        return PolicyRule.class;
    }
}

