/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.ChromeBrowserVersion;
import org.openapitools.client.model.KeyTrustLevelOSMode;
import org.openapitools.client.model.OSVersion;
import org.openapitools.client.model.PasswordProtectionWarningTrigger;
import org.openapitools.client.model.SafeBrowsingProtectionLevel;

@ApiModel(description="Google Chrome Device Trust Connector provider")
@JsonPropertyOrder(value={"allowScreenLock", "browserVersion", "builtInDnsClientEnabled", "chromeRemoteDesktopAppBlocked", "deviceEnrollmentDomain", "diskEnrypted", "keyTrustLevel", "osFirewall", "osVersion", "passwordProtectionWarningTrigger", "realtimeUrlCheckMode", "safeBrowsingProtectionLevel", "screenLockSecured", "siteIsolationEnabled"})
public class DTCChromeOS
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ALLOW_SCREEN_LOCK = "allowScreenLock";
    private Boolean allowScreenLock;
    public static final String JSON_PROPERTY_BROWSER_VERSION = "browserVersion";
    private ChromeBrowserVersion browserVersion;
    public static final String JSON_PROPERTY_BUILT_IN_DNS_CLIENT_ENABLED = "builtInDnsClientEnabled";
    private Boolean builtInDnsClientEnabled;
    public static final String JSON_PROPERTY_CHROME_REMOTE_DESKTOP_APP_BLOCKED = "chromeRemoteDesktopAppBlocked";
    private Boolean chromeRemoteDesktopAppBlocked;
    public static final String JSON_PROPERTY_DEVICE_ENROLLMENT_DOMAIN = "deviceEnrollmentDomain";
    private String deviceEnrollmentDomain;
    public static final String JSON_PROPERTY_DISK_ENRYPTED = "diskEnrypted";
    private Boolean diskEnrypted;
    public static final String JSON_PROPERTY_KEY_TRUST_LEVEL = "keyTrustLevel";
    private KeyTrustLevelOSMode keyTrustLevel;
    public static final String JSON_PROPERTY_OS_FIREWALL = "osFirewall";
    private Boolean osFirewall;
    public static final String JSON_PROPERTY_OS_VERSION = "osVersion";
    private OSVersion osVersion;
    public static final String JSON_PROPERTY_PASSWORD_PROTECTION_WARNING_TRIGGER = "passwordProtectionWarningTrigger";
    private PasswordProtectionWarningTrigger passwordProtectionWarningTrigger;
    public static final String JSON_PROPERTY_REALTIME_URL_CHECK_MODE = "realtimeUrlCheckMode";
    private Boolean realtimeUrlCheckMode;
    public static final String JSON_PROPERTY_SAFE_BROWSING_PROTECTION_LEVEL = "safeBrowsingProtectionLevel";
    private SafeBrowsingProtectionLevel safeBrowsingProtectionLevel;
    public static final String JSON_PROPERTY_SCREEN_LOCK_SECURED = "screenLockSecured";
    private Boolean screenLockSecured;
    public static final String JSON_PROPERTY_SITE_ISOLATION_ENABLED = "siteIsolationEnabled";
    private Boolean siteIsolationEnabled;

    public DTCChromeOS allowScreenLock(Boolean allowScreenLock) {
        this.allowScreenLock = allowScreenLock;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the AllowScreenLock enterprise policy is enabled")
    @JsonProperty(value="allowScreenLock")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowScreenLock() {
        return this.allowScreenLock;
    }

    @JsonProperty(value="allowScreenLock")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowScreenLock(Boolean allowScreenLock) {
        this.allowScreenLock = allowScreenLock;
    }

    public DTCChromeOS browserVersion(ChromeBrowserVersion browserVersion) {
        this.browserVersion = browserVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="browserVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChromeBrowserVersion getBrowserVersion() {
        return this.browserVersion;
    }

    @JsonProperty(value="browserVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrowserVersion(ChromeBrowserVersion browserVersion) {
        this.browserVersion = browserVersion;
    }

    public DTCChromeOS builtInDnsClientEnabled(Boolean builtInDnsClientEnabled) {
        this.builtInDnsClientEnabled = builtInDnsClientEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if a software stack is used to communicate with the DNS server")
    @JsonProperty(value="builtInDnsClientEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getBuiltInDnsClientEnabled() {
        return this.builtInDnsClientEnabled;
    }

    @JsonProperty(value="builtInDnsClientEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBuiltInDnsClientEnabled(Boolean builtInDnsClientEnabled) {
        this.builtInDnsClientEnabled = builtInDnsClientEnabled;
    }

    public DTCChromeOS chromeRemoteDesktopAppBlocked(Boolean chromeRemoteDesktopAppBlocked) {
        this.chromeRemoteDesktopAppBlocked = chromeRemoteDesktopAppBlocked;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether access to the Chrome Remote Desktop application is blocked through a policy")
    @JsonProperty(value="chromeRemoteDesktopAppBlocked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getChromeRemoteDesktopAppBlocked() {
        return this.chromeRemoteDesktopAppBlocked;
    }

    @JsonProperty(value="chromeRemoteDesktopAppBlocked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChromeRemoteDesktopAppBlocked(Boolean chromeRemoteDesktopAppBlocked) {
        this.chromeRemoteDesktopAppBlocked = chromeRemoteDesktopAppBlocked;
    }

    public DTCChromeOS deviceEnrollmentDomain(String deviceEnrollmentDomain) {
        this.deviceEnrollmentDomain = deviceEnrollmentDomain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Enrollment domain of the customer that is currently managing the device")
    @JsonProperty(value="deviceEnrollmentDomain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceEnrollmentDomain() {
        return this.deviceEnrollmentDomain;
    }

    @JsonProperty(value="deviceEnrollmentDomain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceEnrollmentDomain(String deviceEnrollmentDomain) {
        this.deviceEnrollmentDomain = deviceEnrollmentDomain;
    }

    public DTCChromeOS diskEnrypted(Boolean diskEnrypted) {
        this.diskEnrypted = diskEnrypted;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the main disk is encrypted")
    @JsonProperty(value="diskEnrypted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDiskEnrypted() {
        return this.diskEnrypted;
    }

    @JsonProperty(value="diskEnrypted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDiskEnrypted(Boolean diskEnrypted) {
        this.diskEnrypted = diskEnrypted;
    }

    public DTCChromeOS keyTrustLevel(KeyTrustLevelOSMode keyTrustLevel) {
        this.keyTrustLevel = keyTrustLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="keyTrustLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KeyTrustLevelOSMode getKeyTrustLevel() {
        return this.keyTrustLevel;
    }

    @JsonProperty(value="keyTrustLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeyTrustLevel(KeyTrustLevelOSMode keyTrustLevel) {
        this.keyTrustLevel = keyTrustLevel;
    }

    public DTCChromeOS osFirewall(Boolean osFirewall) {
        this.osFirewall = osFirewall;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether a firewall is enabled at the OS-level on the device")
    @JsonProperty(value="osFirewall")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getOsFirewall() {
        return this.osFirewall;
    }

    @JsonProperty(value="osFirewall")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOsFirewall(Boolean osFirewall) {
        this.osFirewall = osFirewall;
    }

    public DTCChromeOS osVersion(OSVersion osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="osVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OSVersion getOsVersion() {
        return this.osVersion;
    }

    @JsonProperty(value="osVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOsVersion(OSVersion osVersion) {
        this.osVersion = osVersion;
    }

    public DTCChromeOS passwordProtectionWarningTrigger(PasswordProtectionWarningTrigger passwordProtectionWarningTrigger) {
        this.passwordProtectionWarningTrigger = passwordProtectionWarningTrigger;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="passwordProtectionWarningTrigger")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PasswordProtectionWarningTrigger getPasswordProtectionWarningTrigger() {
        return this.passwordProtectionWarningTrigger;
    }

    @JsonProperty(value="passwordProtectionWarningTrigger")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPasswordProtectionWarningTrigger(PasswordProtectionWarningTrigger passwordProtectionWarningTrigger) {
        this.passwordProtectionWarningTrigger = passwordProtectionWarningTrigger;
    }

    public DTCChromeOS realtimeUrlCheckMode(Boolean realtimeUrlCheckMode) {
        this.realtimeUrlCheckMode = realtimeUrlCheckMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether enterprise-grade (custom) unsafe URL scanning is enabled")
    @JsonProperty(value="realtimeUrlCheckMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRealtimeUrlCheckMode() {
        return this.realtimeUrlCheckMode;
    }

    @JsonProperty(value="realtimeUrlCheckMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRealtimeUrlCheckMode(Boolean realtimeUrlCheckMode) {
        this.realtimeUrlCheckMode = realtimeUrlCheckMode;
    }

    public DTCChromeOS safeBrowsingProtectionLevel(SafeBrowsingProtectionLevel safeBrowsingProtectionLevel) {
        this.safeBrowsingProtectionLevel = safeBrowsingProtectionLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="safeBrowsingProtectionLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SafeBrowsingProtectionLevel getSafeBrowsingProtectionLevel() {
        return this.safeBrowsingProtectionLevel;
    }

    @JsonProperty(value="safeBrowsingProtectionLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSafeBrowsingProtectionLevel(SafeBrowsingProtectionLevel safeBrowsingProtectionLevel) {
        this.safeBrowsingProtectionLevel = safeBrowsingProtectionLevel;
    }

    public DTCChromeOS screenLockSecured(Boolean screenLockSecured) {
        this.screenLockSecured = screenLockSecured;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the device is password-protected")
    @JsonProperty(value="screenLockSecured")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getScreenLockSecured() {
        return this.screenLockSecured;
    }

    @JsonProperty(value="screenLockSecured")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScreenLockSecured(Boolean screenLockSecured) {
        this.screenLockSecured = screenLockSecured;
    }

    public DTCChromeOS siteIsolationEnabled(Boolean siteIsolationEnabled) {
        this.siteIsolationEnabled = siteIsolationEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the Site Isolation (also known as **Site Per Process**) setting is enabled")
    @JsonProperty(value="siteIsolationEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSiteIsolationEnabled() {
        return this.siteIsolationEnabled;
    }

    @JsonProperty(value="siteIsolationEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSiteIsolationEnabled(Boolean siteIsolationEnabled) {
        this.siteIsolationEnabled = siteIsolationEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DTCChromeOS dtCChromeOS = (DTCChromeOS)o;
        return Objects.equals(this.allowScreenLock, dtCChromeOS.allowScreenLock) && Objects.equals(this.browserVersion, dtCChromeOS.browserVersion) && Objects.equals(this.builtInDnsClientEnabled, dtCChromeOS.builtInDnsClientEnabled) && Objects.equals(this.chromeRemoteDesktopAppBlocked, dtCChromeOS.chromeRemoteDesktopAppBlocked) && Objects.equals(this.deviceEnrollmentDomain, dtCChromeOS.deviceEnrollmentDomain) && Objects.equals(this.diskEnrypted, dtCChromeOS.diskEnrypted) && Objects.equals((Object)this.keyTrustLevel, (Object)dtCChromeOS.keyTrustLevel) && Objects.equals(this.osFirewall, dtCChromeOS.osFirewall) && Objects.equals(this.osVersion, dtCChromeOS.osVersion) && Objects.equals((Object)this.passwordProtectionWarningTrigger, (Object)dtCChromeOS.passwordProtectionWarningTrigger) && Objects.equals(this.realtimeUrlCheckMode, dtCChromeOS.realtimeUrlCheckMode) && Objects.equals((Object)this.safeBrowsingProtectionLevel, (Object)dtCChromeOS.safeBrowsingProtectionLevel) && Objects.equals(this.screenLockSecured, dtCChromeOS.screenLockSecured) && Objects.equals(this.siteIsolationEnabled, dtCChromeOS.siteIsolationEnabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowScreenLock, this.browserVersion, this.builtInDnsClientEnabled, this.chromeRemoteDesktopAppBlocked, this.deviceEnrollmentDomain, this.diskEnrypted, this.keyTrustLevel, this.osFirewall, this.osVersion, this.passwordProtectionWarningTrigger, this.realtimeUrlCheckMode, this.safeBrowsingProtectionLevel, this.screenLockSecured, this.siteIsolationEnabled});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DTCChromeOS {\n");
        sb.append("    allowScreenLock: ").append(this.toIndentedString(this.allowScreenLock)).append("\n");
        sb.append("    browserVersion: ").append(this.toIndentedString(this.browserVersion)).append("\n");
        sb.append("    builtInDnsClientEnabled: ").append(this.toIndentedString(this.builtInDnsClientEnabled)).append("\n");
        sb.append("    chromeRemoteDesktopAppBlocked: ").append(this.toIndentedString(this.chromeRemoteDesktopAppBlocked)).append("\n");
        sb.append("    deviceEnrollmentDomain: ").append(this.toIndentedString(this.deviceEnrollmentDomain)).append("\n");
        sb.append("    diskEnrypted: ").append(this.toIndentedString(this.diskEnrypted)).append("\n");
        sb.append("    keyTrustLevel: ").append(this.toIndentedString((Object)this.keyTrustLevel)).append("\n");
        sb.append("    osFirewall: ").append(this.toIndentedString(this.osFirewall)).append("\n");
        sb.append("    osVersion: ").append(this.toIndentedString(this.osVersion)).append("\n");
        sb.append("    passwordProtectionWarningTrigger: ").append(this.toIndentedString((Object)this.passwordProtectionWarningTrigger)).append("\n");
        sb.append("    realtimeUrlCheckMode: ").append(this.toIndentedString(this.realtimeUrlCheckMode)).append("\n");
        sb.append("    safeBrowsingProtectionLevel: ").append(this.toIndentedString((Object)this.safeBrowsingProtectionLevel)).append("\n");
        sb.append("    screenLockSecured: ").append(this.toIndentedString(this.screenLockSecured)).append("\n");
        sb.append("    siteIsolationEnabled: ").append(this.toIndentedString(this.siteIsolationEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

