/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.APIServiceIntegrationInstance;
import org.openapitools.client.model.APIServiceIntegrationInstanceSecret;
import org.openapitools.client.model.PostAPIServiceIntegrationInstance;
import org.openapitools.client.model.PostAPIServiceIntegrationInstanceRequest;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class ApiServiceIntegrationsApi {
    private ApiClient apiClient;

    public ApiServiceIntegrationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiServiceIntegrationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public APIServiceIntegrationInstanceSecret activateApiServiceIntegrationInstanceSecret(String apiServiceId, String secretId) throws ApiException {
        return this.activateApiServiceIntegrationInstanceSecret(apiServiceId, secretId, Collections.emptyMap());
    }

    public APIServiceIntegrationInstanceSecret activateApiServiceIntegrationInstanceSecret(String apiServiceId, String secretId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (apiServiceId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiServiceId' when calling activateApiServiceIntegrationInstanceSecret");
        }
        if (secretId == null) {
            throw new ApiException(400, "Missing the required parameter 'secretId' when calling activateApiServiceIntegrationInstanceSecret");
        }
        String localVarPath = "/integrations/api/v1/api-services/{apiServiceId}/credentials/secrets/{secretId}/lifecycle/activate".replaceAll("\\{apiServiceId\\}", this.apiClient.escapeString(apiServiceId.toString())).replaceAll("\\{secretId\\}", this.apiClient.escapeString(secretId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<APIServiceIntegrationInstanceSecret> localVarReturnType = new TypeReference<APIServiceIntegrationInstanceSecret>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PostAPIServiceIntegrationInstance createApiServiceIntegrationInstance(PostAPIServiceIntegrationInstanceRequest postAPIServiceIntegrationInstanceRequest) throws ApiException {
        return this.createApiServiceIntegrationInstance(postAPIServiceIntegrationInstanceRequest, Collections.emptyMap());
    }

    public PostAPIServiceIntegrationInstance createApiServiceIntegrationInstance(PostAPIServiceIntegrationInstanceRequest postAPIServiceIntegrationInstanceRequest, Map<String, String> additionalHeaders) throws ApiException {
        PostAPIServiceIntegrationInstanceRequest localVarPostBody = postAPIServiceIntegrationInstanceRequest;
        if (postAPIServiceIntegrationInstanceRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'postAPIServiceIntegrationInstanceRequest' when calling createApiServiceIntegrationInstance");
        }
        String localVarPath = "/integrations/api/v1/api-services";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken"};
        TypeReference<PostAPIServiceIntegrationInstance> localVarReturnType = new TypeReference<PostAPIServiceIntegrationInstance>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIServiceIntegrationInstanceSecret createApiServiceIntegrationInstanceSecret(String apiServiceId) throws ApiException {
        return this.createApiServiceIntegrationInstanceSecret(apiServiceId, Collections.emptyMap());
    }

    public APIServiceIntegrationInstanceSecret createApiServiceIntegrationInstanceSecret(String apiServiceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (apiServiceId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiServiceId' when calling createApiServiceIntegrationInstanceSecret");
        }
        String localVarPath = "/integrations/api/v1/api-services/{apiServiceId}/credentials/secrets".replaceAll("\\{apiServiceId\\}", this.apiClient.escapeString(apiServiceId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<APIServiceIntegrationInstanceSecret> localVarReturnType = new TypeReference<APIServiceIntegrationInstanceSecret>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIServiceIntegrationInstanceSecret deactivateApiServiceIntegrationInstanceSecret(String apiServiceId, String secretId) throws ApiException {
        return this.deactivateApiServiceIntegrationInstanceSecret(apiServiceId, secretId, Collections.emptyMap());
    }

    public APIServiceIntegrationInstanceSecret deactivateApiServiceIntegrationInstanceSecret(String apiServiceId, String secretId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (apiServiceId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiServiceId' when calling deactivateApiServiceIntegrationInstanceSecret");
        }
        if (secretId == null) {
            throw new ApiException(400, "Missing the required parameter 'secretId' when calling deactivateApiServiceIntegrationInstanceSecret");
        }
        String localVarPath = "/integrations/api/v1/api-services/{apiServiceId}/credentials/secrets/{secretId}/lifecycle/deactivate".replaceAll("\\{apiServiceId\\}", this.apiClient.escapeString(apiServiceId.toString())).replaceAll("\\{secretId\\}", this.apiClient.escapeString(secretId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<APIServiceIntegrationInstanceSecret> localVarReturnType = new TypeReference<APIServiceIntegrationInstanceSecret>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteApiServiceIntegrationInstance(String apiServiceId) throws ApiException {
        this.deleteApiServiceIntegrationInstance(apiServiceId, Collections.emptyMap());
    }

    public void deleteApiServiceIntegrationInstance(String apiServiceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (apiServiceId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiServiceId' when calling deleteApiServiceIntegrationInstance");
        }
        String localVarPath = "/integrations/api/v1/api-services/{apiServiceId}".replaceAll("\\{apiServiceId\\}", this.apiClient.escapeString(apiServiceId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteApiServiceIntegrationInstanceSecret(String apiServiceId, String secretId) throws ApiException {
        this.deleteApiServiceIntegrationInstanceSecret(apiServiceId, secretId, Collections.emptyMap());
    }

    public void deleteApiServiceIntegrationInstanceSecret(String apiServiceId, String secretId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (apiServiceId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiServiceId' when calling deleteApiServiceIntegrationInstanceSecret");
        }
        if (secretId == null) {
            throw new ApiException(400, "Missing the required parameter 'secretId' when calling deleteApiServiceIntegrationInstanceSecret");
        }
        String localVarPath = "/integrations/api/v1/api-services/{apiServiceId}/credentials/secrets/{secretId}".replaceAll("\\{apiServiceId\\}", this.apiClient.escapeString(apiServiceId.toString())).replaceAll("\\{secretId\\}", this.apiClient.escapeString(secretId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public APIServiceIntegrationInstance getApiServiceIntegrationInstance(String apiServiceId) throws ApiException {
        return this.getApiServiceIntegrationInstance(apiServiceId, Collections.emptyMap());
    }

    public APIServiceIntegrationInstance getApiServiceIntegrationInstance(String apiServiceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (apiServiceId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiServiceId' when calling getApiServiceIntegrationInstance");
        }
        String localVarPath = "/integrations/api/v1/api-services/{apiServiceId}".replaceAll("\\{apiServiceId\\}", this.apiClient.escapeString(apiServiceId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<APIServiceIntegrationInstance> localVarReturnType = new TypeReference<APIServiceIntegrationInstance>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<APIServiceIntegrationInstanceSecret> listApiServiceIntegrationInstanceSecrets(String apiServiceId) throws ApiException {
        return this.listApiServiceIntegrationInstanceSecrets(apiServiceId, Collections.emptyMap());
    }

    public List<APIServiceIntegrationInstanceSecret> listApiServiceIntegrationInstanceSecrets(String apiServiceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (apiServiceId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiServiceId' when calling listApiServiceIntegrationInstanceSecrets");
        }
        String localVarPath = "/integrations/api/v1/api-services/{apiServiceId}/credentials/secrets".replaceAll("\\{apiServiceId\\}", this.apiClient.escapeString(apiServiceId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<APIServiceIntegrationInstanceSecret>> localVarReturnType = new TypeReference<List<APIServiceIntegrationInstanceSecret>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<APIServiceIntegrationInstance> listApiServiceIntegrationInstances(String after) throws ApiException {
        return this.listApiServiceIntegrationInstances(after, Collections.emptyMap());
    }

    public List<APIServiceIntegrationInstance> listApiServiceIntegrationInstances(String after, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/integrations/api/v1/api-services";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<APIServiceIntegrationInstance>> localVarReturnType = new TypeReference<List<APIServiceIntegrationInstance>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

