/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.CreateResourceSetRequest;
import org.openapitools.client.model.ResourceSet;
import org.openapitools.client.model.ResourceSetBindingAddMembersRequest;
import org.openapitools.client.model.ResourceSetBindingCreateRequest;
import org.openapitools.client.model.ResourceSetBindingMember;
import org.openapitools.client.model.ResourceSetBindingMembers;
import org.openapitools.client.model.ResourceSetBindingResponse;
import org.openapitools.client.model.ResourceSetBindings;
import org.openapitools.client.model.ResourceSetResourcePatchRequest;
import org.openapitools.client.model.ResourceSetResources;
import org.openapitools.client.model.ResourceSets;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class ResourceSetApi {
    private ApiClient apiClient;

    public ResourceSetApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ResourceSetApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ResourceSetBindingResponse addMembersToBinding(String resourceSetId, String roleIdOrLabel, ResourceSetBindingAddMembersRequest instance) throws ApiException {
        return this.addMembersToBinding(resourceSetId, roleIdOrLabel, instance, Collections.emptyMap());
    }

    public ResourceSetBindingResponse addMembersToBinding(String resourceSetId, String roleIdOrLabel, ResourceSetBindingAddMembersRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        ResourceSetBindingAddMembersRequest localVarPostBody = instance;
        if (resourceSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetId' when calling addMembersToBinding");
        }
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling addMembersToBinding");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling addMembersToBinding");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members".replaceAll("\\{resourceSetId\\}", this.apiClient.escapeString(resourceSetId.toString())).replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetBindingResponse> localVarReturnType = new TypeReference<ResourceSetBindingResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSet addResourceSetResource(String resourceSetId, ResourceSetResourcePatchRequest instance) throws ApiException {
        return this.addResourceSetResource(resourceSetId, instance, Collections.emptyMap());
    }

    public ResourceSet addResourceSetResource(String resourceSetId, ResourceSetResourcePatchRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        ResourceSetResourcePatchRequest localVarPostBody = instance;
        if (resourceSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetId' when calling addResourceSetResource");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling addResourceSetResource");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetId}/resources".replaceAll("\\{resourceSetId\\}", this.apiClient.escapeString(resourceSetId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSet> localVarReturnType = new TypeReference<ResourceSet>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSet createResourceSet(CreateResourceSetRequest instance) throws ApiException {
        return this.createResourceSet(instance, Collections.emptyMap());
    }

    public ResourceSet createResourceSet(CreateResourceSetRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        CreateResourceSetRequest localVarPostBody = instance;
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling createResourceSet");
        }
        String localVarPath = "/api/v1/iam/resource-sets";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSet> localVarReturnType = new TypeReference<ResourceSet>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSetBindingResponse createResourceSetBinding(String resourceSetId, ResourceSetBindingCreateRequest instance) throws ApiException {
        return this.createResourceSetBinding(resourceSetId, instance, Collections.emptyMap());
    }

    public ResourceSetBindingResponse createResourceSetBinding(String resourceSetId, ResourceSetBindingCreateRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        ResourceSetBindingCreateRequest localVarPostBody = instance;
        if (resourceSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetId' when calling createResourceSetBinding");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling createResourceSetBinding");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetId}/bindings".replaceAll("\\{resourceSetId\\}", this.apiClient.escapeString(resourceSetId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetBindingResponse> localVarReturnType = new TypeReference<ResourceSetBindingResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteBinding(String resourceSetId, String roleIdOrLabel) throws ApiException {
        this.deleteBinding(resourceSetId, roleIdOrLabel, Collections.emptyMap());
    }

    public void deleteBinding(String resourceSetId, String roleIdOrLabel, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetId' when calling deleteBinding");
        }
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling deleteBinding");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}".replaceAll("\\{resourceSetId\\}", this.apiClient.escapeString(resourceSetId.toString())).replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteResourceSet(String resourceSetId) throws ApiException {
        this.deleteResourceSet(resourceSetId, Collections.emptyMap());
    }

    public void deleteResourceSet(String resourceSetId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetId' when calling deleteResourceSet");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetId}".replaceAll("\\{resourceSetId\\}", this.apiClient.escapeString(resourceSetId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteResourceSetResource(String resourceSetId, String resourceId) throws ApiException {
        this.deleteResourceSetResource(resourceSetId, resourceId, Collections.emptyMap());
    }

    public void deleteResourceSetResource(String resourceSetId, String resourceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetId' when calling deleteResourceSetResource");
        }
        if (resourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceId' when calling deleteResourceSetResource");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetId}/resources/{resourceId}".replaceAll("\\{resourceSetId\\}", this.apiClient.escapeString(resourceSetId.toString())).replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ResourceSetBindingResponse getBinding(String resourceSetId, String roleIdOrLabel) throws ApiException {
        return this.getBinding(resourceSetId, roleIdOrLabel, Collections.emptyMap());
    }

    public ResourceSetBindingResponse getBinding(String resourceSetId, String roleIdOrLabel, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetId' when calling getBinding");
        }
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling getBinding");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}".replaceAll("\\{resourceSetId\\}", this.apiClient.escapeString(resourceSetId.toString())).replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetBindingResponse> localVarReturnType = new TypeReference<ResourceSetBindingResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSetBindingMember getMemberOfBinding(String resourceSetId, String roleIdOrLabel, String memberId) throws ApiException {
        return this.getMemberOfBinding(resourceSetId, roleIdOrLabel, memberId, Collections.emptyMap());
    }

    public ResourceSetBindingMember getMemberOfBinding(String resourceSetId, String roleIdOrLabel, String memberId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetId' when calling getMemberOfBinding");
        }
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling getMemberOfBinding");
        }
        if (memberId == null) {
            throw new ApiException(400, "Missing the required parameter 'memberId' when calling getMemberOfBinding");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members/{memberId}".replaceAll("\\{resourceSetId\\}", this.apiClient.escapeString(resourceSetId.toString())).replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString())).replaceAll("\\{memberId\\}", this.apiClient.escapeString(memberId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetBindingMember> localVarReturnType = new TypeReference<ResourceSetBindingMember>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSet getResourceSet(String resourceSetId) throws ApiException {
        return this.getResourceSet(resourceSetId, Collections.emptyMap());
    }

    public ResourceSet getResourceSet(String resourceSetId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetId' when calling getResourceSet");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetId}".replaceAll("\\{resourceSetId\\}", this.apiClient.escapeString(resourceSetId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSet> localVarReturnType = new TypeReference<ResourceSet>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSetBindings listBindings(String resourceSetId, String after) throws ApiException {
        return this.listBindings(resourceSetId, after, Collections.emptyMap());
    }

    public ResourceSetBindings listBindings(String resourceSetId, String after, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetId' when calling listBindings");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetId}/bindings".replaceAll("\\{resourceSetId\\}", this.apiClient.escapeString(resourceSetId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetBindings> localVarReturnType = new TypeReference<ResourceSetBindings>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSetBindingMembers listMembersOfBinding(String resourceSetId, String roleIdOrLabel, String after) throws ApiException {
        return this.listMembersOfBinding(resourceSetId, roleIdOrLabel, after, Collections.emptyMap());
    }

    public ResourceSetBindingMembers listMembersOfBinding(String resourceSetId, String roleIdOrLabel, String after, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetId' when calling listMembersOfBinding");
        }
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling listMembersOfBinding");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members".replaceAll("\\{resourceSetId\\}", this.apiClient.escapeString(resourceSetId.toString())).replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetBindingMembers> localVarReturnType = new TypeReference<ResourceSetBindingMembers>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSetResources listResourceSetResources(String resourceSetId) throws ApiException {
        return this.listResourceSetResources(resourceSetId, Collections.emptyMap());
    }

    public ResourceSetResources listResourceSetResources(String resourceSetId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetId' when calling listResourceSetResources");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetId}/resources".replaceAll("\\{resourceSetId\\}", this.apiClient.escapeString(resourceSetId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetResources> localVarReturnType = new TypeReference<ResourceSetResources>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSets listResourceSets(String after) throws ApiException {
        return this.listResourceSets(after, Collections.emptyMap());
    }

    public ResourceSets listResourceSets(String after, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/iam/resource-sets";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSets> localVarReturnType = new TypeReference<ResourceSets>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSet replaceResourceSet(String resourceSetId, ResourceSet instance) throws ApiException {
        return this.replaceResourceSet(resourceSetId, instance, Collections.emptyMap());
    }

    public ResourceSet replaceResourceSet(String resourceSetId, ResourceSet instance, Map<String, String> additionalHeaders) throws ApiException {
        ResourceSet localVarPostBody = instance;
        if (resourceSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetId' when calling replaceResourceSet");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling replaceResourceSet");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetId}".replaceAll("\\{resourceSetId\\}", this.apiClient.escapeString(resourceSetId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSet> localVarReturnType = new TypeReference<ResourceSet>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void unassignMemberFromBinding(String resourceSetId, String roleIdOrLabel, String memberId) throws ApiException {
        this.unassignMemberFromBinding(resourceSetId, roleIdOrLabel, memberId, Collections.emptyMap());
    }

    public void unassignMemberFromBinding(String resourceSetId, String roleIdOrLabel, String memberId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetId' when calling unassignMemberFromBinding");
        }
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling unassignMemberFromBinding");
        }
        if (memberId == null) {
            throw new ApiException(400, "Missing the required parameter 'memberId' when calling unassignMemberFromBinding");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members/{memberId}".replaceAll("\\{resourceSetId\\}", this.apiClient.escapeString(resourceSetId.toString())).replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString())).replaceAll("\\{memberId\\}", this.apiClient.escapeString(memberId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

