/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.helper;

import com.fasterxml.jackson.core.type.TypeReference;
import com.okta.sdk.helper.HelperConstants;
import com.okta.sdk.helper.HelperUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Pair;
import org.openapitools.client.api.PolicyApi;
import org.openapitools.client.model.HttpMethod;
import org.openapitools.client.model.Policy;
import org.openapitools.client.model.PolicyRule;

public class PolicyApiHelper<T extends Policy>
extends PolicyApi {
    public PolicyApiHelper(PolicyApi policyApi) {
        super(policyApi.getApiClient());
    }

    public PolicyApiHelper(ApiClient apiClient) {
        super(apiClient);
    }

    public <T extends Policy> T createPolicyOfType(final Class<T> classType, Policy policy, Boolean activate) throws ApiException {
        ApiClient apiClient = this.getApiClient();
        if (policy == null) {
            throw new ApiException(400, "Missing the required parameter 'policy' when calling createPolicy");
        }
        String localVarPath = "/api/v1/policies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(apiClient.parameterToPair("activate", activate));
        String localVarAccept = apiClient.selectHeaderAccept(HelperConstants.MEDIA_TYPE);
        String localVarContentType = apiClient.selectHeaderContentType(HelperConstants.MEDIA_TYPE);
        TypeReference localVarReturnType = new TypeReference<T>(){

            public Type getType() {
                return classType;
            }
        };
        return (T)((Policy)apiClient.invokeAPI(localVarPath, HttpMethod.POST.name(), localVarQueryParams, new ArrayList<Pair>(), HelperConstants.QUERY_STRING_JOINER.toString(), policy, new HashMap<String, String>(), new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, HelperConstants.AUTH_NAMES, localVarReturnType));
    }

    public T getPolicy(String policyId, String expand) throws ApiException {
        ApiClient apiClient = this.getApiClient();
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling getPolicy");
        }
        String localVarPath = "/api/v1/policies/{policyId}".replaceAll("\\{policyId\\}", apiClient.escapeString(policyId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(apiClient.parameterToPair("expand", expand));
        String localVarAccept = apiClient.selectHeaderAccept(HelperConstants.MEDIA_TYPE);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        TypeReference localVarReturnType = new TypeReference<T>(){};
        Policy policy = (Policy)apiClient.invokeAPI(localVarPath, HttpMethod.GET.name(), localVarQueryParams, new ArrayList<Pair>(), HelperConstants.QUERY_STRING_JOINER.toString(), null, new HashMap<String, String>(), new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, HelperConstants.AUTH_NAMES, localVarReturnType);
        return (T)((Policy)PolicyApiHelper.getObjectMapper().convertValue((Object)policy, HelperUtil.getPolicyType(policy)));
    }

    @Override
    public List<Policy> listPolicies(String type, String status, String expand) throws ApiException {
        ApiClient apiClient = this.getApiClient();
        if (type == null) {
            throw new ApiException(400, "Missing the required parameter 'type' when calling listPolicies");
        }
        String localVarPath = "/api/v1/policies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(apiClient.parameterToPair("type", type));
        localVarQueryParams.addAll(apiClient.parameterToPair("status", status));
        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));
        TypeReference<List<Policy>> localVarReturnType = new TypeReference<List<Policy>>(){};
        List<Policy> policies = apiClient.invokeAPI(localVarPath, HttpMethod.GET.name(), localVarQueryParams, new ArrayList<Pair>(), HelperConstants.QUERY_STRING_JOINER.toString(), null, new HashMap<String, String>(), new HashMap<String, String>(), new HashMap<String, Object>(), apiClient.selectHeaderAccept(HelperConstants.MEDIA_TYPE), apiClient.selectHeaderContentType(new String[0]), HelperConstants.AUTH_NAMES, localVarReturnType);
        ArrayList<Policy> typedPolicies = new ArrayList<Policy>(policies.size());
        policies.forEach(policy -> typedPolicies.add((Policy)PolicyApiHelper.getObjectMapper().convertValue(policy, HelperUtil.getPolicyType(policy))));
        return typedPolicies;
    }

    public <T extends PolicyRule> T createPolicyRuleOfType(final Class<T> classType, String policyId, PolicyRule policyRule) throws ApiException {
        ApiClient apiClient = this.getApiClient();
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling createPolicyRule");
        }
        if (policyRule == null) {
            throw new ApiException(400, "Missing the required parameter 'policyRule' when calling createPolicyRule");
        }
        String localVarPath = "/api/v1/policies/{policyId}/rules".replaceAll("\\{policyId\\}", apiClient.escapeString(policyId));
        String localVarAccept = apiClient.selectHeaderAccept(HelperConstants.MEDIA_TYPE);
        String localVarContentType = apiClient.selectHeaderContentType(HelperConstants.MEDIA_TYPE);
        TypeReference localVarReturnType = new TypeReference<T>(){

            public Type getType() {
                return classType;
            }
        };
        return (T)((PolicyRule)apiClient.invokeAPI(localVarPath, HttpMethod.POST.name(), new ArrayList<Pair>(), new ArrayList<Pair>(), HelperConstants.QUERY_STRING_JOINER.toString(), policyRule, new HashMap<String, String>(), new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, HelperConstants.AUTH_NAMES, localVarReturnType));
    }
}

