/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.LinksSelf;

@JsonPropertyOrder(value={"created", "createdBy", "default", "description", "displayName", "id", "lastUpdated", "lastUpdatedBy", "name", "_links"})
public class UserType {
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
    private String createdBy;
    public static final String JSON_PROPERTY_DEFAULT = "default";
    private Boolean _default;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_LAST_UPDATED_BY = "lastUpdatedBy";
    private String lastUpdatedBy;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    @Nullable
    @ApiModelProperty(value="A timestamp from when the User Type was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(value="The user ID of the account that created the User Type")
    @JsonProperty(value="createdBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Nullable
    @ApiModelProperty(value="A boolean value to indicate if this is the default User Type")
    @JsonProperty(value="default")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDefault() {
        return this._default;
    }

    public UserType description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The human-readable description of the User Type")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public UserType displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The human-readable name of the User Type")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public UserType id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique key for the User Type")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    @Nullable
    @ApiModelProperty(value="A timestamp from when the User Type was most recently updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    @Nullable
    @ApiModelProperty(value="The user ID of the most recent account to edit the User Type")
    @JsonProperty(value="lastUpdatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public UserType name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the User Type")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public UserType links(LinksSelf links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LinksSelf getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserType userType = (UserType)o;
        return Objects.equals(this.created, userType.created) && Objects.equals(this.createdBy, userType.createdBy) && Objects.equals(this._default, userType._default) && Objects.equals(this.description, userType.description) && Objects.equals(this.displayName, userType.displayName) && Objects.equals(this.id, userType.id) && Objects.equals(this.lastUpdated, userType.lastUpdated) && Objects.equals(this.lastUpdatedBy, userType.lastUpdatedBy) && Objects.equals(this.name, userType.name) && Objects.equals(this.links, userType.links);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.createdBy, this._default, this.description, this.displayName, this.id, this.lastUpdated, this.lastUpdatedBy, this.name, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserType {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    _default: ").append(this.toIndentedString(this._default)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    lastUpdatedBy: ").append(this.toIndentedString(this.lastUpdatedBy)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

