/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.openapitools.client.model.AwsRegion;

@ApiModel(description="Specifies the configuration for the `aws_eventbridge` Log Stream type. This configuration can't be modified after creation.")
@JsonPropertyOrder(value={"accountId", "eventSourceName", "region"})
public class LogStreamSettingsAws {
    public static final String JSON_PROPERTY_ACCOUNT_ID = "accountId";
    private String accountId;
    public static final String JSON_PROPERTY_EVENT_SOURCE_NAME = "eventSourceName";
    private String eventSourceName;
    public static final String JSON_PROPERTY_REGION = "region";
    private AwsRegion region;

    public LogStreamSettingsAws accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="123456789012", required=true, value="Your AWS account ID")
    @JsonProperty(value="accountId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="accountId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public LogStreamSettingsAws eventSourceName(String eventSourceName) {
        this.eventSourceName = eventSourceName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="your-event-source-name", required=true, value="An alphanumeric name (no spaces) to identify this event source in AWS EventBridge")
    @JsonProperty(value="eventSourceName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEventSourceName() {
        return this.eventSourceName;
    }

    @JsonProperty(value="eventSourceName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventSourceName(String eventSourceName) {
        this.eventSourceName = eventSourceName;
    }

    public LogStreamSettingsAws region(AwsRegion region) {
        this.region = region;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AwsRegion getRegion() {
        return this.region;
    }

    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRegion(AwsRegion region) {
        this.region = region;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogStreamSettingsAws logStreamSettingsAws = (LogStreamSettingsAws)o;
        return Objects.equals(this.accountId, logStreamSettingsAws.accountId) && Objects.equals(this.eventSourceName, logStreamSettingsAws.eventSourceName) && Objects.equals((Object)this.region, (Object)logStreamSettingsAws.region);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.eventSourceName, this.region});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogStreamSettingsAws {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    eventSourceName: ").append(this.toIndentedString(this.eventSourceName)).append("\n");
        sb.append("    region: ").append(this.toIndentedString((Object)this.region)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

