/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.Realm;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class RealmApi {
    private ApiClient apiClient;

    public RealmApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RealmApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Realm createRealm(Realm body) throws ApiException {
        return this.createRealm(body, Collections.emptyMap());
    }

    public Realm createRealm(Realm body, Map<String, String> additionalHeaders) throws ApiException {
        Realm localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createRealm");
        }
        String localVarPath = "/api/v1/realms";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Realm> localVarReturnType = new TypeReference<Realm>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteRealm(String realmId) throws ApiException {
        this.deleteRealm(realmId, Collections.emptyMap());
    }

    public void deleteRealm(String realmId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (realmId == null) {
            throw new ApiException(400, "Missing the required parameter 'realmId' when calling deleteRealm");
        }
        String localVarPath = "/api/v1/realms/{realmId}".replaceAll("\\{realmId\\}", this.apiClient.escapeString(realmId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Realm getRealm(String realmId) throws ApiException {
        return this.getRealm(realmId, Collections.emptyMap());
    }

    public Realm getRealm(String realmId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (realmId == null) {
            throw new ApiException(400, "Missing the required parameter 'realmId' when calling getRealm");
        }
        String localVarPath = "/api/v1/realms/{realmId}".replaceAll("\\{realmId\\}", this.apiClient.escapeString(realmId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Realm> localVarReturnType = new TypeReference<Realm>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Realm> listRealms(Integer limit, String after, String search, String sortBy, String sortOrder) throws ApiException {
        return this.listRealms(limit, after, search, sortBy, sortOrder, Collections.emptyMap());
    }

    public List<Realm> listRealms(Integer limit, String after, String search, String sortBy, String sortOrder, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/realms";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("search", search));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<Realm>> localVarReturnType = new TypeReference<List<Realm>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Realm updateRealm(String realmId, Realm body) throws ApiException {
        return this.updateRealm(realmId, body, Collections.emptyMap());
    }

    public Realm updateRealm(String realmId, Realm body, Map<String, String> additionalHeaders) throws ApiException {
        Realm localVarPostBody = body;
        if (realmId == null) {
            throw new ApiException(400, "Missing the required parameter 'realmId' when calling updateRealm");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateRealm");
        }
        String localVarPath = "/api/v1/realms/{realmId}".replaceAll("\\{realmId\\}", this.apiClient.escapeString(realmId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Realm> localVarReturnType = new TypeReference<Realm>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

