/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.Brand;
import org.openapitools.client.model.BrandRequest;
import org.openapitools.client.model.BrandWithEmbedded;
import org.openapitools.client.model.CreateBrandRequest;
import org.openapitools.client.model.DomainResponse;
import org.openapitools.client.model.EmailCustomization;
import org.openapitools.client.model.EmailDefaultContent;
import org.openapitools.client.model.EmailPreview;
import org.openapitools.client.model.EmailSettings;
import org.openapitools.client.model.EmailTemplate;
import org.openapitools.client.model.ErrorPage;
import org.openapitools.client.model.HostedPage;
import org.openapitools.client.model.ImageUploadResponse;
import org.openapitools.client.model.PageRoot;
import org.openapitools.client.model.SignInPage;
import org.openapitools.client.model.Theme;
import org.openapitools.client.model.ThemeResponse;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class CustomizationApi {
    private ApiClient apiClient;

    public CustomizationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomizationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Brand createBrand(List<String> expand, CreateBrandRequest createBrandRequest) throws ApiException {
        return this.createBrand(expand, createBrandRequest, Collections.emptyMap());
    }

    public Brand createBrand(List<String> expand, CreateBrandRequest createBrandRequest, Map<String, String> additionalHeaders) throws ApiException {
        CreateBrandRequest localVarPostBody = createBrandRequest;
        String localVarPath = "/api/v1/brands";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Brand> localVarReturnType = new TypeReference<Brand>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailCustomization createEmailCustomization(String brandId, String templateName, EmailCustomization instance) throws ApiException {
        return this.createEmailCustomization(brandId, templateName, instance, Collections.emptyMap());
    }

    public EmailCustomization createEmailCustomization(String brandId, String templateName, EmailCustomization instance, Map<String, String> additionalHeaders) throws ApiException {
        EmailCustomization localVarPostBody = instance;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling createEmailCustomization");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling createEmailCustomization");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/customizations".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailCustomization> localVarReturnType = new TypeReference<EmailCustomization>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteAllCustomizations(String brandId, String templateName) throws ApiException {
        this.deleteAllCustomizations(brandId, templateName, Collections.emptyMap());
    }

    public void deleteAllCustomizations(String brandId, String templateName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteAllCustomizations");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling deleteAllCustomizations");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/customizations".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteBrand(String brandId, List<String> expand) throws ApiException {
        this.deleteBrand(brandId, expand, Collections.emptyMap());
    }

    public void deleteBrand(String brandId, List<String> expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteBrand");
        }
        String localVarPath = "/api/v1/brands/{brandId}".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteBrandThemeBackgroundImage(String brandId, String themeId) throws ApiException {
        this.deleteBrandThemeBackgroundImage(brandId, themeId, Collections.emptyMap());
    }

    public void deleteBrandThemeBackgroundImage(String brandId, String themeId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteBrandThemeBackgroundImage");
        }
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling deleteBrandThemeBackgroundImage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/background-image".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{themeId\\}", this.apiClient.escapeString(themeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteBrandThemeFavicon(String brandId, String themeId) throws ApiException {
        this.deleteBrandThemeFavicon(brandId, themeId, Collections.emptyMap());
    }

    public void deleteBrandThemeFavicon(String brandId, String themeId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteBrandThemeFavicon");
        }
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling deleteBrandThemeFavicon");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/favicon".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{themeId\\}", this.apiClient.escapeString(themeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteBrandThemeLogo(String brandId, String themeId) throws ApiException {
        this.deleteBrandThemeLogo(brandId, themeId, Collections.emptyMap());
    }

    public void deleteBrandThemeLogo(String brandId, String themeId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteBrandThemeLogo");
        }
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling deleteBrandThemeLogo");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/logo".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{themeId\\}", this.apiClient.escapeString(themeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteCustomizedErrorPage(String brandId) throws ApiException {
        this.deleteCustomizedErrorPage(brandId, Collections.emptyMap());
    }

    public void deleteCustomizedErrorPage(String brandId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteCustomizedErrorPage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/error/customized".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteCustomizedSignInPage(String brandId) throws ApiException {
        this.deleteCustomizedSignInPage(brandId, Collections.emptyMap());
    }

    public void deleteCustomizedSignInPage(String brandId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteCustomizedSignInPage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/sign-in/customized".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteEmailCustomization(String brandId, String templateName, String customizationId) throws ApiException {
        this.deleteEmailCustomization(brandId, templateName, customizationId, Collections.emptyMap());
    }

    public void deleteEmailCustomization(String brandId, String templateName, String customizationId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteEmailCustomization");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling deleteEmailCustomization");
        }
        if (customizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'customizationId' when calling deleteEmailCustomization");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString())).replaceAll("\\{customizationId\\}", this.apiClient.escapeString(customizationId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deletePreviewErrorPage(String brandId) throws ApiException {
        this.deletePreviewErrorPage(brandId, Collections.emptyMap());
    }

    public void deletePreviewErrorPage(String brandId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deletePreviewErrorPage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/error/preview".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deletePreviewSignInPage(String brandId) throws ApiException {
        this.deletePreviewSignInPage(brandId, Collections.emptyMap());
    }

    public void deletePreviewSignInPage(String brandId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deletePreviewSignInPage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/sign-in/preview".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public BrandWithEmbedded getBrand(String brandId, List<String> expand) throws ApiException {
        return this.getBrand(brandId, expand, Collections.emptyMap());
    }

    public BrandWithEmbedded getBrand(String brandId, List<String> expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getBrand");
        }
        String localVarPath = "/api/v1/brands/{brandId}".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<BrandWithEmbedded> localVarReturnType = new TypeReference<BrandWithEmbedded>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ThemeResponse getBrandTheme(String brandId, String themeId) throws ApiException {
        return this.getBrandTheme(brandId, themeId, Collections.emptyMap());
    }

    public ThemeResponse getBrandTheme(String brandId, String themeId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getBrandTheme");
        }
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling getBrandTheme");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{themeId\\}", this.apiClient.escapeString(themeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ThemeResponse> localVarReturnType = new TypeReference<ThemeResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailPreview getCustomizationPreview(String brandId, String templateName, String customizationId) throws ApiException {
        return this.getCustomizationPreview(brandId, templateName, customizationId, Collections.emptyMap());
    }

    public EmailPreview getCustomizationPreview(String brandId, String templateName, String customizationId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getCustomizationPreview");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling getCustomizationPreview");
        }
        if (customizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'customizationId' when calling getCustomizationPreview");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}/preview".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString())).replaceAll("\\{customizationId\\}", this.apiClient.escapeString(customizationId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailPreview> localVarReturnType = new TypeReference<EmailPreview>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ErrorPage getCustomizedErrorPage(String brandId) throws ApiException {
        return this.getCustomizedErrorPage(brandId, Collections.emptyMap());
    }

    public ErrorPage getCustomizedErrorPage(String brandId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getCustomizedErrorPage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/error/customized".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ErrorPage> localVarReturnType = new TypeReference<ErrorPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SignInPage getCustomizedSignInPage(String brandId) throws ApiException {
        return this.getCustomizedSignInPage(brandId, Collections.emptyMap());
    }

    public SignInPage getCustomizedSignInPage(String brandId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getCustomizedSignInPage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/sign-in/customized".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<SignInPage> localVarReturnType = new TypeReference<SignInPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ErrorPage getDefaultErrorPage(String brandId) throws ApiException {
        return this.getDefaultErrorPage(brandId, Collections.emptyMap());
    }

    public ErrorPage getDefaultErrorPage(String brandId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getDefaultErrorPage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/error/default".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ErrorPage> localVarReturnType = new TypeReference<ErrorPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SignInPage getDefaultSignInPage(String brandId) throws ApiException {
        return this.getDefaultSignInPage(brandId, Collections.emptyMap());
    }

    public SignInPage getDefaultSignInPage(String brandId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getDefaultSignInPage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/sign-in/default".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<SignInPage> localVarReturnType = new TypeReference<SignInPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailCustomization getEmailCustomization(String brandId, String templateName, String customizationId) throws ApiException {
        return this.getEmailCustomization(brandId, templateName, customizationId, Collections.emptyMap());
    }

    public EmailCustomization getEmailCustomization(String brandId, String templateName, String customizationId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getEmailCustomization");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling getEmailCustomization");
        }
        if (customizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'customizationId' when calling getEmailCustomization");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString())).replaceAll("\\{customizationId\\}", this.apiClient.escapeString(customizationId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailCustomization> localVarReturnType = new TypeReference<EmailCustomization>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailDefaultContent getEmailDefaultContent(String brandId, String templateName, String language) throws ApiException {
        return this.getEmailDefaultContent(brandId, templateName, language, Collections.emptyMap());
    }

    public EmailDefaultContent getEmailDefaultContent(String brandId, String templateName, String language, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getEmailDefaultContent");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling getEmailDefaultContent");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/default-content".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("language", language));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailDefaultContent> localVarReturnType = new TypeReference<EmailDefaultContent>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailPreview getEmailDefaultPreview(String brandId, String templateName, String language) throws ApiException {
        return this.getEmailDefaultPreview(brandId, templateName, language, Collections.emptyMap());
    }

    public EmailPreview getEmailDefaultPreview(String brandId, String templateName, String language, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getEmailDefaultPreview");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling getEmailDefaultPreview");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/default-content/preview".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("language", language));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailPreview> localVarReturnType = new TypeReference<EmailPreview>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailSettings getEmailSettings(String brandId, String templateName) throws ApiException {
        return this.getEmailSettings(brandId, templateName, Collections.emptyMap());
    }

    public EmailSettings getEmailSettings(String brandId, String templateName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getEmailSettings");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling getEmailSettings");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/settings".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailSettings> localVarReturnType = new TypeReference<EmailSettings>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailTemplate getEmailTemplate(String brandId, String templateName, List<String> expand) throws ApiException {
        return this.getEmailTemplate(brandId, templateName, expand, Collections.emptyMap());
    }

    public EmailTemplate getEmailTemplate(String brandId, String templateName, List<String> expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getEmailTemplate");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling getEmailTemplate");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailTemplate> localVarReturnType = new TypeReference<EmailTemplate>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PageRoot getErrorPage(String brandId, List<String> expand) throws ApiException {
        return this.getErrorPage(brandId, expand, Collections.emptyMap());
    }

    public PageRoot getErrorPage(String brandId, List<String> expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getErrorPage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/error".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<PageRoot> localVarReturnType = new TypeReference<PageRoot>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ErrorPage getPreviewErrorPage(String brandId) throws ApiException {
        return this.getPreviewErrorPage(brandId, Collections.emptyMap());
    }

    public ErrorPage getPreviewErrorPage(String brandId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getPreviewErrorPage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/error/preview".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ErrorPage> localVarReturnType = new TypeReference<ErrorPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SignInPage getPreviewSignInPage(String brandId) throws ApiException {
        return this.getPreviewSignInPage(brandId, Collections.emptyMap());
    }

    public SignInPage getPreviewSignInPage(String brandId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getPreviewSignInPage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/sign-in/preview".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<SignInPage> localVarReturnType = new TypeReference<SignInPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PageRoot getSignInPage(String brandId, List<String> expand) throws ApiException {
        return this.getSignInPage(brandId, expand, Collections.emptyMap());
    }

    public PageRoot getSignInPage(String brandId, List<String> expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getSignInPage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/sign-in".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<PageRoot> localVarReturnType = new TypeReference<PageRoot>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public HostedPage getSignOutPageSettings(String brandId) throws ApiException {
        return this.getSignOutPageSettings(brandId, Collections.emptyMap());
    }

    public HostedPage getSignOutPageSettings(String brandId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getSignOutPageSettings");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/sign-out/customized".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<HostedPage> localVarReturnType = new TypeReference<HostedPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<String> listAllSignInWidgetVersions(String brandId) throws ApiException {
        return this.listAllSignInWidgetVersions(brandId, Collections.emptyMap());
    }

    public List<String> listAllSignInWidgetVersions(String brandId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling listAllSignInWidgetVersions");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/sign-in/widget-versions".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<String>> localVarReturnType = new TypeReference<List<String>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<DomainResponse> listBrandDomains(String brandId) throws ApiException {
        return this.listBrandDomains(brandId, Collections.emptyMap());
    }

    public List<DomainResponse> listBrandDomains(String brandId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling listBrandDomains");
        }
        String localVarPath = "/api/v1/brands/{brandId}/domains".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<DomainResponse>> localVarReturnType = new TypeReference<List<DomainResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ThemeResponse> listBrandThemes(String brandId) throws ApiException {
        return this.listBrandThemes(brandId, Collections.emptyMap());
    }

    public List<ThemeResponse> listBrandThemes(String brandId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling listBrandThemes");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<ThemeResponse>> localVarReturnType = new TypeReference<List<ThemeResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<BrandWithEmbedded> listBrands(List<String> expand) throws ApiException {
        return this.listBrands(expand, Collections.emptyMap());
    }

    public List<BrandWithEmbedded> listBrands(List<String> expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/brands";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<BrandWithEmbedded>> localVarReturnType = new TypeReference<List<BrandWithEmbedded>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<EmailCustomization> listEmailCustomizations(String brandId, String templateName, String after, Integer limit) throws ApiException {
        return this.listEmailCustomizations(brandId, templateName, after, limit, Collections.emptyMap());
    }

    public List<EmailCustomization> listEmailCustomizations(String brandId, String templateName, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling listEmailCustomizations");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling listEmailCustomizations");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/customizations".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<EmailCustomization>> localVarReturnType = new TypeReference<List<EmailCustomization>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<EmailTemplate> listEmailTemplates(String brandId, String after, Integer limit, List<String> expand) throws ApiException {
        return this.listEmailTemplates(brandId, after, limit, expand, Collections.emptyMap());
    }

    public List<EmailTemplate> listEmailTemplates(String brandId, String after, Integer limit, List<String> expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling listEmailTemplates");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<EmailTemplate>> localVarReturnType = new TypeReference<List<EmailTemplate>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Brand replaceBrand(String brandId, BrandRequest brand, List<String> expand) throws ApiException {
        return this.replaceBrand(brandId, brand, expand, Collections.emptyMap());
    }

    public Brand replaceBrand(String brandId, BrandRequest brand, List<String> expand, Map<String, String> additionalHeaders) throws ApiException {
        BrandRequest localVarPostBody = brand;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling replaceBrand");
        }
        if (brand == null) {
            throw new ApiException(400, "Missing the required parameter 'brand' when calling replaceBrand");
        }
        String localVarPath = "/api/v1/brands/{brandId}".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Brand> localVarReturnType = new TypeReference<Brand>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ThemeResponse replaceBrandTheme(String brandId, String themeId, Theme theme) throws ApiException {
        return this.replaceBrandTheme(brandId, themeId, theme, Collections.emptyMap());
    }

    public ThemeResponse replaceBrandTheme(String brandId, String themeId, Theme theme, Map<String, String> additionalHeaders) throws ApiException {
        Theme localVarPostBody = theme;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling replaceBrandTheme");
        }
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling replaceBrandTheme");
        }
        if (theme == null) {
            throw new ApiException(400, "Missing the required parameter 'theme' when calling replaceBrandTheme");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{themeId\\}", this.apiClient.escapeString(themeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ThemeResponse> localVarReturnType = new TypeReference<ThemeResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ErrorPage replaceCustomizedErrorPage(String brandId, ErrorPage errorPage) throws ApiException {
        return this.replaceCustomizedErrorPage(brandId, errorPage, Collections.emptyMap());
    }

    public ErrorPage replaceCustomizedErrorPage(String brandId, ErrorPage errorPage, Map<String, String> additionalHeaders) throws ApiException {
        ErrorPage localVarPostBody = errorPage;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling replaceCustomizedErrorPage");
        }
        if (errorPage == null) {
            throw new ApiException(400, "Missing the required parameter 'errorPage' when calling replaceCustomizedErrorPage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/error/customized".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ErrorPage> localVarReturnType = new TypeReference<ErrorPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SignInPage replaceCustomizedSignInPage(String brandId, SignInPage signInPage) throws ApiException {
        return this.replaceCustomizedSignInPage(brandId, signInPage, Collections.emptyMap());
    }

    public SignInPage replaceCustomizedSignInPage(String brandId, SignInPage signInPage, Map<String, String> additionalHeaders) throws ApiException {
        SignInPage localVarPostBody = signInPage;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling replaceCustomizedSignInPage");
        }
        if (signInPage == null) {
            throw new ApiException(400, "Missing the required parameter 'signInPage' when calling replaceCustomizedSignInPage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/sign-in/customized".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<SignInPage> localVarReturnType = new TypeReference<SignInPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailCustomization replaceEmailCustomization(String brandId, String templateName, String customizationId, EmailCustomization instance) throws ApiException {
        return this.replaceEmailCustomization(brandId, templateName, customizationId, instance, Collections.emptyMap());
    }

    public EmailCustomization replaceEmailCustomization(String brandId, String templateName, String customizationId, EmailCustomization instance, Map<String, String> additionalHeaders) throws ApiException {
        EmailCustomization localVarPostBody = instance;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling replaceEmailCustomization");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling replaceEmailCustomization");
        }
        if (customizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'customizationId' when calling replaceEmailCustomization");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString())).replaceAll("\\{customizationId\\}", this.apiClient.escapeString(customizationId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailCustomization> localVarReturnType = new TypeReference<EmailCustomization>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void replaceEmailSettings(String brandId, String templateName, EmailSettings emailSettings) throws ApiException {
        this.replaceEmailSettings(brandId, templateName, emailSettings, Collections.emptyMap());
    }

    public void replaceEmailSettings(String brandId, String templateName, EmailSettings emailSettings, Map<String, String> additionalHeaders) throws ApiException {
        EmailSettings localVarPostBody = emailSettings;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling replaceEmailSettings");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling replaceEmailSettings");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/settings".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ErrorPage replacePreviewErrorPage(String brandId, ErrorPage errorPage) throws ApiException {
        return this.replacePreviewErrorPage(brandId, errorPage, Collections.emptyMap());
    }

    public ErrorPage replacePreviewErrorPage(String brandId, ErrorPage errorPage, Map<String, String> additionalHeaders) throws ApiException {
        ErrorPage localVarPostBody = errorPage;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling replacePreviewErrorPage");
        }
        if (errorPage == null) {
            throw new ApiException(400, "Missing the required parameter 'errorPage' when calling replacePreviewErrorPage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/error/preview".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ErrorPage> localVarReturnType = new TypeReference<ErrorPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SignInPage replacePreviewSignInPage(String brandId, SignInPage signInPage) throws ApiException {
        return this.replacePreviewSignInPage(brandId, signInPage, Collections.emptyMap());
    }

    public SignInPage replacePreviewSignInPage(String brandId, SignInPage signInPage, Map<String, String> additionalHeaders) throws ApiException {
        SignInPage localVarPostBody = signInPage;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling replacePreviewSignInPage");
        }
        if (signInPage == null) {
            throw new ApiException(400, "Missing the required parameter 'signInPage' when calling replacePreviewSignInPage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/sign-in/preview".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<SignInPage> localVarReturnType = new TypeReference<SignInPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public HostedPage replaceSignOutPageSettings(String brandId, HostedPage hostedPage) throws ApiException {
        return this.replaceSignOutPageSettings(brandId, hostedPage, Collections.emptyMap());
    }

    public HostedPage replaceSignOutPageSettings(String brandId, HostedPage hostedPage, Map<String, String> additionalHeaders) throws ApiException {
        HostedPage localVarPostBody = hostedPage;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling replaceSignOutPageSettings");
        }
        if (hostedPage == null) {
            throw new ApiException(400, "Missing the required parameter 'hostedPage' when calling replaceSignOutPageSettings");
        }
        String localVarPath = "/api/v1/brands/{brandId}/pages/sign-out/customized".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<HostedPage> localVarReturnType = new TypeReference<HostedPage>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void sendTestEmail(String brandId, String templateName, String language) throws ApiException {
        this.sendTestEmail(brandId, templateName, language, Collections.emptyMap());
    }

    public void sendTestEmail(String brandId, String templateName, String language, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling sendTestEmail");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling sendTestEmail");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/test".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("language", language));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ImageUploadResponse uploadBrandThemeBackgroundImage(String brandId, String themeId, File _file) throws ApiException {
        return this.uploadBrandThemeBackgroundImage(brandId, themeId, _file, Collections.emptyMap());
    }

    public ImageUploadResponse uploadBrandThemeBackgroundImage(String brandId, String themeId, File _file, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling uploadBrandThemeBackgroundImage");
        }
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling uploadBrandThemeBackgroundImage");
        }
        if (_file == null) {
            throw new ApiException(400, "Missing the required parameter '_file' when calling uploadBrandThemeBackgroundImage");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/background-image".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{themeId\\}", this.apiClient.escapeString(themeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ImageUploadResponse> localVarReturnType = new TypeReference<ImageUploadResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ImageUploadResponse uploadBrandThemeFavicon(String brandId, String themeId, File _file) throws ApiException {
        return this.uploadBrandThemeFavicon(brandId, themeId, _file, Collections.emptyMap());
    }

    public ImageUploadResponse uploadBrandThemeFavicon(String brandId, String themeId, File _file, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling uploadBrandThemeFavicon");
        }
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling uploadBrandThemeFavicon");
        }
        if (_file == null) {
            throw new ApiException(400, "Missing the required parameter '_file' when calling uploadBrandThemeFavicon");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/favicon".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{themeId\\}", this.apiClient.escapeString(themeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ImageUploadResponse> localVarReturnType = new TypeReference<ImageUploadResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ImageUploadResponse uploadBrandThemeLogo(String brandId, String themeId, File _file) throws ApiException {
        return this.uploadBrandThemeLogo(brandId, themeId, _file, Collections.emptyMap());
    }

    public ImageUploadResponse uploadBrandThemeLogo(String brandId, String themeId, File _file, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling uploadBrandThemeLogo");
        }
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling uploadBrandThemeLogo");
        }
        if (_file == null) {
            throw new ApiException(400, "Missing the required parameter '_file' when calling uploadBrandThemeLogo");
        }
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/logo".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{themeId\\}", this.apiClient.escapeString(themeId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ImageUploadResponse> localVarReturnType = new TypeReference<ImageUploadResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

