/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.NotificationType;
import org.openapitools.client.model.SubscriptionLinks;
import org.openapitools.client.model.SubscriptionStatus;

@JsonPropertyOrder(value={"channels", "notificationType", "status", "_links"})
public class Subscription {
    public static final String JSON_PROPERTY_CHANNELS = "channels";
    private List<String> channels = null;
    public static final String JSON_PROPERTY_NOTIFICATION_TYPE = "notificationType";
    private NotificationType notificationType;
    public static final String JSON_PROPERTY_STATUS = "status";
    private SubscriptionStatus status;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private SubscriptionLinks links;

    public Subscription channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public Subscription addChannelsItem(String channelsItem) {
        if (this.channels == null) {
            this.channels = new ArrayList<String>();
        }
        this.channels.add(channelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of sources send notifications to users. > **Note**: Currently, Okta only allows `email` channels.")
    @JsonProperty(value="channels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getChannels() {
        return this.channels;
    }

    @JsonProperty(value="channels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannels(List<String> channels) {
        this.channels = channels;
    }

    public Subscription notificationType(NotificationType notificationType) {
        this.notificationType = notificationType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="notificationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotificationType getNotificationType() {
        return this.notificationType;
    }

    @JsonProperty(value="notificationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotificationType(NotificationType notificationType) {
        this.notificationType = notificationType;
    }

    public Subscription status(SubscriptionStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubscriptionStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(SubscriptionStatus status) {
        this.status = status;
    }

    public Subscription links(SubscriptionLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubscriptionLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(SubscriptionLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription subscription = (Subscription)o;
        return Objects.equals(this.channels, subscription.channels) && Objects.equals((Object)this.notificationType, (Object)subscription.notificationType) && Objects.equals((Object)this.status, (Object)subscription.status) && Objects.equals(this.links, subscription.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.channels, this.notificationType, this.status, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Subscription {\n");
        sb.append("    channels: ").append(this.toIndentedString(this.channels)).append("\n");
        sb.append("    notificationType: ").append(this.toIndentedString((Object)this.notificationType)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

