/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.LinksSelf;
import org.openapitools.client.model.RealmProfile;

@JsonPropertyOrder(value={"created", "id", "isDefault", "lastUpdated", "profile", "_links"})
public class Realm {
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_IS_DEFAULT = "isDefault";
    private Boolean isDefault;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private RealmProfile profile;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    @Nullable
    @ApiModelProperty(value="Timestamp when the realm was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(value="Unique key for the realm")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Conveys whether the realm is default or not")
    @JsonProperty(value="isDefault")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the realm was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public Realm profile(RealmProfile profile) {
        this.profile = profile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RealmProfile getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(RealmProfile profile) {
        this.profile = profile;
    }

    public Realm links(LinksSelf links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LinksSelf getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Realm realm = (Realm)o;
        return Objects.equals(this.created, realm.created) && Objects.equals(this.id, realm.id) && Objects.equals(this.isDefault, realm.isDefault) && Objects.equals(this.lastUpdated, realm.lastUpdated) && Objects.equals(this.profile, realm.profile) && Objects.equals(this.links, realm.links);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.id, this.isDefault, this.lastUpdated, this.profile, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Realm {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

