/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.AgentPool;
import org.openapitools.client.model.AgentPoolUpdate;
import org.openapitools.client.model.AgentPoolUpdateSetting;
import org.openapitools.client.model.AgentType;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class AgentPoolsApi {
    private ApiClient apiClient;

    public AgentPoolsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AgentPoolsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AgentPoolUpdate activateAgentPoolsUpdate(String poolId, String updateId) throws ApiException {
        return this.activateAgentPoolsUpdate(poolId, updateId, Collections.emptyMap());
    }

    public AgentPoolUpdate activateAgentPoolsUpdate(String poolId, String updateId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new ApiException(400, "Missing the required parameter 'poolId' when calling activateAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new ApiException(400, "Missing the required parameter 'updateId' when calling activateAgentPoolsUpdate");
        }
        String localVarPath = "/api/v1/agentPools/{poolId}/updates/{updateId}/activate".replaceAll("\\{poolId\\}", this.apiClient.escapeString(poolId.toString())).replaceAll("\\{updateId\\}", this.apiClient.escapeString(updateId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AgentPoolUpdate> localVarReturnType = new TypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AgentPoolUpdate createAgentPoolsUpdate(String poolId, AgentPoolUpdate agentPoolUpdate) throws ApiException {
        return this.createAgentPoolsUpdate(poolId, agentPoolUpdate, Collections.emptyMap());
    }

    public AgentPoolUpdate createAgentPoolsUpdate(String poolId, AgentPoolUpdate agentPoolUpdate, Map<String, String> additionalHeaders) throws ApiException {
        AgentPoolUpdate localVarPostBody = agentPoolUpdate;
        if (poolId == null) {
            throw new ApiException(400, "Missing the required parameter 'poolId' when calling createAgentPoolsUpdate");
        }
        if (agentPoolUpdate == null) {
            throw new ApiException(400, "Missing the required parameter 'agentPoolUpdate' when calling createAgentPoolsUpdate");
        }
        String localVarPath = "/api/v1/agentPools/{poolId}/updates".replaceAll("\\{poolId\\}", this.apiClient.escapeString(poolId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AgentPoolUpdate> localVarReturnType = new TypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AgentPoolUpdate deactivateAgentPoolsUpdate(String poolId, String updateId) throws ApiException {
        return this.deactivateAgentPoolsUpdate(poolId, updateId, Collections.emptyMap());
    }

    public AgentPoolUpdate deactivateAgentPoolsUpdate(String poolId, String updateId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new ApiException(400, "Missing the required parameter 'poolId' when calling deactivateAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new ApiException(400, "Missing the required parameter 'updateId' when calling deactivateAgentPoolsUpdate");
        }
        String localVarPath = "/api/v1/agentPools/{poolId}/updates/{updateId}/deactivate".replaceAll("\\{poolId\\}", this.apiClient.escapeString(poolId.toString())).replaceAll("\\{updateId\\}", this.apiClient.escapeString(updateId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AgentPoolUpdate> localVarReturnType = new TypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteAgentPoolsUpdate(String poolId, String updateId) throws ApiException {
        this.deleteAgentPoolsUpdate(poolId, updateId, Collections.emptyMap());
    }

    public void deleteAgentPoolsUpdate(String poolId, String updateId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new ApiException(400, "Missing the required parameter 'poolId' when calling deleteAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new ApiException(400, "Missing the required parameter 'updateId' when calling deleteAgentPoolsUpdate");
        }
        String localVarPath = "/api/v1/agentPools/{poolId}/updates/{updateId}".replaceAll("\\{poolId\\}", this.apiClient.escapeString(poolId.toString())).replaceAll("\\{updateId\\}", this.apiClient.escapeString(updateId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public AgentPoolUpdate getAgentPoolsUpdateInstance(String poolId, String updateId) throws ApiException {
        return this.getAgentPoolsUpdateInstance(poolId, updateId, Collections.emptyMap());
    }

    public AgentPoolUpdate getAgentPoolsUpdateInstance(String poolId, String updateId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new ApiException(400, "Missing the required parameter 'poolId' when calling getAgentPoolsUpdateInstance");
        }
        if (updateId == null) {
            throw new ApiException(400, "Missing the required parameter 'updateId' when calling getAgentPoolsUpdateInstance");
        }
        String localVarPath = "/api/v1/agentPools/{poolId}/updates/{updateId}".replaceAll("\\{poolId\\}", this.apiClient.escapeString(poolId.toString())).replaceAll("\\{updateId\\}", this.apiClient.escapeString(updateId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AgentPoolUpdate> localVarReturnType = new TypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AgentPoolUpdateSetting getAgentPoolsUpdateSettings(String poolId) throws ApiException {
        return this.getAgentPoolsUpdateSettings(poolId, Collections.emptyMap());
    }

    public AgentPoolUpdateSetting getAgentPoolsUpdateSettings(String poolId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new ApiException(400, "Missing the required parameter 'poolId' when calling getAgentPoolsUpdateSettings");
        }
        String localVarPath = "/api/v1/agentPools/{poolId}/updates/settings".replaceAll("\\{poolId\\}", this.apiClient.escapeString(poolId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AgentPoolUpdateSetting> localVarReturnType = new TypeReference<AgentPoolUpdateSetting>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AgentPool> listAgentPools(Integer limitPerPoolType, AgentType poolType, String after) throws ApiException {
        return this.listAgentPools(limitPerPoolType, poolType, after, Collections.emptyMap());
    }

    public List<AgentPool> listAgentPools(Integer limitPerPoolType, AgentType poolType, String after, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/agentPools";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limitPerPoolType", limitPerPoolType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("poolType", (Object)poolType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AgentPool>> localVarReturnType = new TypeReference<List<AgentPool>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AgentPoolUpdate> listAgentPoolsUpdates(String poolId, Boolean scheduled) throws ApiException {
        return this.listAgentPoolsUpdates(poolId, scheduled, Collections.emptyMap());
    }

    public List<AgentPoolUpdate> listAgentPoolsUpdates(String poolId, Boolean scheduled, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new ApiException(400, "Missing the required parameter 'poolId' when calling listAgentPoolsUpdates");
        }
        String localVarPath = "/api/v1/agentPools/{poolId}/updates".replaceAll("\\{poolId\\}", this.apiClient.escapeString(poolId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("scheduled", scheduled));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AgentPoolUpdate>> localVarReturnType = new TypeReference<List<AgentPoolUpdate>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AgentPoolUpdate pauseAgentPoolsUpdate(String poolId, String updateId) throws ApiException {
        return this.pauseAgentPoolsUpdate(poolId, updateId, Collections.emptyMap());
    }

    public AgentPoolUpdate pauseAgentPoolsUpdate(String poolId, String updateId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new ApiException(400, "Missing the required parameter 'poolId' when calling pauseAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new ApiException(400, "Missing the required parameter 'updateId' when calling pauseAgentPoolsUpdate");
        }
        String localVarPath = "/api/v1/agentPools/{poolId}/updates/{updateId}/pause".replaceAll("\\{poolId\\}", this.apiClient.escapeString(poolId.toString())).replaceAll("\\{updateId\\}", this.apiClient.escapeString(updateId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AgentPoolUpdate> localVarReturnType = new TypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AgentPoolUpdate resumeAgentPoolsUpdate(String poolId, String updateId) throws ApiException {
        return this.resumeAgentPoolsUpdate(poolId, updateId, Collections.emptyMap());
    }

    public AgentPoolUpdate resumeAgentPoolsUpdate(String poolId, String updateId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new ApiException(400, "Missing the required parameter 'poolId' when calling resumeAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new ApiException(400, "Missing the required parameter 'updateId' when calling resumeAgentPoolsUpdate");
        }
        String localVarPath = "/api/v1/agentPools/{poolId}/updates/{updateId}/resume".replaceAll("\\{poolId\\}", this.apiClient.escapeString(poolId.toString())).replaceAll("\\{updateId\\}", this.apiClient.escapeString(updateId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AgentPoolUpdate> localVarReturnType = new TypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AgentPoolUpdate retryAgentPoolsUpdate(String poolId, String updateId) throws ApiException {
        return this.retryAgentPoolsUpdate(poolId, updateId, Collections.emptyMap());
    }

    public AgentPoolUpdate retryAgentPoolsUpdate(String poolId, String updateId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new ApiException(400, "Missing the required parameter 'poolId' when calling retryAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new ApiException(400, "Missing the required parameter 'updateId' when calling retryAgentPoolsUpdate");
        }
        String localVarPath = "/api/v1/agentPools/{poolId}/updates/{updateId}/retry".replaceAll("\\{poolId\\}", this.apiClient.escapeString(poolId.toString())).replaceAll("\\{updateId\\}", this.apiClient.escapeString(updateId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AgentPoolUpdate> localVarReturnType = new TypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AgentPoolUpdate stopAgentPoolsUpdate(String poolId, String updateId) throws ApiException {
        return this.stopAgentPoolsUpdate(poolId, updateId, Collections.emptyMap());
    }

    public AgentPoolUpdate stopAgentPoolsUpdate(String poolId, String updateId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new ApiException(400, "Missing the required parameter 'poolId' when calling stopAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new ApiException(400, "Missing the required parameter 'updateId' when calling stopAgentPoolsUpdate");
        }
        String localVarPath = "/api/v1/agentPools/{poolId}/updates/{updateId}/stop".replaceAll("\\{poolId\\}", this.apiClient.escapeString(poolId.toString())).replaceAll("\\{updateId\\}", this.apiClient.escapeString(updateId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AgentPoolUpdate> localVarReturnType = new TypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AgentPoolUpdate updateAgentPoolsUpdate(String poolId, String updateId, AgentPoolUpdate agentPoolUpdate) throws ApiException {
        return this.updateAgentPoolsUpdate(poolId, updateId, agentPoolUpdate, Collections.emptyMap());
    }

    public AgentPoolUpdate updateAgentPoolsUpdate(String poolId, String updateId, AgentPoolUpdate agentPoolUpdate, Map<String, String> additionalHeaders) throws ApiException {
        AgentPoolUpdate localVarPostBody = agentPoolUpdate;
        if (poolId == null) {
            throw new ApiException(400, "Missing the required parameter 'poolId' when calling updateAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new ApiException(400, "Missing the required parameter 'updateId' when calling updateAgentPoolsUpdate");
        }
        if (agentPoolUpdate == null) {
            throw new ApiException(400, "Missing the required parameter 'agentPoolUpdate' when calling updateAgentPoolsUpdate");
        }
        String localVarPath = "/api/v1/agentPools/{poolId}/updates/{updateId}".replaceAll("\\{poolId\\}", this.apiClient.escapeString(poolId.toString())).replaceAll("\\{updateId\\}", this.apiClient.escapeString(updateId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AgentPoolUpdate> localVarReturnType = new TypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AgentPoolUpdateSetting updateAgentPoolsUpdateSettings(String poolId, AgentPoolUpdateSetting agentPoolUpdateSetting) throws ApiException {
        return this.updateAgentPoolsUpdateSettings(poolId, agentPoolUpdateSetting, Collections.emptyMap());
    }

    public AgentPoolUpdateSetting updateAgentPoolsUpdateSettings(String poolId, AgentPoolUpdateSetting agentPoolUpdateSetting, Map<String, String> additionalHeaders) throws ApiException {
        AgentPoolUpdateSetting localVarPostBody = agentPoolUpdateSetting;
        if (poolId == null) {
            throw new ApiException(400, "Missing the required parameter 'poolId' when calling updateAgentPoolsUpdateSettings");
        }
        if (agentPoolUpdateSetting == null) {
            throw new ApiException(400, "Missing the required parameter 'agentPoolUpdateSetting' when calling updateAgentPoolsUpdateSettings");
        }
        String localVarPath = "/api/v1/agentPools/{poolId}/updates/settings".replaceAll("\\{poolId\\}", this.apiClient.escapeString(poolId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AgentPoolUpdateSetting> localVarReturnType = new TypeReference<AgentPoolUpdateSetting>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

