/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.helper;

import com.fasterxml.jackson.core.type.TypeReference;
import com.okta.sdk.helper.HelperConstants;
import com.okta.sdk.helper.HelperUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Pair;
import org.openapitools.client.api.ApplicationApi;
import org.openapitools.client.model.Application;
import org.openapitools.client.model.HttpMethod;

public final class ApplicationApiHelper<T extends Application>
extends ApplicationApi {
    public ApplicationApiHelper(ApplicationApi applicationApi) {
        super(applicationApi.getApiClient());
    }

    public ApplicationApiHelper(ApiClient apiClient) {
        super(apiClient);
    }

    public <T extends Application> T createApplicationOfType(final Class<T> classType, Application application, Boolean activate, String oktaAccessGatewayAgent) throws ApiException {
        ApiClient apiClient = this.getApiClient();
        if (application == null) {
            throw new ApiException(400, "Missing the required parameter 'application' when calling createApplication");
        }
        String localVarPath = "/api/v1/apps";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(apiClient.parameterToPair("activate", activate));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (oktaAccessGatewayAgent != null) {
            localVarHeaderParams.put("OktaAccessGateway-Agent", apiClient.parameterToString(oktaAccessGatewayAgent));
        }
        TypeReference localVarReturnType = new TypeReference<T>(){

            public Type getType() {
                return classType;
            }
        };
        return (T)((Application)apiClient.invokeAPI(localVarPath, HttpMethod.POST.name(), localVarQueryParams, new ArrayList<Pair>(), HelperConstants.QUERY_STRING_JOINER.toString(), application, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), apiClient.selectHeaderAccept(HelperConstants.MEDIA_TYPE), apiClient.selectHeaderContentType(HelperConstants.MEDIA_TYPE), HelperConstants.AUTH_NAMES, localVarReturnType));
    }

    public T getApplication(String appId, String expand) throws ApiException {
        ApiClient apiClient = this.getApiClient();
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}".replaceAll("\\{appId\\}", apiClient.escapeString(appId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(apiClient.parameterToPair("expand", expand));
        TypeReference localVarReturnType = new TypeReference<T>(){};
        Application application = (Application)apiClient.invokeAPI(localVarPath, HttpMethod.GET.name(), localVarQueryParams, new ArrayList<Pair>(), HelperConstants.QUERY_STRING_JOINER.toString(), null, new HashMap<String, String>(), new HashMap<String, String>(), new HashMap<String, Object>(), apiClient.selectHeaderAccept(HelperConstants.MEDIA_TYPE), apiClient.selectHeaderContentType(new String[0]), HelperConstants.AUTH_NAMES, localVarReturnType);
        return (T)((Application)ApplicationApiHelper.getObjectMapper().convertValue((Object)application, HelperUtil.getApplicationType(application)));
    }

    @Override
    public List<Application> listApplications(String q, String after, Integer limit, String filter, String expand, Boolean includeNonDeleted) throws ApiException {
        ApiClient apiClient = this.getApiClient();
        String localVarPath = "/api/v1/apps";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(apiClient.parameterToPair("includeNonDeleted", includeNonDeleted));
        TypeReference<List<Application>> localVarReturnType = new TypeReference<List<Application>>(){};
        List<Application> applications = apiClient.invokeAPI(localVarPath, HttpMethod.GET.name(), localVarQueryParams, new ArrayList<Pair>(), HelperConstants.QUERY_STRING_JOINER.toString(), null, new HashMap<String, String>(), new HashMap<String, String>(), new HashMap<String, Object>(), apiClient.selectHeaderAccept(HelperConstants.MEDIA_TYPE), apiClient.selectHeaderContentType(new String[0]), HelperConstants.AUTH_NAMES, localVarReturnType);
        ArrayList<Application> typedApplications = new ArrayList<Application>(applications.size());
        applications.forEach(application -> typedApplications.add((Application)ApplicationApiHelper.getObjectMapper().convertValue(application, HelperUtil.getApplicationType(application))));
        return typedApplications;
    }

    public <T extends Application> T replaceApplicationOfType(final Class<T> classType, String appId, Application application) throws ApiException {
        ApiClient apiClient = this.getApiClient();
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling replaceApplication");
        }
        if (application == null) {
            throw new ApiException(400, "Missing the required parameter 'application' when calling replaceApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}".replaceAll("\\{appId\\}", apiClient.escapeString(appId));
        TypeReference localVarReturnType = new TypeReference<T>(){

            public Type getType() {
                return classType;
            }
        };
        Application app = (Application)apiClient.invokeAPI(localVarPath, HttpMethod.PUT.name(), new ArrayList<Pair>(), new ArrayList<Pair>(), HelperConstants.QUERY_STRING_JOINER.toString(), application, new HashMap<String, String>(), new HashMap<String, String>(), new HashMap<String, Object>(), apiClient.selectHeaderAccept(HelperConstants.MEDIA_TYPE), apiClient.selectHeaderContentType(HelperConstants.MEDIA_TYPE), HelperConstants.AUTH_NAMES, localVarReturnType);
        return (T)((Application)ApplicationApiHelper.getObjectMapper().convertValue((Object)app, HelperUtil.getApplicationType(app)));
    }
}

