/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.common.PagedList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.AuthorizationServer;
import org.openapitools.client.model.AuthorizationServerPolicy;
import org.openapitools.client.model.AuthorizationServerPolicyRule;
import org.openapitools.client.model.JsonWebKey;
import org.openapitools.client.model.JwkUse;
import org.openapitools.client.model.OAuth2Claim;
import org.openapitools.client.model.OAuth2Client;
import org.openapitools.client.model.OAuth2RefreshToken;
import org.openapitools.client.model.OAuth2Scope;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.openapitools.client.api.AuthorizationServerApi")
public class AuthorizationServerApi {
    private ApiClient apiClient;

    public AuthorizationServerApi() {
        this(new ApiClient());
    }

    @Autowired
    public AuthorizationServerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void activateAuthorizationServer(String authServerId) throws RestClientException {
        this.activateAuthorizationServerWithHttpInfo(authServerId);
    }

    public ResponseEntity<Void> activateAuthorizationServerWithHttpInfo(String authServerId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling activateAuthorizationServer");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/lifecycle/activate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void activateAuthorizationServerPolicy(String authServerId, String policyId) throws RestClientException {
        this.activateAuthorizationServerPolicyWithHttpInfo(authServerId, policyId);
    }

    public ResponseEntity<Void> activateAuthorizationServerPolicyWithHttpInfo(String authServerId, String policyId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling activateAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling activateAuthorizationServerPolicy");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("policyId", policyId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/lifecycle/activate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void activateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId) throws RestClientException {
        this.activateAuthorizationServerPolicyRuleWithHttpInfo(authServerId, policyId, ruleId);
    }

    public ResponseEntity<Void> activateAuthorizationServerPolicyRuleWithHttpInfo(String authServerId, String policyId, String ruleId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling activateAuthorizationServerPolicyRule");
        }
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling activateAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleId' when calling activateAuthorizationServerPolicyRule");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("policyId", policyId);
        uriVariables.put("ruleId", ruleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/activate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public AuthorizationServer createAuthorizationServer(AuthorizationServer authorizationServer) throws RestClientException {
        return (AuthorizationServer)this.createAuthorizationServerWithHttpInfo(authorizationServer).getBody();
    }

    public <T> T createAuthorizationServer(Class<?> T, AuthorizationServer authorizationServer) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.createAuthorizationServerWithReturnType(T, authorizationServer).getBody(), T);
    }

    public ResponseEntity<AuthorizationServer> createAuthorizationServerWithHttpInfo(AuthorizationServer authorizationServer) throws RestClientException {
        AuthorizationServer localVarPostBody = authorizationServer;
        if (authorizationServer == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authorizationServer' when calling createAuthorizationServer");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServer> localReturnType = new ParameterizedTypeReference<AuthorizationServer>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> createAuthorizationServerWithReturnType(Class<?> T, AuthorizationServer authorizationServer) throws RestClientException {
        AuthorizationServer localVarPostBody = authorizationServer;
        if (authorizationServer == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authorizationServer' when calling createAuthorizationServer");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList createAuthorizationServerWithPaginationInfo(AuthorizationServer authorizationServer) throws RestClientException {
        AuthorizationServer localVarPostBody = authorizationServer;
        if (authorizationServer == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authorizationServer' when calling createAuthorizationServer");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServer> localReturnType = new ParameterizedTypeReference<AuthorizationServer>(){};
        ResponseEntity<AuthorizationServer> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<AuthorizationServer> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public AuthorizationServerPolicy createAuthorizationServerPolicy(String authServerId, AuthorizationServerPolicy policy) throws RestClientException {
        return (AuthorizationServerPolicy)this.createAuthorizationServerPolicyWithHttpInfo(authServerId, policy).getBody();
    }

    public <T> T createAuthorizationServerPolicy(Class<?> T, String authServerId, AuthorizationServerPolicy policy) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.createAuthorizationServerPolicyWithReturnType(T, authServerId, policy).getBody(), T);
    }

    public ResponseEntity<AuthorizationServerPolicy> createAuthorizationServerPolicyWithHttpInfo(String authServerId, AuthorizationServerPolicy policy) throws RestClientException {
        AuthorizationServerPolicy localVarPostBody = policy;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicy");
        }
        if (policy == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policy' when calling createAuthorizationServerPolicy");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServerPolicy> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicy>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> createAuthorizationServerPolicyWithReturnType(Class<?> T, String authServerId, AuthorizationServerPolicy policy) throws RestClientException {
        AuthorizationServerPolicy localVarPostBody = policy;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicy");
        }
        if (policy == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policy' when calling createAuthorizationServerPolicy");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList createAuthorizationServerPolicyWithPaginationInfo(String authServerId, AuthorizationServerPolicy policy) throws RestClientException {
        AuthorizationServerPolicy localVarPostBody = policy;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicy");
        }
        if (policy == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policy' when calling createAuthorizationServerPolicy");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServerPolicy> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicy>(){};
        ResponseEntity<AuthorizationServerPolicy> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<AuthorizationServerPolicy> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public AuthorizationServerPolicyRule createAuthorizationServerPolicyRule(String policyId, String authServerId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
        return (AuthorizationServerPolicyRule)this.createAuthorizationServerPolicyRuleWithHttpInfo(policyId, authServerId, policyRule).getBody();
    }

    public <T> T createAuthorizationServerPolicyRule(Class<?> T, String policyId, String authServerId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.createAuthorizationServerPolicyRuleWithReturnType(T, policyId, authServerId, policyRule).getBody(), T);
    }

    public ResponseEntity<AuthorizationServerPolicyRule> createAuthorizationServerPolicyRuleWithHttpInfo(String policyId, String authServerId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
        AuthorizationServerPolicyRule localVarPostBody = policyRule;
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling createAuthorizationServerPolicyRule");
        }
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicyRule");
        }
        if (policyRule == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyRule' when calling createAuthorizationServerPolicyRule");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("policyId", policyId);
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServerPolicyRule> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicyRule>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> createAuthorizationServerPolicyRuleWithReturnType(Class<?> T, String policyId, String authServerId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
        AuthorizationServerPolicyRule localVarPostBody = policyRule;
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling createAuthorizationServerPolicyRule");
        }
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicyRule");
        }
        if (policyRule == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyRule' when calling createAuthorizationServerPolicyRule");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("policyId", policyId);
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList createAuthorizationServerPolicyRuleWithPaginationInfo(String policyId, String authServerId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
        AuthorizationServerPolicyRule localVarPostBody = policyRule;
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling createAuthorizationServerPolicyRule");
        }
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicyRule");
        }
        if (policyRule == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyRule' when calling createAuthorizationServerPolicyRule");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("policyId", policyId);
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServerPolicyRule> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicyRule>(){};
        ResponseEntity<AuthorizationServerPolicyRule> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<AuthorizationServerPolicyRule> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public OAuth2Claim createOAuth2Claim(String authServerId, OAuth2Claim oAuth2Claim) throws RestClientException {
        return (OAuth2Claim)this.createOAuth2ClaimWithHttpInfo(authServerId, oAuth2Claim).getBody();
    }

    public <T> T createOAuth2Claim(Class<?> T, String authServerId, OAuth2Claim oAuth2Claim) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.createOAuth2ClaimWithReturnType(T, authServerId, oAuth2Claim).getBody(), T);
    }

    public ResponseEntity<OAuth2Claim> createOAuth2ClaimWithHttpInfo(String authServerId, OAuth2Claim oAuth2Claim) throws RestClientException {
        OAuth2Claim localVarPostBody = oAuth2Claim;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createOAuth2Claim");
        }
        if (oAuth2Claim == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Claim' when calling createOAuth2Claim");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<OAuth2Claim> localReturnType = new ParameterizedTypeReference<OAuth2Claim>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> createOAuth2ClaimWithReturnType(Class<?> T, String authServerId, OAuth2Claim oAuth2Claim) throws RestClientException {
        OAuth2Claim localVarPostBody = oAuth2Claim;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createOAuth2Claim");
        }
        if (oAuth2Claim == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Claim' when calling createOAuth2Claim");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList createOAuth2ClaimWithPaginationInfo(String authServerId, OAuth2Claim oAuth2Claim) throws RestClientException {
        OAuth2Claim localVarPostBody = oAuth2Claim;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createOAuth2Claim");
        }
        if (oAuth2Claim == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Claim' when calling createOAuth2Claim");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<OAuth2Claim> localReturnType = new ParameterizedTypeReference<OAuth2Claim>(){};
        ResponseEntity<OAuth2Claim> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<OAuth2Claim> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public OAuth2Scope createOAuth2Scope(String authServerId, OAuth2Scope oAuth2Scope) throws RestClientException {
        return (OAuth2Scope)this.createOAuth2ScopeWithHttpInfo(authServerId, oAuth2Scope).getBody();
    }

    public <T> T createOAuth2Scope(Class<?> T, String authServerId, OAuth2Scope oAuth2Scope) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.createOAuth2ScopeWithReturnType(T, authServerId, oAuth2Scope).getBody(), T);
    }

    public ResponseEntity<OAuth2Scope> createOAuth2ScopeWithHttpInfo(String authServerId, OAuth2Scope oAuth2Scope) throws RestClientException {
        OAuth2Scope localVarPostBody = oAuth2Scope;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createOAuth2Scope");
        }
        if (oAuth2Scope == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Scope' when calling createOAuth2Scope");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<OAuth2Scope> localReturnType = new ParameterizedTypeReference<OAuth2Scope>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> createOAuth2ScopeWithReturnType(Class<?> T, String authServerId, OAuth2Scope oAuth2Scope) throws RestClientException {
        OAuth2Scope localVarPostBody = oAuth2Scope;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createOAuth2Scope");
        }
        if (oAuth2Scope == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Scope' when calling createOAuth2Scope");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList createOAuth2ScopeWithPaginationInfo(String authServerId, OAuth2Scope oAuth2Scope) throws RestClientException {
        OAuth2Scope localVarPostBody = oAuth2Scope;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createOAuth2Scope");
        }
        if (oAuth2Scope == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Scope' when calling createOAuth2Scope");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<OAuth2Scope> localReturnType = new ParameterizedTypeReference<OAuth2Scope>(){};
        ResponseEntity<OAuth2Scope> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<OAuth2Scope> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public void deactivateAuthorizationServer(String authServerId) throws RestClientException {
        this.deactivateAuthorizationServerWithHttpInfo(authServerId);
    }

    public ResponseEntity<Void> deactivateAuthorizationServerWithHttpInfo(String authServerId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling deactivateAuthorizationServer");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/lifecycle/deactivate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void deactivateAuthorizationServerPolicy(String authServerId, String policyId) throws RestClientException {
        this.deactivateAuthorizationServerPolicyWithHttpInfo(authServerId, policyId);
    }

    public ResponseEntity<Void> deactivateAuthorizationServerPolicyWithHttpInfo(String authServerId, String policyId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling deactivateAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling deactivateAuthorizationServerPolicy");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("policyId", policyId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/lifecycle/deactivate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void deactivateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId) throws RestClientException {
        this.deactivateAuthorizationServerPolicyRuleWithHttpInfo(authServerId, policyId, ruleId);
    }

    public ResponseEntity<Void> deactivateAuthorizationServerPolicyRuleWithHttpInfo(String authServerId, String policyId, String ruleId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling deactivateAuthorizationServerPolicyRule");
        }
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling deactivateAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleId' when calling deactivateAuthorizationServerPolicyRule");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("policyId", policyId);
        uriVariables.put("ruleId", ruleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/deactivate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void deleteAuthorizationServer(String authServerId) throws RestClientException {
        this.deleteAuthorizationServerWithHttpInfo(authServerId);
    }

    public ResponseEntity<Void> deleteAuthorizationServerWithHttpInfo(String authServerId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling deleteAuthorizationServer");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void deleteAuthorizationServerPolicy(String authServerId, String policyId) throws RestClientException {
        this.deleteAuthorizationServerPolicyWithHttpInfo(authServerId, policyId);
    }

    public ResponseEntity<Void> deleteAuthorizationServerPolicyWithHttpInfo(String authServerId, String policyId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling deleteAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling deleteAuthorizationServerPolicy");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("policyId", policyId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void deleteAuthorizationServerPolicyRule(String policyId, String authServerId, String ruleId) throws RestClientException {
        this.deleteAuthorizationServerPolicyRuleWithHttpInfo(policyId, authServerId, ruleId);
    }

    public ResponseEntity<Void> deleteAuthorizationServerPolicyRuleWithHttpInfo(String policyId, String authServerId, String ruleId) throws RestClientException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling deleteAuthorizationServerPolicyRule");
        }
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling deleteAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleId' when calling deleteAuthorizationServerPolicyRule");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("policyId", policyId);
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("ruleId", ruleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void deleteOAuth2Claim(String authServerId, String claimId) throws RestClientException {
        this.deleteOAuth2ClaimWithHttpInfo(authServerId, claimId);
    }

    public ResponseEntity<Void> deleteOAuth2ClaimWithHttpInfo(String authServerId, String claimId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling deleteOAuth2Claim");
        }
        if (claimId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'claimId' when calling deleteOAuth2Claim");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("claimId", claimId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims/{claimId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void deleteOAuth2Scope(String authServerId, String scopeId) throws RestClientException {
        this.deleteOAuth2ScopeWithHttpInfo(authServerId, scopeId);
    }

    public ResponseEntity<Void> deleteOAuth2ScopeWithHttpInfo(String authServerId, String scopeId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling deleteOAuth2Scope");
        }
        if (scopeId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'scopeId' when calling deleteOAuth2Scope");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("scopeId", scopeId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public AuthorizationServer getAuthorizationServer(String authServerId) throws RestClientException {
        return (AuthorizationServer)this.getAuthorizationServerWithHttpInfo(authServerId).getBody();
    }

    public ResponseEntity<AuthorizationServer> getAuthorizationServerWithHttpInfo(String authServerId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getAuthorizationServer");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServer> localReturnType = new ParameterizedTypeReference<AuthorizationServer>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getAuthorizationServerWithPaginationInfo(String authServerId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getAuthorizationServer");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServer> localReturnType = new ParameterizedTypeReference<AuthorizationServer>(){};
        ResponseEntity<AuthorizationServer> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<AuthorizationServer> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public AuthorizationServerPolicy getAuthorizationServerPolicy(String authServerId, String policyId) throws RestClientException {
        return (AuthorizationServerPolicy)this.getAuthorizationServerPolicyWithHttpInfo(authServerId, policyId).getBody();
    }

    public ResponseEntity<AuthorizationServerPolicy> getAuthorizationServerPolicyWithHttpInfo(String authServerId, String policyId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling getAuthorizationServerPolicy");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("policyId", policyId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServerPolicy> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicy>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getAuthorizationServerPolicyWithPaginationInfo(String authServerId, String policyId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling getAuthorizationServerPolicy");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("policyId", policyId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServerPolicy> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicy>(){};
        ResponseEntity<AuthorizationServerPolicy> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<AuthorizationServerPolicy> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public AuthorizationServerPolicyRule getAuthorizationServerPolicyRule(String policyId, String authServerId, String ruleId) throws RestClientException {
        return (AuthorizationServerPolicyRule)this.getAuthorizationServerPolicyRuleWithHttpInfo(policyId, authServerId, ruleId).getBody();
    }

    public ResponseEntity<AuthorizationServerPolicyRule> getAuthorizationServerPolicyRuleWithHttpInfo(String policyId, String authServerId, String ruleId) throws RestClientException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling getAuthorizationServerPolicyRule");
        }
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleId' when calling getAuthorizationServerPolicyRule");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("policyId", policyId);
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("ruleId", ruleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServerPolicyRule> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicyRule>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getAuthorizationServerPolicyRuleWithPaginationInfo(String policyId, String authServerId, String ruleId) throws RestClientException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling getAuthorizationServerPolicyRule");
        }
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleId' when calling getAuthorizationServerPolicyRule");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("policyId", policyId);
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("ruleId", ruleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServerPolicyRule> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicyRule>(){};
        ResponseEntity<AuthorizationServerPolicyRule> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<AuthorizationServerPolicyRule> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public OAuth2Claim getOAuth2Claim(String authServerId, String claimId) throws RestClientException {
        return (OAuth2Claim)this.getOAuth2ClaimWithHttpInfo(authServerId, claimId).getBody();
    }

    public ResponseEntity<OAuth2Claim> getOAuth2ClaimWithHttpInfo(String authServerId, String claimId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getOAuth2Claim");
        }
        if (claimId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'claimId' when calling getOAuth2Claim");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("claimId", claimId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<OAuth2Claim> localReturnType = new ParameterizedTypeReference<OAuth2Claim>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims/{claimId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getOAuth2ClaimWithPaginationInfo(String authServerId, String claimId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getOAuth2Claim");
        }
        if (claimId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'claimId' when calling getOAuth2Claim");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("claimId", claimId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<OAuth2Claim> localReturnType = new ParameterizedTypeReference<OAuth2Claim>(){};
        ResponseEntity<OAuth2Claim> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims/{claimId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<OAuth2Claim> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims/{claimId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public OAuth2Scope getOAuth2Scope(String authServerId, String scopeId) throws RestClientException {
        return (OAuth2Scope)this.getOAuth2ScopeWithHttpInfo(authServerId, scopeId).getBody();
    }

    public ResponseEntity<OAuth2Scope> getOAuth2ScopeWithHttpInfo(String authServerId, String scopeId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getOAuth2Scope");
        }
        if (scopeId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'scopeId' when calling getOAuth2Scope");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("scopeId", scopeId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<OAuth2Scope> localReturnType = new ParameterizedTypeReference<OAuth2Scope>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getOAuth2ScopeWithPaginationInfo(String authServerId, String scopeId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getOAuth2Scope");
        }
        if (scopeId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'scopeId' when calling getOAuth2Scope");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("scopeId", scopeId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<OAuth2Scope> localReturnType = new ParameterizedTypeReference<OAuth2Scope>(){};
        ResponseEntity<OAuth2Scope> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<OAuth2Scope> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public OAuth2RefreshToken getRefreshTokenForAuthorizationServerAndClient(String authServerId, String clientId, String tokenId, String expand) throws RestClientException {
        return (OAuth2RefreshToken)this.getRefreshTokenForAuthorizationServerAndClientWithHttpInfo(authServerId, clientId, tokenId, expand).getBody();
    }

    public ResponseEntity<OAuth2RefreshToken> getRefreshTokenForAuthorizationServerAndClientWithHttpInfo(String authServerId, String clientId, String tokenId, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getRefreshTokenForAuthorizationServerAndClient");
        }
        if (clientId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling getRefreshTokenForAuthorizationServerAndClient");
        }
        if (tokenId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tokenId' when calling getRefreshTokenForAuthorizationServerAndClient");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("clientId", clientId);
        uriVariables.put("tokenId", tokenId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<OAuth2RefreshToken> localReturnType = new ParameterizedTypeReference<OAuth2RefreshToken>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getRefreshTokenForAuthorizationServerAndClientWithPaginationInfo(String authServerId, String clientId, String tokenId, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getRefreshTokenForAuthorizationServerAndClient");
        }
        if (clientId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling getRefreshTokenForAuthorizationServerAndClient");
        }
        if (tokenId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tokenId' when calling getRefreshTokenForAuthorizationServerAndClient");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("clientId", clientId);
        uriVariables.put("tokenId", tokenId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<OAuth2RefreshToken> localReturnType = new ParameterizedTypeReference<OAuth2RefreshToken>(){};
        ResponseEntity<OAuth2RefreshToken> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<OAuth2RefreshToken> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public List<JsonWebKey> listAuthorizationServerKeys(String authServerId) throws RestClientException {
        return (List)this.listAuthorizationServerKeysWithHttpInfo(authServerId).getBody();
    }

    public ResponseEntity<List<JsonWebKey>> listAuthorizationServerKeysWithHttpInfo(String authServerId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listAuthorizationServerKeys");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<JsonWebKey>> localReturnType = new ParameterizedTypeReference<List<JsonWebKey>>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/credentials/keys", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listAuthorizationServerKeysWithPaginationInfo(String authServerId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listAuthorizationServerKeys");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<JsonWebKey>> localReturnType = new ParameterizedTypeReference<List<JsonWebKey>>(){};
        ResponseEntity<List<JsonWebKey>> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/credentials/keys", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<JsonWebKey>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/credentials/keys", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public List<AuthorizationServerPolicy> listAuthorizationServerPolicies(String authServerId) throws RestClientException {
        return (List)this.listAuthorizationServerPoliciesWithHttpInfo(authServerId).getBody();
    }

    public ResponseEntity<List<AuthorizationServerPolicy>> listAuthorizationServerPoliciesWithHttpInfo(String authServerId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listAuthorizationServerPolicies");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<AuthorizationServerPolicy>> localReturnType = new ParameterizedTypeReference<List<AuthorizationServerPolicy>>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listAuthorizationServerPoliciesWithPaginationInfo(String authServerId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listAuthorizationServerPolicies");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<AuthorizationServerPolicy>> localReturnType = new ParameterizedTypeReference<List<AuthorizationServerPolicy>>(){};
        ResponseEntity<List<AuthorizationServerPolicy>> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<AuthorizationServerPolicy>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public List<AuthorizationServerPolicyRule> listAuthorizationServerPolicyRules(String policyId, String authServerId) throws RestClientException {
        return (List)this.listAuthorizationServerPolicyRulesWithHttpInfo(policyId, authServerId).getBody();
    }

    public ResponseEntity<List<AuthorizationServerPolicyRule>> listAuthorizationServerPolicyRulesWithHttpInfo(String policyId, String authServerId) throws RestClientException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling listAuthorizationServerPolicyRules");
        }
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listAuthorizationServerPolicyRules");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("policyId", policyId);
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<AuthorizationServerPolicyRule>> localReturnType = new ParameterizedTypeReference<List<AuthorizationServerPolicyRule>>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listAuthorizationServerPolicyRulesWithPaginationInfo(String policyId, String authServerId) throws RestClientException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling listAuthorizationServerPolicyRules");
        }
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listAuthorizationServerPolicyRules");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("policyId", policyId);
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<AuthorizationServerPolicyRule>> localReturnType = new ParameterizedTypeReference<List<AuthorizationServerPolicyRule>>(){};
        ResponseEntity<List<AuthorizationServerPolicyRule>> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<AuthorizationServerPolicyRule>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public List<AuthorizationServer> listAuthorizationServers(String q, Integer limit, String after) throws RestClientException {
        return (List)this.listAuthorizationServersWithHttpInfo(q, limit, after).getBody();
    }

    public ResponseEntity<List<AuthorizationServer>> listAuthorizationServersWithHttpInfo(String q, Integer limit, String after) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "q", q));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<AuthorizationServer>> localReturnType = new ParameterizedTypeReference<List<AuthorizationServer>>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listAuthorizationServersWithPaginationInfo(String q, Integer limit, String after) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "q", q));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<AuthorizationServer>> localReturnType = new ParameterizedTypeReference<List<AuthorizationServer>>(){};
        ResponseEntity<List<AuthorizationServer>> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<AuthorizationServer>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public List<OAuth2Claim> listOAuth2Claims(String authServerId) throws RestClientException {
        return (List)this.listOAuth2ClaimsWithHttpInfo(authServerId).getBody();
    }

    public ResponseEntity<List<OAuth2Claim>> listOAuth2ClaimsWithHttpInfo(String authServerId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listOAuth2Claims");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<OAuth2Claim>> localReturnType = new ParameterizedTypeReference<List<OAuth2Claim>>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listOAuth2ClaimsWithPaginationInfo(String authServerId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listOAuth2Claims");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<OAuth2Claim>> localReturnType = new ParameterizedTypeReference<List<OAuth2Claim>>(){};
        ResponseEntity<List<OAuth2Claim>> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<OAuth2Claim>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public List<OAuth2Client> listOAuth2ClientsForAuthorizationServer(String authServerId) throws RestClientException {
        return (List)this.listOAuth2ClientsForAuthorizationServerWithHttpInfo(authServerId).getBody();
    }

    public ResponseEntity<List<OAuth2Client>> listOAuth2ClientsForAuthorizationServerWithHttpInfo(String authServerId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listOAuth2ClientsForAuthorizationServer");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<OAuth2Client>> localReturnType = new ParameterizedTypeReference<List<OAuth2Client>>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listOAuth2ClientsForAuthorizationServerWithPaginationInfo(String authServerId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listOAuth2ClientsForAuthorizationServer");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<OAuth2Client>> localReturnType = new ParameterizedTypeReference<List<OAuth2Client>>(){};
        ResponseEntity<List<OAuth2Client>> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<OAuth2Client>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public List<OAuth2Scope> listOAuth2Scopes(String authServerId, String q, String filter, String cursor, Integer limit) throws RestClientException {
        return (List)this.listOAuth2ScopesWithHttpInfo(authServerId, q, filter, cursor, limit).getBody();
    }

    public ResponseEntity<List<OAuth2Scope>> listOAuth2ScopesWithHttpInfo(String authServerId, String q, String filter, String cursor, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listOAuth2Scopes");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "q", q));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "cursor", cursor));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<OAuth2Scope>> localReturnType = new ParameterizedTypeReference<List<OAuth2Scope>>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listOAuth2ScopesWithPaginationInfo(String authServerId, String q, String filter, String cursor, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listOAuth2Scopes");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "q", q));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "cursor", cursor));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<OAuth2Scope>> localReturnType = new ParameterizedTypeReference<List<OAuth2Scope>>(){};
        ResponseEntity<List<OAuth2Scope>> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<OAuth2Scope>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public List<OAuth2RefreshToken> listRefreshTokensForAuthorizationServerAndClient(String authServerId, String clientId, String expand, String after, Integer limit) throws RestClientException {
        return (List)this.listRefreshTokensForAuthorizationServerAndClientWithHttpInfo(authServerId, clientId, expand, after, limit).getBody();
    }

    public ResponseEntity<List<OAuth2RefreshToken>> listRefreshTokensForAuthorizationServerAndClientWithHttpInfo(String authServerId, String clientId, String expand, String after, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listRefreshTokensForAuthorizationServerAndClient");
        }
        if (clientId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling listRefreshTokensForAuthorizationServerAndClient");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("clientId", clientId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<OAuth2RefreshToken>> localReturnType = new ParameterizedTypeReference<List<OAuth2RefreshToken>>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listRefreshTokensForAuthorizationServerAndClientWithPaginationInfo(String authServerId, String clientId, String expand, String after, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listRefreshTokensForAuthorizationServerAndClient");
        }
        if (clientId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling listRefreshTokensForAuthorizationServerAndClient");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("clientId", clientId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<OAuth2RefreshToken>> localReturnType = new ParameterizedTypeReference<List<OAuth2RefreshToken>>(){};
        ResponseEntity<List<OAuth2RefreshToken>> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<OAuth2RefreshToken>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public AuthorizationServer replaceAuthorizationServer(String authServerId, AuthorizationServer authorizationServer) throws RestClientException {
        return (AuthorizationServer)this.replaceAuthorizationServerWithHttpInfo(authServerId, authorizationServer).getBody();
    }

    public <T> T replaceAuthorizationServer(Class<?> T, String authServerId, AuthorizationServer authorizationServer) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.replaceAuthorizationServerWithReturnType(T, authServerId, authorizationServer).getBody(), T);
    }

    public ResponseEntity<AuthorizationServer> replaceAuthorizationServerWithHttpInfo(String authServerId, AuthorizationServer authorizationServer) throws RestClientException {
        AuthorizationServer localVarPostBody = authorizationServer;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServer");
        }
        if (authorizationServer == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authorizationServer' when calling replaceAuthorizationServer");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServer> localReturnType = new ParameterizedTypeReference<AuthorizationServer>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> replaceAuthorizationServerWithReturnType(Class<?> T, String authServerId, AuthorizationServer authorizationServer) throws RestClientException {
        AuthorizationServer localVarPostBody = authorizationServer;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServer");
        }
        if (authorizationServer == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authorizationServer' when calling replaceAuthorizationServer");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList replaceAuthorizationServerWithPaginationInfo(String authServerId, AuthorizationServer authorizationServer) throws RestClientException {
        AuthorizationServer localVarPostBody = authorizationServer;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServer");
        }
        if (authorizationServer == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authorizationServer' when calling replaceAuthorizationServer");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServer> localReturnType = new ParameterizedTypeReference<AuthorizationServer>(){};
        ResponseEntity<AuthorizationServer> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<AuthorizationServer> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public AuthorizationServerPolicy replaceAuthorizationServerPolicy(String authServerId, String policyId, AuthorizationServerPolicy policy) throws RestClientException {
        return (AuthorizationServerPolicy)this.replaceAuthorizationServerPolicyWithHttpInfo(authServerId, policyId, policy).getBody();
    }

    public <T> T replaceAuthorizationServerPolicy(Class<?> T, String authServerId, String policyId, AuthorizationServerPolicy policy) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.replaceAuthorizationServerPolicyWithReturnType(T, authServerId, policyId, policy).getBody(), T);
    }

    public ResponseEntity<AuthorizationServerPolicy> replaceAuthorizationServerPolicyWithHttpInfo(String authServerId, String policyId, AuthorizationServerPolicy policy) throws RestClientException {
        AuthorizationServerPolicy localVarPostBody = policy;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicy");
        }
        if (policy == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policy' when calling replaceAuthorizationServerPolicy");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("policyId", policyId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServerPolicy> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicy>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> replaceAuthorizationServerPolicyWithReturnType(Class<?> T, String authServerId, String policyId, AuthorizationServerPolicy policy) throws RestClientException {
        AuthorizationServerPolicy localVarPostBody = policy;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicy");
        }
        if (policy == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policy' when calling replaceAuthorizationServerPolicy");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("policyId", policyId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList replaceAuthorizationServerPolicyWithPaginationInfo(String authServerId, String policyId, AuthorizationServerPolicy policy) throws RestClientException {
        AuthorizationServerPolicy localVarPostBody = policy;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicy");
        }
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicy");
        }
        if (policy == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policy' when calling replaceAuthorizationServerPolicy");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("policyId", policyId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServerPolicy> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicy>(){};
        ResponseEntity<AuthorizationServerPolicy> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<AuthorizationServerPolicy> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public AuthorizationServerPolicyRule replaceAuthorizationServerPolicyRule(String policyId, String authServerId, String ruleId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
        return (AuthorizationServerPolicyRule)this.replaceAuthorizationServerPolicyRuleWithHttpInfo(policyId, authServerId, ruleId, policyRule).getBody();
    }

    public <T> T replaceAuthorizationServerPolicyRule(Class<?> T, String policyId, String authServerId, String ruleId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.replaceAuthorizationServerPolicyRuleWithReturnType(T, policyId, authServerId, ruleId, policyRule).getBody(), T);
    }

    public ResponseEntity<AuthorizationServerPolicyRule> replaceAuthorizationServerPolicyRuleWithHttpInfo(String policyId, String authServerId, String ruleId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
        AuthorizationServerPolicyRule localVarPostBody = policyRule;
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicyRule");
        }
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleId' when calling replaceAuthorizationServerPolicyRule");
        }
        if (policyRule == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyRule' when calling replaceAuthorizationServerPolicyRule");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("policyId", policyId);
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("ruleId", ruleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServerPolicyRule> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicyRule>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> replaceAuthorizationServerPolicyRuleWithReturnType(Class<?> T, String policyId, String authServerId, String ruleId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
        AuthorizationServerPolicyRule localVarPostBody = policyRule;
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicyRule");
        }
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleId' when calling replaceAuthorizationServerPolicyRule");
        }
        if (policyRule == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyRule' when calling replaceAuthorizationServerPolicyRule");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("policyId", policyId);
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("ruleId", ruleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList replaceAuthorizationServerPolicyRuleWithPaginationInfo(String policyId, String authServerId, String ruleId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
        AuthorizationServerPolicyRule localVarPostBody = policyRule;
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicyRule");
        }
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicyRule");
        }
        if (ruleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleId' when calling replaceAuthorizationServerPolicyRule");
        }
        if (policyRule == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyRule' when calling replaceAuthorizationServerPolicyRule");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("policyId", policyId);
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("ruleId", ruleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AuthorizationServerPolicyRule> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicyRule>(){};
        ResponseEntity<AuthorizationServerPolicyRule> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<AuthorizationServerPolicyRule> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public OAuth2Claim replaceOAuth2Claim(String authServerId, String claimId, OAuth2Claim oAuth2Claim) throws RestClientException {
        return (OAuth2Claim)this.replaceOAuth2ClaimWithHttpInfo(authServerId, claimId, oAuth2Claim).getBody();
    }

    public <T> T replaceOAuth2Claim(Class<?> T, String authServerId, String claimId, OAuth2Claim oAuth2Claim) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.replaceOAuth2ClaimWithReturnType(T, authServerId, claimId, oAuth2Claim).getBody(), T);
    }

    public ResponseEntity<OAuth2Claim> replaceOAuth2ClaimWithHttpInfo(String authServerId, String claimId, OAuth2Claim oAuth2Claim) throws RestClientException {
        OAuth2Claim localVarPostBody = oAuth2Claim;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceOAuth2Claim");
        }
        if (claimId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'claimId' when calling replaceOAuth2Claim");
        }
        if (oAuth2Claim == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Claim' when calling replaceOAuth2Claim");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("claimId", claimId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<OAuth2Claim> localReturnType = new ParameterizedTypeReference<OAuth2Claim>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims/{claimId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> replaceOAuth2ClaimWithReturnType(Class<?> T, String authServerId, String claimId, OAuth2Claim oAuth2Claim) throws RestClientException {
        OAuth2Claim localVarPostBody = oAuth2Claim;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceOAuth2Claim");
        }
        if (claimId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'claimId' when calling replaceOAuth2Claim");
        }
        if (oAuth2Claim == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Claim' when calling replaceOAuth2Claim");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("claimId", claimId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims/{claimId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList replaceOAuth2ClaimWithPaginationInfo(String authServerId, String claimId, OAuth2Claim oAuth2Claim) throws RestClientException {
        OAuth2Claim localVarPostBody = oAuth2Claim;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceOAuth2Claim");
        }
        if (claimId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'claimId' when calling replaceOAuth2Claim");
        }
        if (oAuth2Claim == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Claim' when calling replaceOAuth2Claim");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("claimId", claimId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<OAuth2Claim> localReturnType = new ParameterizedTypeReference<OAuth2Claim>(){};
        ResponseEntity<OAuth2Claim> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims/{claimId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<OAuth2Claim> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims/{claimId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public OAuth2Scope replaceOAuth2Scope(String authServerId, String scopeId, OAuth2Scope oAuth2Scope) throws RestClientException {
        return (OAuth2Scope)this.replaceOAuth2ScopeWithHttpInfo(authServerId, scopeId, oAuth2Scope).getBody();
    }

    public <T> T replaceOAuth2Scope(Class<?> T, String authServerId, String scopeId, OAuth2Scope oAuth2Scope) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.replaceOAuth2ScopeWithReturnType(T, authServerId, scopeId, oAuth2Scope).getBody(), T);
    }

    public ResponseEntity<OAuth2Scope> replaceOAuth2ScopeWithHttpInfo(String authServerId, String scopeId, OAuth2Scope oAuth2Scope) throws RestClientException {
        OAuth2Scope localVarPostBody = oAuth2Scope;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceOAuth2Scope");
        }
        if (scopeId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'scopeId' when calling replaceOAuth2Scope");
        }
        if (oAuth2Scope == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Scope' when calling replaceOAuth2Scope");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("scopeId", scopeId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<OAuth2Scope> localReturnType = new ParameterizedTypeReference<OAuth2Scope>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> replaceOAuth2ScopeWithReturnType(Class<?> T, String authServerId, String scopeId, OAuth2Scope oAuth2Scope) throws RestClientException {
        OAuth2Scope localVarPostBody = oAuth2Scope;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceOAuth2Scope");
        }
        if (scopeId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'scopeId' when calling replaceOAuth2Scope");
        }
        if (oAuth2Scope == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Scope' when calling replaceOAuth2Scope");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("scopeId", scopeId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList replaceOAuth2ScopeWithPaginationInfo(String authServerId, String scopeId, OAuth2Scope oAuth2Scope) throws RestClientException {
        OAuth2Scope localVarPostBody = oAuth2Scope;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceOAuth2Scope");
        }
        if (scopeId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'scopeId' when calling replaceOAuth2Scope");
        }
        if (oAuth2Scope == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Scope' when calling replaceOAuth2Scope");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("scopeId", scopeId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<OAuth2Scope> localReturnType = new ParameterizedTypeReference<OAuth2Scope>(){};
        ResponseEntity<OAuth2Scope> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<OAuth2Scope> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public void revokeRefreshTokenForAuthorizationServerAndClient(String authServerId, String clientId, String tokenId) throws RestClientException {
        this.revokeRefreshTokenForAuthorizationServerAndClientWithHttpInfo(authServerId, clientId, tokenId);
    }

    public ResponseEntity<Void> revokeRefreshTokenForAuthorizationServerAndClientWithHttpInfo(String authServerId, String clientId, String tokenId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling revokeRefreshTokenForAuthorizationServerAndClient");
        }
        if (clientId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling revokeRefreshTokenForAuthorizationServerAndClient");
        }
        if (tokenId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tokenId' when calling revokeRefreshTokenForAuthorizationServerAndClient");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("clientId", clientId);
        uriVariables.put("tokenId", tokenId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void revokeRefreshTokensForAuthorizationServerAndClient(String authServerId, String clientId) throws RestClientException {
        this.revokeRefreshTokensForAuthorizationServerAndClientWithHttpInfo(authServerId, clientId);
    }

    public ResponseEntity<Void> revokeRefreshTokensForAuthorizationServerAndClientWithHttpInfo(String authServerId, String clientId) throws RestClientException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling revokeRefreshTokensForAuthorizationServerAndClient");
        }
        if (clientId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling revokeRefreshTokensForAuthorizationServerAndClient");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        uriVariables.put("clientId", clientId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public List<JsonWebKey> rotateAuthorizationServerKeys(String authServerId, JwkUse use) throws RestClientException {
        return (List)this.rotateAuthorizationServerKeysWithHttpInfo(authServerId, use).getBody();
    }

    public <T> T rotateAuthorizationServerKeys(Class<?> T, String authServerId, JwkUse use) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.rotateAuthorizationServerKeysWithReturnType(T, authServerId, use).getBody(), T);
    }

    public ResponseEntity<List<JsonWebKey>> rotateAuthorizationServerKeysWithHttpInfo(String authServerId, JwkUse use) throws RestClientException {
        JwkUse localVarPostBody = use;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling rotateAuthorizationServerKeys");
        }
        if (use == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'use' when calling rotateAuthorizationServerKeys");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<JsonWebKey>> localReturnType = new ParameterizedTypeReference<List<JsonWebKey>>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/credentials/lifecycle/keyRotate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> rotateAuthorizationServerKeysWithReturnType(Class<?> T, String authServerId, JwkUse use) throws RestClientException {
        JwkUse localVarPostBody = use;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling rotateAuthorizationServerKeys");
        }
        if (use == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'use' when calling rotateAuthorizationServerKeys");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/credentials/lifecycle/keyRotate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList rotateAuthorizationServerKeysWithPaginationInfo(String authServerId, JwkUse use) throws RestClientException {
        JwkUse localVarPostBody = use;
        if (authServerId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling rotateAuthorizationServerKeys");
        }
        if (use == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'use' when calling rotateAuthorizationServerKeys");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("authServerId", authServerId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<JsonWebKey>> localReturnType = new ParameterizedTypeReference<List<JsonWebKey>>(){};
        ResponseEntity<List<JsonWebKey>> responseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/credentials/lifecycle/keyRotate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<JsonWebKey>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/credentials/lifecycle/keyRotate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
}

