/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.common.PagedList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.UserType;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.openapitools.client.api.UserTypeApi")
public class UserTypeApi {
    private ApiClient apiClient;

    public UserTypeApi() {
        this(new ApiClient());
    }

    @Autowired
    public UserTypeApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UserType createUserType(UserType userType) throws RestClientException {
        return (UserType)this.createUserTypeWithHttpInfo(userType).getBody();
    }

    public <T> T createUserType(Class<?> T, UserType userType) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.createUserTypeWithReturnType(T, userType).getBody(), T);
    }

    private ResponseEntity<UserType> createUserTypeWithHttpInfo(UserType userType) throws RestClientException {
        UserType localVarPostBody = userType;
        if (userType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userType' when calling createUserType");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<UserType> localReturnType = new ParameterizedTypeReference<UserType>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/types/user", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> createUserTypeWithReturnType(Class<?> T, UserType userType) throws RestClientException {
        UserType localVarPostBody = userType;
        if (userType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userType' when calling createUserType");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/types/user", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList createUserTypeWithPaginationInfo(UserType userType) throws RestClientException {
        UserType localVarPostBody = userType;
        if (userType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userType' when calling createUserType");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<UserType> localReturnType = new ParameterizedTypeReference<UserType>(){};
        ResponseEntity<UserType> responseEntity = this.apiClient.invokeAPI("/api/v1/meta/types/user", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<UserType> newResponseEntity = this.apiClient.invokeAPI("/api/v1/meta/types/user", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public void deleteUserType(String typeId) throws RestClientException {
        this.deleteUserTypeWithHttpInfo(typeId);
    }

    private ResponseEntity<Void> deleteUserTypeWithHttpInfo(String typeId) throws RestClientException {
        Object localVarPostBody = null;
        if (typeId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'typeId' when calling deleteUserType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("typeId", typeId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/types/user/{typeId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public UserType getUserType(String typeId) throws RestClientException {
        return (UserType)this.getUserTypeWithHttpInfo(typeId).getBody();
    }

    private ResponseEntity<UserType> getUserTypeWithHttpInfo(String typeId) throws RestClientException {
        Object localVarPostBody = null;
        if (typeId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'typeId' when calling getUserType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("typeId", typeId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<UserType> localReturnType = new ParameterizedTypeReference<UserType>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/types/user/{typeId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getUserTypeWithPaginationInfo(String typeId) throws RestClientException {
        Object localVarPostBody = null;
        if (typeId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'typeId' when calling getUserType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("typeId", typeId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<UserType> localReturnType = new ParameterizedTypeReference<UserType>(){};
        ResponseEntity<UserType> responseEntity = this.apiClient.invokeAPI("/api/v1/meta/types/user/{typeId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<UserType> newResponseEntity = this.apiClient.invokeAPI("/api/v1/meta/types/user/{typeId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public List<UserType> listUserTypes() throws RestClientException {
        return (List)this.listUserTypesWithHttpInfo().getBody();
    }

    private ResponseEntity<List<UserType>> listUserTypesWithHttpInfo() throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<UserType>> localReturnType = new ParameterizedTypeReference<List<UserType>>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/types/user", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listUserTypesWithPaginationInfo() throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<UserType>> localReturnType = new ParameterizedTypeReference<List<UserType>>(){};
        ResponseEntity<List<UserType>> responseEntity = this.apiClient.invokeAPI("/api/v1/meta/types/user", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<UserType>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/meta/types/user", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public UserType replaceUserType(String typeId, UserType userType) throws RestClientException {
        return (UserType)this.replaceUserTypeWithHttpInfo(typeId, userType).getBody();
    }

    public <T> T replaceUserType(Class<?> T, String typeId, UserType userType) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.replaceUserTypeWithReturnType(T, typeId, userType).getBody(), T);
    }

    private ResponseEntity<UserType> replaceUserTypeWithHttpInfo(String typeId, UserType userType) throws RestClientException {
        UserType localVarPostBody = userType;
        if (typeId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'typeId' when calling replaceUserType");
        }
        if (userType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userType' when calling replaceUserType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("typeId", typeId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<UserType> localReturnType = new ParameterizedTypeReference<UserType>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/types/user/{typeId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> replaceUserTypeWithReturnType(Class<?> T, String typeId, UserType userType) throws RestClientException {
        UserType localVarPostBody = userType;
        if (typeId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'typeId' when calling replaceUserType");
        }
        if (userType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userType' when calling replaceUserType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("typeId", typeId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/types/user/{typeId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList replaceUserTypeWithPaginationInfo(String typeId, UserType userType) throws RestClientException {
        UserType localVarPostBody = userType;
        if (typeId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'typeId' when calling replaceUserType");
        }
        if (userType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userType' when calling replaceUserType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("typeId", typeId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<UserType> localReturnType = new ParameterizedTypeReference<UserType>(){};
        ResponseEntity<UserType> responseEntity = this.apiClient.invokeAPI("/api/v1/meta/types/user/{typeId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<UserType> newResponseEntity = this.apiClient.invokeAPI("/api/v1/meta/types/user/{typeId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public UserType updateUserType(String typeId, UserType userType) throws RestClientException {
        return (UserType)this.updateUserTypeWithHttpInfo(typeId, userType).getBody();
    }

    public <T> T updateUserType(Class<?> T, String typeId, UserType userType) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.updateUserTypeWithReturnType(T, typeId, userType).getBody(), T);
    }

    private ResponseEntity<UserType> updateUserTypeWithHttpInfo(String typeId, UserType userType) throws RestClientException {
        UserType localVarPostBody = userType;
        if (typeId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'typeId' when calling updateUserType");
        }
        if (userType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userType' when calling updateUserType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("typeId", typeId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<UserType> localReturnType = new ParameterizedTypeReference<UserType>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/types/user/{typeId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> updateUserTypeWithReturnType(Class<?> T, String typeId, UserType userType) throws RestClientException {
        UserType localVarPostBody = userType;
        if (typeId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'typeId' when calling updateUserType");
        }
        if (userType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userType' when calling updateUserType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("typeId", typeId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/meta/types/user/{typeId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList updateUserTypeWithPaginationInfo(String typeId, UserType userType) throws RestClientException {
        UserType localVarPostBody = userType;
        if (typeId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'typeId' when calling updateUserType");
        }
        if (userType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userType' when calling updateUserType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("typeId", typeId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<UserType> localReturnType = new ParameterizedTypeReference<UserType>(){};
        ResponseEntity<UserType> responseEntity = this.apiClient.invokeAPI("/api/v1/meta/types/user/{typeId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<UserType> newResponseEntity = this.apiClient.invokeAPI("/api/v1/meta/types/user/{typeId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
}

