/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.common.PagedList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.RiskProvider;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.openapitools.client.api.RiskProviderApi")
public class RiskProviderApi {
    private ApiClient apiClient;

    public RiskProviderApi() {
        this(new ApiClient());
    }

    @Autowired
    public RiskProviderApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RiskProvider createRiskProvider(RiskProvider instance) throws RestClientException {
        return (RiskProvider)this.createRiskProviderWithHttpInfo(instance).getBody();
    }

    public <T> T createRiskProvider(Class<?> T, RiskProvider instance) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.createRiskProviderWithReturnType(T, instance).getBody(), T);
    }

    private ResponseEntity<RiskProvider> createRiskProviderWithHttpInfo(RiskProvider instance) throws RestClientException {
        RiskProvider localVarPostBody = instance;
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createRiskProvider");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<RiskProvider> localReturnType = new ParameterizedTypeReference<RiskProvider>(){};
        return this.apiClient.invokeAPI("/api/v1/risk/providers", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> createRiskProviderWithReturnType(Class<?> T, RiskProvider instance) throws RestClientException {
        RiskProvider localVarPostBody = instance;
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createRiskProvider");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/risk/providers", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList createRiskProviderWithPaginationInfo(RiskProvider instance) throws RestClientException {
        RiskProvider localVarPostBody = instance;
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createRiskProvider");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<RiskProvider> localReturnType = new ParameterizedTypeReference<RiskProvider>(){};
        ResponseEntity<RiskProvider> responseEntity = this.apiClient.invokeAPI("/api/v1/risk/providers", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<RiskProvider> newResponseEntity = this.apiClient.invokeAPI("/api/v1/risk/providers", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public void deleteRiskProvider(String riskProviderId) throws RestClientException {
        this.deleteRiskProviderWithHttpInfo(riskProviderId);
    }

    private ResponseEntity<Void> deleteRiskProviderWithHttpInfo(String riskProviderId) throws RestClientException {
        Object localVarPostBody = null;
        if (riskProviderId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'riskProviderId' when calling deleteRiskProvider");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("riskProviderId", riskProviderId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/risk/providers/{riskProviderId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public RiskProvider getRiskProvider(String riskProviderId) throws RestClientException {
        return (RiskProvider)this.getRiskProviderWithHttpInfo(riskProviderId).getBody();
    }

    private ResponseEntity<RiskProvider> getRiskProviderWithHttpInfo(String riskProviderId) throws RestClientException {
        Object localVarPostBody = null;
        if (riskProviderId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'riskProviderId' when calling getRiskProvider");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("riskProviderId", riskProviderId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<RiskProvider> localReturnType = new ParameterizedTypeReference<RiskProvider>(){};
        return this.apiClient.invokeAPI("/api/v1/risk/providers/{riskProviderId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getRiskProviderWithPaginationInfo(String riskProviderId) throws RestClientException {
        Object localVarPostBody = null;
        if (riskProviderId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'riskProviderId' when calling getRiskProvider");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("riskProviderId", riskProviderId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<RiskProvider> localReturnType = new ParameterizedTypeReference<RiskProvider>(){};
        ResponseEntity<RiskProvider> responseEntity = this.apiClient.invokeAPI("/api/v1/risk/providers/{riskProviderId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<RiskProvider> newResponseEntity = this.apiClient.invokeAPI("/api/v1/risk/providers/{riskProviderId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public List<RiskProvider> listRiskProviders() throws RestClientException {
        return (List)this.listRiskProvidersWithHttpInfo().getBody();
    }

    private ResponseEntity<List<RiskProvider>> listRiskProvidersWithHttpInfo() throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<RiskProvider>> localReturnType = new ParameterizedTypeReference<List<RiskProvider>>(){};
        return this.apiClient.invokeAPI("/api/v1/risk/providers", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listRiskProvidersWithPaginationInfo() throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<RiskProvider>> localReturnType = new ParameterizedTypeReference<List<RiskProvider>>(){};
        ResponseEntity<List<RiskProvider>> responseEntity = this.apiClient.invokeAPI("/api/v1/risk/providers", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<List<RiskProvider>> newResponseEntity = this.apiClient.invokeAPI("/api/v1/risk/providers", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    public RiskProvider replaceRiskProvider(String riskProviderId, RiskProvider instance) throws RestClientException {
        return (RiskProvider)this.replaceRiskProviderWithHttpInfo(riskProviderId, instance).getBody();
    }

    public <T> T replaceRiskProvider(Class<?> T, String riskProviderId, RiskProvider instance) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.replaceRiskProviderWithReturnType(T, riskProviderId, instance).getBody(), T);
    }

    private ResponseEntity<RiskProvider> replaceRiskProviderWithHttpInfo(String riskProviderId, RiskProvider instance) throws RestClientException {
        RiskProvider localVarPostBody = instance;
        if (riskProviderId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'riskProviderId' when calling replaceRiskProvider");
        }
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling replaceRiskProvider");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("riskProviderId", riskProviderId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<RiskProvider> localReturnType = new ParameterizedTypeReference<RiskProvider>(){};
        return this.apiClient.invokeAPI("/api/v1/risk/providers/{riskProviderId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> replaceRiskProviderWithReturnType(Class<?> T, String riskProviderId, RiskProvider instance) throws RestClientException {
        RiskProvider localVarPostBody = instance;
        if (riskProviderId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'riskProviderId' when calling replaceRiskProvider");
        }
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling replaceRiskProvider");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("riskProviderId", riskProviderId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/risk/providers/{riskProviderId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList replaceRiskProviderWithPaginationInfo(String riskProviderId, RiskProvider instance) throws RestClientException {
        RiskProvider localVarPostBody = instance;
        if (riskProviderId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'riskProviderId' when calling replaceRiskProvider");
        }
        if (instance == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling replaceRiskProvider");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("riskProviderId", riskProviderId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<RiskProvider> localReturnType = new ParameterizedTypeReference<RiskProvider>(){};
        ResponseEntity<RiskProvider> responseEntity = this.apiClient.invokeAPI("/api/v1/risk/providers/{riskProviderId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        PagedList pagedList = PagedList.constructPagedList(responseEntity);
        String afterMarker = pagedList.getAfter(pagedList.getNextPage());
        if (afterMarker != null) {
            PagedList newPagedList;
            do {
                localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", afterMarker));
                ResponseEntity<RiskProvider> newResponseEntity = this.apiClient.invokeAPI("/api/v1/risk/providers/{riskProviderId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                newPagedList = PagedList.constructPagedList(newResponseEntity);
                pagedList.getItems().addAll(newPagedList.getItems());
                pagedList.setNextPage(newPagedList.getNextPage());
            } while ((afterMarker = newPagedList.getAfter(newPagedList.getNextPage())) != null);
        }
        return pagedList;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
}

