/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.common.PagedList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.TrustedOrigin;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.openapitools.client.api.TrustedOriginApi")
public class TrustedOriginApi {
    private ApiClient apiClient;

    public TrustedOriginApi() {
        this(new ApiClient());
    }

    @Autowired
    public TrustedOriginApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public TrustedOrigin activateTrustedOrigin(String trustedOriginId) throws RestClientException {
        return (TrustedOrigin)this.activateTrustedOriginWithHttpInfo(trustedOriginId).getBody();
    }

    private ResponseEntity<TrustedOrigin> activateTrustedOriginWithHttpInfo(String trustedOriginId) throws RestClientException {
        Object localVarPostBody = null;
        if (trustedOriginId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'trustedOriginId' when calling activateTrustedOrigin");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("trustedOriginId", trustedOriginId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<TrustedOrigin> localReturnType = new ParameterizedTypeReference<TrustedOrigin>(){};
        return this.apiClient.invokeAPI("/api/v1/trustedOrigins/{trustedOriginId}/lifecycle/activate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList activateTrustedOriginWithPaginationInfo(String trustedOriginId) throws RestClientException {
        Object localVarPostBody = null;
        if (trustedOriginId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'trustedOriginId' when calling activateTrustedOrigin");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("trustedOriginId", trustedOriginId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<TrustedOrigin> localReturnType = new ParameterizedTypeReference<TrustedOrigin>(){};
        ResponseEntity<TrustedOrigin> responseEntity = this.apiClient.invokeAPI("/api/v1/trustedOrigins/{trustedOriginId}/lifecycle/activate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<TrustedOrigin> pagedList = new PagedList<TrustedOrigin>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((TrustedOrigin)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public TrustedOrigin createTrustedOrigin(TrustedOrigin trustedOrigin) throws RestClientException {
        return (TrustedOrigin)this.createTrustedOriginWithHttpInfo(trustedOrigin).getBody();
    }

    public <T> T createTrustedOrigin(Class<?> T, TrustedOrigin trustedOrigin) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.createTrustedOriginWithReturnType(T, trustedOrigin).getBody(), T);
    }

    private ResponseEntity<TrustedOrigin> createTrustedOriginWithHttpInfo(TrustedOrigin trustedOrigin) throws RestClientException {
        TrustedOrigin localVarPostBody = trustedOrigin;
        if (trustedOrigin == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'trustedOrigin' when calling createTrustedOrigin");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<TrustedOrigin> localReturnType = new ParameterizedTypeReference<TrustedOrigin>(){};
        return this.apiClient.invokeAPI("/api/v1/trustedOrigins", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> createTrustedOriginWithReturnType(Class<?> T, TrustedOrigin trustedOrigin) throws RestClientException {
        TrustedOrigin localVarPostBody = trustedOrigin;
        if (trustedOrigin == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'trustedOrigin' when calling createTrustedOrigin");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/trustedOrigins", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList createTrustedOriginWithPaginationInfo(TrustedOrigin trustedOrigin) throws RestClientException {
        TrustedOrigin localVarPostBody = trustedOrigin;
        if (trustedOrigin == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'trustedOrigin' when calling createTrustedOrigin");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<TrustedOrigin> localReturnType = new ParameterizedTypeReference<TrustedOrigin>(){};
        ResponseEntity<TrustedOrigin> responseEntity = this.apiClient.invokeAPI("/api/v1/trustedOrigins", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<TrustedOrigin> pagedList = new PagedList<TrustedOrigin>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((TrustedOrigin)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public TrustedOrigin deactivateTrustedOrigin(String trustedOriginId) throws RestClientException {
        return (TrustedOrigin)this.deactivateTrustedOriginWithHttpInfo(trustedOriginId).getBody();
    }

    private ResponseEntity<TrustedOrigin> deactivateTrustedOriginWithHttpInfo(String trustedOriginId) throws RestClientException {
        Object localVarPostBody = null;
        if (trustedOriginId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'trustedOriginId' when calling deactivateTrustedOrigin");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("trustedOriginId", trustedOriginId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<TrustedOrigin> localReturnType = new ParameterizedTypeReference<TrustedOrigin>(){};
        return this.apiClient.invokeAPI("/api/v1/trustedOrigins/{trustedOriginId}/lifecycle/deactivate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList deactivateTrustedOriginWithPaginationInfo(String trustedOriginId) throws RestClientException {
        Object localVarPostBody = null;
        if (trustedOriginId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'trustedOriginId' when calling deactivateTrustedOrigin");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("trustedOriginId", trustedOriginId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<TrustedOrigin> localReturnType = new ParameterizedTypeReference<TrustedOrigin>(){};
        ResponseEntity<TrustedOrigin> responseEntity = this.apiClient.invokeAPI("/api/v1/trustedOrigins/{trustedOriginId}/lifecycle/deactivate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<TrustedOrigin> pagedList = new PagedList<TrustedOrigin>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((TrustedOrigin)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public void deleteTrustedOrigin(String trustedOriginId) throws RestClientException {
        this.deleteTrustedOriginWithHttpInfo(trustedOriginId);
    }

    private ResponseEntity<Void> deleteTrustedOriginWithHttpInfo(String trustedOriginId) throws RestClientException {
        Object localVarPostBody = null;
        if (trustedOriginId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'trustedOriginId' when calling deleteTrustedOrigin");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("trustedOriginId", trustedOriginId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/trustedOrigins/{trustedOriginId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public TrustedOrigin getTrustedOrigin(String trustedOriginId) throws RestClientException {
        return (TrustedOrigin)this.getTrustedOriginWithHttpInfo(trustedOriginId).getBody();
    }

    private ResponseEntity<TrustedOrigin> getTrustedOriginWithHttpInfo(String trustedOriginId) throws RestClientException {
        Object localVarPostBody = null;
        if (trustedOriginId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'trustedOriginId' when calling getTrustedOrigin");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("trustedOriginId", trustedOriginId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<TrustedOrigin> localReturnType = new ParameterizedTypeReference<TrustedOrigin>(){};
        return this.apiClient.invokeAPI("/api/v1/trustedOrigins/{trustedOriginId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getTrustedOriginWithPaginationInfo(String trustedOriginId) throws RestClientException {
        Object localVarPostBody = null;
        if (trustedOriginId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'trustedOriginId' when calling getTrustedOrigin");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("trustedOriginId", trustedOriginId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<TrustedOrigin> localReturnType = new ParameterizedTypeReference<TrustedOrigin>(){};
        ResponseEntity<TrustedOrigin> responseEntity = this.apiClient.invokeAPI("/api/v1/trustedOrigins/{trustedOriginId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<TrustedOrigin> pagedList = new PagedList<TrustedOrigin>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((TrustedOrigin)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public List<TrustedOrigin> listTrustedOrigins(String q, String filter, String after, Integer limit) throws RestClientException {
        return (List)this.listTrustedOriginsWithHttpInfo(q, filter, after, limit).getBody();
    }

    private ResponseEntity<List<TrustedOrigin>> listTrustedOriginsWithHttpInfo(String q, String filter, String after, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "q", q));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<TrustedOrigin>> localReturnType = new ParameterizedTypeReference<List<TrustedOrigin>>(){};
        return this.apiClient.invokeAPI("/api/v1/trustedOrigins", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listTrustedOriginsWithPaginationInfo(String q, String filter, String after, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "q", q));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<TrustedOrigin>> localReturnType = new ParameterizedTypeReference<List<TrustedOrigin>>(){};
        ResponseEntity<List<TrustedOrigin>> responseEntity = this.apiClient.invokeAPI("/api/v1/trustedOrigins", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public TrustedOrigin replaceTrustedOrigin(String trustedOriginId, TrustedOrigin trustedOrigin) throws RestClientException {
        return (TrustedOrigin)this.replaceTrustedOriginWithHttpInfo(trustedOriginId, trustedOrigin).getBody();
    }

    public <T> T replaceTrustedOrigin(Class<?> T, String trustedOriginId, TrustedOrigin trustedOrigin) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.replaceTrustedOriginWithReturnType(T, trustedOriginId, trustedOrigin).getBody(), T);
    }

    private ResponseEntity<TrustedOrigin> replaceTrustedOriginWithHttpInfo(String trustedOriginId, TrustedOrigin trustedOrigin) throws RestClientException {
        TrustedOrigin localVarPostBody = trustedOrigin;
        if (trustedOriginId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'trustedOriginId' when calling replaceTrustedOrigin");
        }
        if (trustedOrigin == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'trustedOrigin' when calling replaceTrustedOrigin");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("trustedOriginId", trustedOriginId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<TrustedOrigin> localReturnType = new ParameterizedTypeReference<TrustedOrigin>(){};
        return this.apiClient.invokeAPI("/api/v1/trustedOrigins/{trustedOriginId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> replaceTrustedOriginWithReturnType(Class<?> T, String trustedOriginId, TrustedOrigin trustedOrigin) throws RestClientException {
        TrustedOrigin localVarPostBody = trustedOrigin;
        if (trustedOriginId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'trustedOriginId' when calling replaceTrustedOrigin");
        }
        if (trustedOrigin == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'trustedOrigin' when calling replaceTrustedOrigin");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("trustedOriginId", trustedOriginId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/trustedOrigins/{trustedOriginId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList replaceTrustedOriginWithPaginationInfo(String trustedOriginId, TrustedOrigin trustedOrigin) throws RestClientException {
        TrustedOrigin localVarPostBody = trustedOrigin;
        if (trustedOriginId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'trustedOriginId' when calling replaceTrustedOrigin");
        }
        if (trustedOrigin == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'trustedOrigin' when calling replaceTrustedOrigin");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("trustedOriginId", trustedOriginId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<TrustedOrigin> localReturnType = new ParameterizedTypeReference<TrustedOrigin>(){};
        ResponseEntity<TrustedOrigin> responseEntity = this.apiClient.invokeAPI("/api/v1/trustedOrigins/{trustedOriginId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<TrustedOrigin> pagedList = new PagedList<TrustedOrigin>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((TrustedOrigin)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
}

