/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.common.PagedList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.ThreatInsightConfiguration;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.openapitools.client.api.ThreatInsightApi")
public class ThreatInsightApi {
    private ApiClient apiClient;

    public ThreatInsightApi() {
        this(new ApiClient());
    }

    @Autowired
    public ThreatInsightApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ThreatInsightConfiguration getCurrentConfiguration() throws RestClientException {
        return (ThreatInsightConfiguration)this.getCurrentConfigurationWithHttpInfo().getBody();
    }

    private ResponseEntity<ThreatInsightConfiguration> getCurrentConfigurationWithHttpInfo() throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ThreatInsightConfiguration> localReturnType = new ParameterizedTypeReference<ThreatInsightConfiguration>(){};
        return this.apiClient.invokeAPI("/api/v1/threats/configuration", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getCurrentConfigurationWithPaginationInfo() throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ThreatInsightConfiguration> localReturnType = new ParameterizedTypeReference<ThreatInsightConfiguration>(){};
        ResponseEntity<ThreatInsightConfiguration> responseEntity = this.apiClient.invokeAPI("/api/v1/threats/configuration", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<ThreatInsightConfiguration> pagedList = new PagedList<ThreatInsightConfiguration>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((ThreatInsightConfiguration)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public ThreatInsightConfiguration updateConfiguration(ThreatInsightConfiguration threatInsightConfiguration) throws RestClientException {
        return (ThreatInsightConfiguration)this.updateConfigurationWithHttpInfo(threatInsightConfiguration).getBody();
    }

    public <T> T updateConfiguration(Class<?> T, ThreatInsightConfiguration threatInsightConfiguration) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.updateConfigurationWithReturnType(T, threatInsightConfiguration).getBody(), T);
    }

    private ResponseEntity<ThreatInsightConfiguration> updateConfigurationWithHttpInfo(ThreatInsightConfiguration threatInsightConfiguration) throws RestClientException {
        ThreatInsightConfiguration localVarPostBody = threatInsightConfiguration;
        if (threatInsightConfiguration == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'threatInsightConfiguration' when calling updateConfiguration");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ThreatInsightConfiguration> localReturnType = new ParameterizedTypeReference<ThreatInsightConfiguration>(){};
        return this.apiClient.invokeAPI("/api/v1/threats/configuration", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> updateConfigurationWithReturnType(Class<?> T, ThreatInsightConfiguration threatInsightConfiguration) throws RestClientException {
        ThreatInsightConfiguration localVarPostBody = threatInsightConfiguration;
        if (threatInsightConfiguration == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'threatInsightConfiguration' when calling updateConfiguration");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/threats/configuration", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList updateConfigurationWithPaginationInfo(ThreatInsightConfiguration threatInsightConfiguration) throws RestClientException {
        ThreatInsightConfiguration localVarPostBody = threatInsightConfiguration;
        if (threatInsightConfiguration == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'threatInsightConfiguration' when calling updateConfiguration");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ThreatInsightConfiguration> localReturnType = new ParameterizedTypeReference<ThreatInsightConfiguration>(){};
        ResponseEntity<ThreatInsightConfiguration> responseEntity = this.apiClient.invokeAPI("/api/v1/threats/configuration", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<ThreatInsightConfiguration> pagedList = new PagedList<ThreatInsightConfiguration>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((ThreatInsightConfiguration)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
}

