/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.common.PagedList;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.AppUser;
import org.openapitools.client.model.Application;
import org.openapitools.client.model.ApplicationFeature;
import org.openapitools.client.model.ApplicationGroupAssignment;
import org.openapitools.client.model.CapabilitiesObject;
import org.openapitools.client.model.Csr;
import org.openapitools.client.model.CsrMetadata;
import org.openapitools.client.model.JsonWebKey;
import org.openapitools.client.model.OAuth2ScopeConsentGrant;
import org.openapitools.client.model.OAuth2Token;
import org.openapitools.client.model.ProvisioningConnection;
import org.openapitools.client.model.ProvisioningConnectionRequest;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.openapitools.client.api.ApplicationApi")
public class ApplicationApi {
    private ApiClient apiClient;

    public ApplicationApi() {
        this(new ApiClient());
    }

    @Autowired
    public ApplicationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void activateApplication(String appId) throws RestClientException {
        this.activateApplicationWithHttpInfo(appId);
    }

    private ResponseEntity<Void> activateApplicationWithHttpInfo(String appId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling activateApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/lifecycle/activate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void activateDefaultProvisioningConnectionForApplication(String appId) throws RestClientException {
        this.activateDefaultProvisioningConnectionForApplicationWithHttpInfo(appId);
    }

    private ResponseEntity<Void> activateDefaultProvisioningConnectionForApplicationWithHttpInfo(String appId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling activateDefaultProvisioningConnectionForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/connections/default/lifecycle/activate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void assignApplicationPolicy(String appId, String policyId) throws RestClientException {
        this.assignApplicationPolicyWithHttpInfo(appId, policyId);
    }

    private ResponseEntity<Void> assignApplicationPolicyWithHttpInfo(String appId, String policyId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling assignApplicationPolicy");
        }
        if (policyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling assignApplicationPolicy");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("policyId", policyId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/policies/{policyId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public ApplicationGroupAssignment assignGroupToApplication(String appId, String groupId, ApplicationGroupAssignment applicationGroupAssignment) throws RestClientException {
        return (ApplicationGroupAssignment)this.assignGroupToApplicationWithHttpInfo(appId, groupId, applicationGroupAssignment).getBody();
    }

    public <T> T assignGroupToApplication(Class<?> T, String appId, String groupId, ApplicationGroupAssignment applicationGroupAssignment) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.assignGroupToApplicationWithReturnType(T, appId, groupId, applicationGroupAssignment).getBody(), T);
    }

    private ResponseEntity<ApplicationGroupAssignment> assignGroupToApplicationWithHttpInfo(String appId, String groupId, ApplicationGroupAssignment applicationGroupAssignment) throws RestClientException {
        ApplicationGroupAssignment localVarPostBody = applicationGroupAssignment;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling assignGroupToApplication");
        }
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignGroupToApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("groupId", groupId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ApplicationGroupAssignment> localReturnType = new ParameterizedTypeReference<ApplicationGroupAssignment>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/groups/{groupId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> assignGroupToApplicationWithReturnType(Class<?> T, String appId, String groupId, ApplicationGroupAssignment applicationGroupAssignment) throws RestClientException {
        ApplicationGroupAssignment localVarPostBody = applicationGroupAssignment;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling assignGroupToApplication");
        }
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignGroupToApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("groupId", groupId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/groups/{groupId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList assignGroupToApplicationWithPaginationInfo(String appId, String groupId, ApplicationGroupAssignment applicationGroupAssignment) throws RestClientException {
        ApplicationGroupAssignment localVarPostBody = applicationGroupAssignment;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling assignGroupToApplication");
        }
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignGroupToApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("groupId", groupId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ApplicationGroupAssignment> localReturnType = new ParameterizedTypeReference<ApplicationGroupAssignment>(){};
        ResponseEntity<ApplicationGroupAssignment> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/groups/{groupId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<ApplicationGroupAssignment> pagedList = new PagedList<ApplicationGroupAssignment>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((ApplicationGroupAssignment)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public AppUser assignUserToApplication(String appId, AppUser appUser) throws RestClientException {
        return (AppUser)this.assignUserToApplicationWithHttpInfo(appId, appUser).getBody();
    }

    public <T> T assignUserToApplication(Class<?> T, String appId, AppUser appUser) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.assignUserToApplicationWithReturnType(T, appId, appUser).getBody(), T);
    }

    private ResponseEntity<AppUser> assignUserToApplicationWithHttpInfo(String appId, AppUser appUser) throws RestClientException {
        AppUser localVarPostBody = appUser;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling assignUserToApplication");
        }
        if (appUser == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appUser' when calling assignUserToApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AppUser> localReturnType = new ParameterizedTypeReference<AppUser>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/users", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> assignUserToApplicationWithReturnType(Class<?> T, String appId, AppUser appUser) throws RestClientException {
        AppUser localVarPostBody = appUser;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling assignUserToApplication");
        }
        if (appUser == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appUser' when calling assignUserToApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/users", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList assignUserToApplicationWithPaginationInfo(String appId, AppUser appUser) throws RestClientException {
        AppUser localVarPostBody = appUser;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling assignUserToApplication");
        }
        if (appUser == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appUser' when calling assignUserToApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AppUser> localReturnType = new ParameterizedTypeReference<AppUser>(){};
        ResponseEntity<AppUser> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/users", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<AppUser> pagedList = new PagedList<AppUser>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((AppUser)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public JsonWebKey cloneApplicationKey(String appId, String keyId, String targetAid) throws RestClientException {
        return (JsonWebKey)this.cloneApplicationKeyWithHttpInfo(appId, keyId, targetAid).getBody();
    }

    private ResponseEntity<JsonWebKey> cloneApplicationKeyWithHttpInfo(String appId, String keyId, String targetAid) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling cloneApplicationKey");
        }
        if (keyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'keyId' when calling cloneApplicationKey");
        }
        if (targetAid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'targetAid' when calling cloneApplicationKey");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("keyId", keyId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "targetAid", targetAid));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/keys/{keyId}/clone", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList cloneApplicationKeyWithPaginationInfo(String appId, String keyId, String targetAid) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling cloneApplicationKey");
        }
        if (keyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'keyId' when calling cloneApplicationKey");
        }
        if (targetAid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'targetAid' when calling cloneApplicationKey");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("keyId", keyId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "targetAid", targetAid));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>(){};
        ResponseEntity<JsonWebKey> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/keys/{keyId}/clone", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<JsonWebKey> pagedList = new PagedList<JsonWebKey>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((JsonWebKey)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public Application createApplication(Application application, Boolean activate, String oktaAccessGatewayAgent) throws RestClientException {
        return (Application)this.createApplicationWithHttpInfo(application, activate, oktaAccessGatewayAgent).getBody();
    }

    public <T> T createApplication(Class<?> T, Application application, Boolean activate, String oktaAccessGatewayAgent) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.createApplicationWithReturnType(T, application, activate, oktaAccessGatewayAgent).getBody(), T);
    }

    private ResponseEntity<Application> createApplicationWithHttpInfo(Application application, Boolean activate, String oktaAccessGatewayAgent) throws RestClientException {
        Application localVarPostBody = application;
        if (application == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'application' when calling createApplication");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "activate", activate));
        if (oktaAccessGatewayAgent != null) {
            localVarHeaderParams.add("OktaAccessGateway-Agent", this.apiClient.parameterToString(oktaAccessGatewayAgent));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Application> localReturnType = new ParameterizedTypeReference<Application>(){};
        return this.apiClient.invokeAPI("/api/v1/apps", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> createApplicationWithReturnType(Class<?> T, Application application, Boolean activate, String oktaAccessGatewayAgent) throws RestClientException {
        Application localVarPostBody = application;
        if (application == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'application' when calling createApplication");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "activate", activate));
        if (oktaAccessGatewayAgent != null) {
            localVarHeaderParams.add("OktaAccessGateway-Agent", this.apiClient.parameterToString(oktaAccessGatewayAgent));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/apps", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList createApplicationWithPaginationInfo(Application application, Boolean activate, String oktaAccessGatewayAgent) throws RestClientException {
        Application localVarPostBody = application;
        if (application == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'application' when calling createApplication");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "activate", activate));
        if (oktaAccessGatewayAgent != null) {
            localVarHeaderParams.add("OktaAccessGateway-Agent", this.apiClient.parameterToString(oktaAccessGatewayAgent));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Application> localReturnType = new ParameterizedTypeReference<Application>(){};
        ResponseEntity<Application> responseEntity = this.apiClient.invokeAPI("/api/v1/apps", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<Application> pagedList = new PagedList<Application>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((Application)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public void deactivateApplication(String appId) throws RestClientException {
        this.deactivateApplicationWithHttpInfo(appId);
    }

    private ResponseEntity<Void> deactivateApplicationWithHttpInfo(String appId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling deactivateApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/lifecycle/deactivate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void deactivateDefaultProvisioningConnectionForApplication(String appId) throws RestClientException {
        this.deactivateDefaultProvisioningConnectionForApplicationWithHttpInfo(appId);
    }

    private ResponseEntity<Void> deactivateDefaultProvisioningConnectionForApplicationWithHttpInfo(String appId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling deactivateDefaultProvisioningConnectionForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/connections/default/lifecycle/deactivate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void deleteApplication(String appId) throws RestClientException {
        this.deleteApplicationWithHttpInfo(appId);
    }

    private ResponseEntity<Void> deleteApplicationWithHttpInfo(String appId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling deleteApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public JsonWebKey generateApplicationKey(String appId, Integer validityYears) throws RestClientException {
        return (JsonWebKey)this.generateApplicationKeyWithHttpInfo(appId, validityYears).getBody();
    }

    private ResponseEntity<JsonWebKey> generateApplicationKeyWithHttpInfo(String appId, Integer validityYears) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling generateApplicationKey");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "validityYears", validityYears));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/keys/generate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList generateApplicationKeyWithPaginationInfo(String appId, Integer validityYears) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling generateApplicationKey");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "validityYears", validityYears));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>(){};
        ResponseEntity<JsonWebKey> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/keys/generate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<JsonWebKey> pagedList = new PagedList<JsonWebKey>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((JsonWebKey)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public Csr generateCsrForApplication(String appId, CsrMetadata metadata) throws RestClientException {
        return (Csr)this.generateCsrForApplicationWithHttpInfo(appId, metadata).getBody();
    }

    public <T> T generateCsrForApplication(Class<?> T, String appId, CsrMetadata metadata) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.generateCsrForApplicationWithReturnType(T, appId, metadata).getBody(), T);
    }

    private ResponseEntity<Csr> generateCsrForApplicationWithHttpInfo(String appId, CsrMetadata metadata) throws RestClientException {
        CsrMetadata localVarPostBody = metadata;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling generateCsrForApplication");
        }
        if (metadata == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'metadata' when calling generateCsrForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Csr> localReturnType = new ParameterizedTypeReference<Csr>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> generateCsrForApplicationWithReturnType(Class<?> T, String appId, CsrMetadata metadata) throws RestClientException {
        CsrMetadata localVarPostBody = metadata;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling generateCsrForApplication");
        }
        if (metadata == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'metadata' when calling generateCsrForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList generateCsrForApplicationWithPaginationInfo(String appId, CsrMetadata metadata) throws RestClientException {
        CsrMetadata localVarPostBody = metadata;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling generateCsrForApplication");
        }
        if (metadata == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'metadata' when calling generateCsrForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Csr> localReturnType = new ParameterizedTypeReference<Csr>(){};
        ResponseEntity<Csr> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<Csr> pagedList = new PagedList<Csr>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((Csr)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public Application getApplication(String appId, String expand) throws RestClientException {
        return (Application)this.getApplicationWithHttpInfo(appId, expand).getBody();
    }

    private ResponseEntity<Application> getApplicationWithHttpInfo(String appId, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Application> localReturnType = new ParameterizedTypeReference<Application>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getApplicationWithPaginationInfo(String appId, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Application> localReturnType = new ParameterizedTypeReference<Application>(){};
        ResponseEntity<Application> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<Application> pagedList = new PagedList<Application>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((Application)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public ApplicationGroupAssignment getApplicationGroupAssignment(String appId, String groupId, String expand) throws RestClientException {
        return (ApplicationGroupAssignment)this.getApplicationGroupAssignmentWithHttpInfo(appId, groupId, expand).getBody();
    }

    private ResponseEntity<ApplicationGroupAssignment> getApplicationGroupAssignmentWithHttpInfo(String appId, String groupId, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getApplicationGroupAssignment");
        }
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling getApplicationGroupAssignment");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("groupId", groupId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ApplicationGroupAssignment> localReturnType = new ParameterizedTypeReference<ApplicationGroupAssignment>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/groups/{groupId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getApplicationGroupAssignmentWithPaginationInfo(String appId, String groupId, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getApplicationGroupAssignment");
        }
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling getApplicationGroupAssignment");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("groupId", groupId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ApplicationGroupAssignment> localReturnType = new ParameterizedTypeReference<ApplicationGroupAssignment>(){};
        ResponseEntity<ApplicationGroupAssignment> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/groups/{groupId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<ApplicationGroupAssignment> pagedList = new PagedList<ApplicationGroupAssignment>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((ApplicationGroupAssignment)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public JsonWebKey getApplicationKey(String appId, String keyId) throws RestClientException {
        return (JsonWebKey)this.getApplicationKeyWithHttpInfo(appId, keyId).getBody();
    }

    private ResponseEntity<JsonWebKey> getApplicationKeyWithHttpInfo(String appId, String keyId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getApplicationKey");
        }
        if (keyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'keyId' when calling getApplicationKey");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("keyId", keyId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/keys/{keyId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getApplicationKeyWithPaginationInfo(String appId, String keyId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getApplicationKey");
        }
        if (keyId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'keyId' when calling getApplicationKey");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("keyId", keyId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>(){};
        ResponseEntity<JsonWebKey> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/keys/{keyId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<JsonWebKey> pagedList = new PagedList<JsonWebKey>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((JsonWebKey)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public AppUser getApplicationUser(String appId, String userId, String expand) throws RestClientException {
        return (AppUser)this.getApplicationUserWithHttpInfo(appId, userId, expand).getBody();
    }

    private ResponseEntity<AppUser> getApplicationUserWithHttpInfo(String appId, String userId, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getApplicationUser");
        }
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getApplicationUser");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AppUser> localReturnType = new ParameterizedTypeReference<AppUser>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/users/{userId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getApplicationUserWithPaginationInfo(String appId, String userId, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getApplicationUser");
        }
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getApplicationUser");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AppUser> localReturnType = new ParameterizedTypeReference<AppUser>(){};
        ResponseEntity<AppUser> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/users/{userId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<AppUser> pagedList = new PagedList<AppUser>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((AppUser)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public Csr getCsrForApplication(String appId, String csrId) throws RestClientException {
        return (Csr)this.getCsrForApplicationWithHttpInfo(appId, csrId).getBody();
    }

    private ResponseEntity<Csr> getCsrForApplicationWithHttpInfo(String appId, String csrId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getCsrForApplication");
        }
        if (csrId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling getCsrForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("csrId", csrId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Csr> localReturnType = new ParameterizedTypeReference<Csr>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs/{csrId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getCsrForApplicationWithPaginationInfo(String appId, String csrId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getCsrForApplication");
        }
        if (csrId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling getCsrForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("csrId", csrId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Csr> localReturnType = new ParameterizedTypeReference<Csr>(){};
        ResponseEntity<Csr> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs/{csrId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<Csr> pagedList = new PagedList<Csr>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((Csr)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public ProvisioningConnection getDefaultProvisioningConnectionForApplication(String appId) throws RestClientException {
        return (ProvisioningConnection)this.getDefaultProvisioningConnectionForApplicationWithHttpInfo(appId).getBody();
    }

    private ResponseEntity<ProvisioningConnection> getDefaultProvisioningConnectionForApplicationWithHttpInfo(String appId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getDefaultProvisioningConnectionForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ProvisioningConnection> localReturnType = new ParameterizedTypeReference<ProvisioningConnection>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/connections/default", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getDefaultProvisioningConnectionForApplicationWithPaginationInfo(String appId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getDefaultProvisioningConnectionForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ProvisioningConnection> localReturnType = new ParameterizedTypeReference<ProvisioningConnection>(){};
        ResponseEntity<ProvisioningConnection> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/connections/default", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<ProvisioningConnection> pagedList = new PagedList<ProvisioningConnection>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((ProvisioningConnection)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public ApplicationFeature getFeatureForApplication(String appId, String name) throws RestClientException {
        return (ApplicationFeature)this.getFeatureForApplicationWithHttpInfo(appId, name).getBody();
    }

    private ResponseEntity<ApplicationFeature> getFeatureForApplicationWithHttpInfo(String appId, String name) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getFeatureForApplication");
        }
        if (name == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'name' when calling getFeatureForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("name", name);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ApplicationFeature> localReturnType = new ParameterizedTypeReference<ApplicationFeature>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/features/{name}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getFeatureForApplicationWithPaginationInfo(String appId, String name) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getFeatureForApplication");
        }
        if (name == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'name' when calling getFeatureForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("name", name);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ApplicationFeature> localReturnType = new ParameterizedTypeReference<ApplicationFeature>(){};
        ResponseEntity<ApplicationFeature> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/features/{name}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<ApplicationFeature> pagedList = new PagedList<ApplicationFeature>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((ApplicationFeature)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public OAuth2Token getOAuth2TokenForApplication(String appId, String tokenId, String expand) throws RestClientException {
        return (OAuth2Token)this.getOAuth2TokenForApplicationWithHttpInfo(appId, tokenId, expand).getBody();
    }

    private ResponseEntity<OAuth2Token> getOAuth2TokenForApplicationWithHttpInfo(String appId, String tokenId, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getOAuth2TokenForApplication");
        }
        if (tokenId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tokenId' when calling getOAuth2TokenForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("tokenId", tokenId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<OAuth2Token> localReturnType = new ParameterizedTypeReference<OAuth2Token>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/tokens/{tokenId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getOAuth2TokenForApplicationWithPaginationInfo(String appId, String tokenId, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getOAuth2TokenForApplication");
        }
        if (tokenId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tokenId' when calling getOAuth2TokenForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("tokenId", tokenId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<OAuth2Token> localReturnType = new ParameterizedTypeReference<OAuth2Token>(){};
        ResponseEntity<OAuth2Token> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/tokens/{tokenId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<OAuth2Token> pagedList = new PagedList<OAuth2Token>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((OAuth2Token)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public OAuth2ScopeConsentGrant getScopeConsentGrant(String appId, String grantId, String expand) throws RestClientException {
        return (OAuth2ScopeConsentGrant)this.getScopeConsentGrantWithHttpInfo(appId, grantId, expand).getBody();
    }

    private ResponseEntity<OAuth2ScopeConsentGrant> getScopeConsentGrantWithHttpInfo(String appId, String grantId, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getScopeConsentGrant");
        }
        if (grantId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'grantId' when calling getScopeConsentGrant");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("grantId", grantId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken"};
        ParameterizedTypeReference<OAuth2ScopeConsentGrant> localReturnType = new ParameterizedTypeReference<OAuth2ScopeConsentGrant>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/grants/{grantId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getScopeConsentGrantWithPaginationInfo(String appId, String grantId, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getScopeConsentGrant");
        }
        if (grantId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'grantId' when calling getScopeConsentGrant");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("grantId", grantId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken"};
        ParameterizedTypeReference<OAuth2ScopeConsentGrant> localReturnType = new ParameterizedTypeReference<OAuth2ScopeConsentGrant>(){};
        ResponseEntity<OAuth2ScopeConsentGrant> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/grants/{grantId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<OAuth2ScopeConsentGrant> pagedList = new PagedList<OAuth2ScopeConsentGrant>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((OAuth2ScopeConsentGrant)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public OAuth2ScopeConsentGrant grantConsentToScope(String appId, OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant) throws RestClientException {
        return (OAuth2ScopeConsentGrant)this.grantConsentToScopeWithHttpInfo(appId, oAuth2ScopeConsentGrant).getBody();
    }

    public <T> T grantConsentToScope(Class<?> T, String appId, OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.grantConsentToScopeWithReturnType(T, appId, oAuth2ScopeConsentGrant).getBody(), T);
    }

    private ResponseEntity<OAuth2ScopeConsentGrant> grantConsentToScopeWithHttpInfo(String appId, OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant) throws RestClientException {
        OAuth2ScopeConsentGrant localVarPostBody = oAuth2ScopeConsentGrant;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling grantConsentToScope");
        }
        if (oAuth2ScopeConsentGrant == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2ScopeConsentGrant' when calling grantConsentToScope");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken"};
        ParameterizedTypeReference<OAuth2ScopeConsentGrant> localReturnType = new ParameterizedTypeReference<OAuth2ScopeConsentGrant>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/grants", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> grantConsentToScopeWithReturnType(Class<?> T, String appId, OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant) throws RestClientException {
        OAuth2ScopeConsentGrant localVarPostBody = oAuth2ScopeConsentGrant;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling grantConsentToScope");
        }
        if (oAuth2ScopeConsentGrant == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2ScopeConsentGrant' when calling grantConsentToScope");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/grants", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList grantConsentToScopeWithPaginationInfo(String appId, OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant) throws RestClientException {
        OAuth2ScopeConsentGrant localVarPostBody = oAuth2ScopeConsentGrant;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling grantConsentToScope");
        }
        if (oAuth2ScopeConsentGrant == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2ScopeConsentGrant' when calling grantConsentToScope");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken"};
        ParameterizedTypeReference<OAuth2ScopeConsentGrant> localReturnType = new ParameterizedTypeReference<OAuth2ScopeConsentGrant>(){};
        ResponseEntity<OAuth2ScopeConsentGrant> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/grants", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<OAuth2ScopeConsentGrant> pagedList = new PagedList<OAuth2ScopeConsentGrant>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((OAuth2ScopeConsentGrant)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public List<ApplicationGroupAssignment> listApplicationGroupAssignments(String appId, String q, String after, Integer limit, String expand) throws RestClientException {
        return (List)this.listApplicationGroupAssignmentsWithHttpInfo(appId, q, after, limit, expand).getBody();
    }

    private ResponseEntity<List<ApplicationGroupAssignment>> listApplicationGroupAssignmentsWithHttpInfo(String appId, String q, String after, Integer limit, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listApplicationGroupAssignments");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "q", q));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<ApplicationGroupAssignment>> localReturnType = new ParameterizedTypeReference<List<ApplicationGroupAssignment>>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/groups", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listApplicationGroupAssignmentsWithPaginationInfo(String appId, String q, String after, Integer limit, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listApplicationGroupAssignments");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "q", q));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<ApplicationGroupAssignment>> localReturnType = new ParameterizedTypeReference<List<ApplicationGroupAssignment>>(){};
        ResponseEntity<List<ApplicationGroupAssignment>> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/groups", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public List<JsonWebKey> listApplicationKeys(String appId) throws RestClientException {
        return (List)this.listApplicationKeysWithHttpInfo(appId).getBody();
    }

    private ResponseEntity<List<JsonWebKey>> listApplicationKeysWithHttpInfo(String appId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listApplicationKeys");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<JsonWebKey>> localReturnType = new ParameterizedTypeReference<List<JsonWebKey>>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/keys", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listApplicationKeysWithPaginationInfo(String appId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listApplicationKeys");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<JsonWebKey>> localReturnType = new ParameterizedTypeReference<List<JsonWebKey>>(){};
        ResponseEntity<List<JsonWebKey>> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/keys", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public List<AppUser> listApplicationUsers(String appId, String q, String queryScope, String after, Integer limit, String filter, String expand) throws RestClientException {
        return (List)this.listApplicationUsersWithHttpInfo(appId, q, queryScope, after, limit, filter, expand).getBody();
    }

    private ResponseEntity<List<AppUser>> listApplicationUsersWithHttpInfo(String appId, String q, String queryScope, String after, Integer limit, String filter, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listApplicationUsers");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "q", q));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "query_scope", queryScope));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<AppUser>> localReturnType = new ParameterizedTypeReference<List<AppUser>>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/users", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listApplicationUsersWithPaginationInfo(String appId, String q, String queryScope, String after, Integer limit, String filter, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listApplicationUsers");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "q", q));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "query_scope", queryScope));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<AppUser>> localReturnType = new ParameterizedTypeReference<List<AppUser>>(){};
        ResponseEntity<List<AppUser>> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/users", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public List<Application> listApplications(String q, String after, Integer limit, String filter, String expand, Boolean includeNonDeleted) throws RestClientException {
        return (List)this.listApplicationsWithHttpInfo(q, after, limit, filter, expand, includeNonDeleted).getBody();
    }

    private ResponseEntity<List<Application>> listApplicationsWithHttpInfo(String q, String after, Integer limit, String filter, String expand, Boolean includeNonDeleted) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "q", q));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "includeNonDeleted", includeNonDeleted));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<Application>> localReturnType = new ParameterizedTypeReference<List<Application>>(){};
        return this.apiClient.invokeAPI("/api/v1/apps", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listApplicationsWithPaginationInfo(String q, String after, Integer limit, String filter, String expand, Boolean includeNonDeleted) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "q", q));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "includeNonDeleted", includeNonDeleted));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<Application>> localReturnType = new ParameterizedTypeReference<List<Application>>(){};
        ResponseEntity<List<Application>> responseEntity = this.apiClient.invokeAPI("/api/v1/apps", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public List<Csr> listCsrsForApplication(String appId) throws RestClientException {
        return (List)this.listCsrsForApplicationWithHttpInfo(appId).getBody();
    }

    private ResponseEntity<List<Csr>> listCsrsForApplicationWithHttpInfo(String appId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listCsrsForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<Csr>> localReturnType = new ParameterizedTypeReference<List<Csr>>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listCsrsForApplicationWithPaginationInfo(String appId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listCsrsForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<Csr>> localReturnType = new ParameterizedTypeReference<List<Csr>>(){};
        ResponseEntity<List<Csr>> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public List<ApplicationFeature> listFeaturesForApplication(String appId) throws RestClientException {
        return (List)this.listFeaturesForApplicationWithHttpInfo(appId).getBody();
    }

    private ResponseEntity<List<ApplicationFeature>> listFeaturesForApplicationWithHttpInfo(String appId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listFeaturesForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<ApplicationFeature>> localReturnType = new ParameterizedTypeReference<List<ApplicationFeature>>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/features", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listFeaturesForApplicationWithPaginationInfo(String appId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listFeaturesForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<ApplicationFeature>> localReturnType = new ParameterizedTypeReference<List<ApplicationFeature>>(){};
        ResponseEntity<List<ApplicationFeature>> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/features", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public List<OAuth2Token> listOAuth2TokensForApplication(String appId, String expand, String after, Integer limit) throws RestClientException {
        return (List)this.listOAuth2TokensForApplicationWithHttpInfo(appId, expand, after, limit).getBody();
    }

    private ResponseEntity<List<OAuth2Token>> listOAuth2TokensForApplicationWithHttpInfo(String appId, String expand, String after, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listOAuth2TokensForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<OAuth2Token>> localReturnType = new ParameterizedTypeReference<List<OAuth2Token>>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/tokens", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listOAuth2TokensForApplicationWithPaginationInfo(String appId, String expand, String after, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listOAuth2TokensForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<List<OAuth2Token>> localReturnType = new ParameterizedTypeReference<List<OAuth2Token>>(){};
        ResponseEntity<List<OAuth2Token>> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/tokens", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public List<OAuth2ScopeConsentGrant> listScopeConsentGrants(String appId, String expand) throws RestClientException {
        return (List)this.listScopeConsentGrantsWithHttpInfo(appId, expand).getBody();
    }

    private ResponseEntity<List<OAuth2ScopeConsentGrant>> listScopeConsentGrantsWithHttpInfo(String appId, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listScopeConsentGrants");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken"};
        ParameterizedTypeReference<List<OAuth2ScopeConsentGrant>> localReturnType = new ParameterizedTypeReference<List<OAuth2ScopeConsentGrant>>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/grants", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listScopeConsentGrantsWithPaginationInfo(String appId, String expand) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listScopeConsentGrants");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expand", expand));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken"};
        ParameterizedTypeReference<List<OAuth2ScopeConsentGrant>> localReturnType = new ParameterizedTypeReference<List<OAuth2ScopeConsentGrant>>(){};
        ResponseEntity<List<OAuth2ScopeConsentGrant>> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/grants", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public JsonWebKey publishCsrFromApplication(String appId, String csrId, File body) throws RestClientException {
        return (JsonWebKey)this.publishCsrFromApplicationWithHttpInfo(appId, csrId, body).getBody();
    }

    public <T> T publishCsrFromApplication(Class<?> T, String appId, String csrId, File body) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.publishCsrFromApplicationWithReturnType(T, appId, csrId, body).getBody(), T);
    }

    private ResponseEntity<JsonWebKey> publishCsrFromApplicationWithHttpInfo(String appId, String csrId, File body) throws RestClientException {
        File localVarPostBody = body;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling publishCsrFromApplication");
        }
        if (csrId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling publishCsrFromApplication");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling publishCsrFromApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("csrId", csrId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/x-x509-ca-cert", "application/pkix-cert", "application/x-pem-file"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs/{csrId}/lifecycle/publish", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> publishCsrFromApplicationWithReturnType(Class<?> T, String appId, String csrId, File body) throws RestClientException {
        File localVarPostBody = body;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling publishCsrFromApplication");
        }
        if (csrId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling publishCsrFromApplication");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling publishCsrFromApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("csrId", csrId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/x-x509-ca-cert", "application/pkix-cert", "application/x-pem-file"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs/{csrId}/lifecycle/publish", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList publishCsrFromApplicationWithPaginationInfo(String appId, String csrId, File body) throws RestClientException {
        File localVarPostBody = body;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling publishCsrFromApplication");
        }
        if (csrId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling publishCsrFromApplication");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling publishCsrFromApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("csrId", csrId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/x-x509-ca-cert", "application/pkix-cert", "application/x-pem-file"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>(){};
        ResponseEntity<JsonWebKey> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs/{csrId}/lifecycle/publish", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<JsonWebKey> pagedList = new PagedList<JsonWebKey>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((JsonWebKey)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public Application replaceApplication(String appId, Application application) throws RestClientException {
        return (Application)this.replaceApplicationWithHttpInfo(appId, application).getBody();
    }

    public <T> T replaceApplication(Class<?> T, String appId, Application application) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.replaceApplicationWithReturnType(T, appId, application).getBody(), T);
    }

    private ResponseEntity<Application> replaceApplicationWithHttpInfo(String appId, Application application) throws RestClientException {
        Application localVarPostBody = application;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling replaceApplication");
        }
        if (application == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'application' when calling replaceApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Application> localReturnType = new ParameterizedTypeReference<Application>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> replaceApplicationWithReturnType(Class<?> T, String appId, Application application) throws RestClientException {
        Application localVarPostBody = application;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling replaceApplication");
        }
        if (application == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'application' when calling replaceApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList replaceApplicationWithPaginationInfo(String appId, Application application) throws RestClientException {
        Application localVarPostBody = application;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling replaceApplication");
        }
        if (application == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'application' when calling replaceApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Application> localReturnType = new ParameterizedTypeReference<Application>(){};
        ResponseEntity<Application> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<Application> pagedList = new PagedList<Application>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((Application)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public void revokeCsrFromApplication(String appId, String csrId) throws RestClientException {
        this.revokeCsrFromApplicationWithHttpInfo(appId, csrId);
    }

    private ResponseEntity<Void> revokeCsrFromApplicationWithHttpInfo(String appId, String csrId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling revokeCsrFromApplication");
        }
        if (csrId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling revokeCsrFromApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("csrId", csrId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs/{csrId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void revokeOAuth2TokenForApplication(String appId, String tokenId) throws RestClientException {
        this.revokeOAuth2TokenForApplicationWithHttpInfo(appId, tokenId);
    }

    private ResponseEntity<Void> revokeOAuth2TokenForApplicationWithHttpInfo(String appId, String tokenId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling revokeOAuth2TokenForApplication");
        }
        if (tokenId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tokenId' when calling revokeOAuth2TokenForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("tokenId", tokenId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/tokens/{tokenId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void revokeOAuth2TokensForApplication(String appId) throws RestClientException {
        this.revokeOAuth2TokensForApplicationWithHttpInfo(appId);
    }

    private ResponseEntity<Void> revokeOAuth2TokensForApplicationWithHttpInfo(String appId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling revokeOAuth2TokensForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/tokens", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void revokeScopeConsentGrant(String appId, String grantId) throws RestClientException {
        this.revokeScopeConsentGrantWithHttpInfo(appId, grantId);
    }

    private ResponseEntity<Void> revokeScopeConsentGrantWithHttpInfo(String appId, String grantId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling revokeScopeConsentGrant");
        }
        if (grantId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'grantId' when calling revokeScopeConsentGrant");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("grantId", grantId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/grants/{grantId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void unassignApplicationFromGroup(String appId, String groupId) throws RestClientException {
        this.unassignApplicationFromGroupWithHttpInfo(appId, groupId);
    }

    private ResponseEntity<Void> unassignApplicationFromGroupWithHttpInfo(String appId, String groupId) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling unassignApplicationFromGroup");
        }
        if (groupId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling unassignApplicationFromGroup");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("groupId", groupId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/groups/{groupId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void unassignUserFromApplication(String appId, String userId, Boolean sendEmail) throws RestClientException {
        this.unassignUserFromApplicationWithHttpInfo(appId, userId, sendEmail);
    }

    private ResponseEntity<Void> unassignUserFromApplicationWithHttpInfo(String appId, String userId, Boolean sendEmail) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling unassignUserFromApplication");
        }
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling unassignUserFromApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "sendEmail", sendEmail));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/users/{userId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public AppUser updateApplicationUser(String appId, String userId, AppUser appUser) throws RestClientException {
        return (AppUser)this.updateApplicationUserWithHttpInfo(appId, userId, appUser).getBody();
    }

    public <T> T updateApplicationUser(Class<?> T, String appId, String userId, AppUser appUser) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.updateApplicationUserWithReturnType(T, appId, userId, appUser).getBody(), T);
    }

    private ResponseEntity<AppUser> updateApplicationUserWithHttpInfo(String appId, String userId, AppUser appUser) throws RestClientException {
        AppUser localVarPostBody = appUser;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateApplicationUser");
        }
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling updateApplicationUser");
        }
        if (appUser == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appUser' when calling updateApplicationUser");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AppUser> localReturnType = new ParameterizedTypeReference<AppUser>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/users/{userId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> updateApplicationUserWithReturnType(Class<?> T, String appId, String userId, AppUser appUser) throws RestClientException {
        AppUser localVarPostBody = appUser;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateApplicationUser");
        }
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling updateApplicationUser");
        }
        if (appUser == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appUser' when calling updateApplicationUser");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/users/{userId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList updateApplicationUserWithPaginationInfo(String appId, String userId, AppUser appUser) throws RestClientException {
        AppUser localVarPostBody = appUser;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateApplicationUser");
        }
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling updateApplicationUser");
        }
        if (appUser == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appUser' when calling updateApplicationUser");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<AppUser> localReturnType = new ParameterizedTypeReference<AppUser>(){};
        ResponseEntity<AppUser> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/users/{userId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<AppUser> pagedList = new PagedList<AppUser>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((AppUser)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public ProvisioningConnection updateDefaultProvisioningConnectionForApplication(String appId, ProvisioningConnectionRequest provisioningConnectionRequest, Boolean activate) throws RestClientException {
        return (ProvisioningConnection)this.updateDefaultProvisioningConnectionForApplicationWithHttpInfo(appId, provisioningConnectionRequest, activate).getBody();
    }

    public <T> T updateDefaultProvisioningConnectionForApplication(Class<?> T, String appId, ProvisioningConnectionRequest provisioningConnectionRequest, Boolean activate) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.updateDefaultProvisioningConnectionForApplicationWithReturnType(T, appId, provisioningConnectionRequest, activate).getBody(), T);
    }

    private ResponseEntity<ProvisioningConnection> updateDefaultProvisioningConnectionForApplicationWithHttpInfo(String appId, ProvisioningConnectionRequest provisioningConnectionRequest, Boolean activate) throws RestClientException {
        ProvisioningConnectionRequest localVarPostBody = provisioningConnectionRequest;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateDefaultProvisioningConnectionForApplication");
        }
        if (provisioningConnectionRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'provisioningConnectionRequest' when calling updateDefaultProvisioningConnectionForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "activate", activate));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ProvisioningConnection> localReturnType = new ParameterizedTypeReference<ProvisioningConnection>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/connections/default", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> updateDefaultProvisioningConnectionForApplicationWithReturnType(Class<?> T, String appId, ProvisioningConnectionRequest provisioningConnectionRequest, Boolean activate) throws RestClientException {
        ProvisioningConnectionRequest localVarPostBody = provisioningConnectionRequest;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateDefaultProvisioningConnectionForApplication");
        }
        if (provisioningConnectionRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'provisioningConnectionRequest' when calling updateDefaultProvisioningConnectionForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "activate", activate));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/connections/default", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList updateDefaultProvisioningConnectionForApplicationWithPaginationInfo(String appId, ProvisioningConnectionRequest provisioningConnectionRequest, Boolean activate) throws RestClientException {
        ProvisioningConnectionRequest localVarPostBody = provisioningConnectionRequest;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateDefaultProvisioningConnectionForApplication");
        }
        if (provisioningConnectionRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'provisioningConnectionRequest' when calling updateDefaultProvisioningConnectionForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "activate", activate));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ProvisioningConnection> localReturnType = new ParameterizedTypeReference<ProvisioningConnection>(){};
        ResponseEntity<ProvisioningConnection> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/connections/default", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<ProvisioningConnection> pagedList = new PagedList<ProvisioningConnection>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((ProvisioningConnection)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public ApplicationFeature updateFeatureForApplication(String appId, String name, CapabilitiesObject capabilitiesObject) throws RestClientException {
        return (ApplicationFeature)this.updateFeatureForApplicationWithHttpInfo(appId, name, capabilitiesObject).getBody();
    }

    public <T> T updateFeatureForApplication(Class<?> T, String appId, String name, CapabilitiesObject capabilitiesObject) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.updateFeatureForApplicationWithReturnType(T, appId, name, capabilitiesObject).getBody(), T);
    }

    private ResponseEntity<ApplicationFeature> updateFeatureForApplicationWithHttpInfo(String appId, String name, CapabilitiesObject capabilitiesObject) throws RestClientException {
        CapabilitiesObject localVarPostBody = capabilitiesObject;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateFeatureForApplication");
        }
        if (name == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'name' when calling updateFeatureForApplication");
        }
        if (capabilitiesObject == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'capabilitiesObject' when calling updateFeatureForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("name", name);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ApplicationFeature> localReturnType = new ParameterizedTypeReference<ApplicationFeature>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/features/{name}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> updateFeatureForApplicationWithReturnType(Class<?> T, String appId, String name, CapabilitiesObject capabilitiesObject) throws RestClientException {
        CapabilitiesObject localVarPostBody = capabilitiesObject;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateFeatureForApplication");
        }
        if (name == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'name' when calling updateFeatureForApplication");
        }
        if (capabilitiesObject == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'capabilitiesObject' when calling updateFeatureForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("name", name);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/features/{name}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList updateFeatureForApplicationWithPaginationInfo(String appId, String name, CapabilitiesObject capabilitiesObject) throws RestClientException {
        CapabilitiesObject localVarPostBody = capabilitiesObject;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateFeatureForApplication");
        }
        if (name == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'name' when calling updateFeatureForApplication");
        }
        if (capabilitiesObject == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'capabilitiesObject' when calling updateFeatureForApplication");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        uriVariables.put("name", name);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<ApplicationFeature> localReturnType = new ParameterizedTypeReference<ApplicationFeature>(){};
        ResponseEntity<ApplicationFeature> responseEntity = this.apiClient.invokeAPI("/api/v1/apps/{appId}/features/{name}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<ApplicationFeature> pagedList = new PagedList<ApplicationFeature>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((ApplicationFeature)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public void uploadApplicationLogo(String appId, File _file) throws RestClientException {
        this.uploadApplicationLogoWithHttpInfo(appId, _file);
    }

    private ResponseEntity<Void> uploadApplicationLogoWithHttpInfo(String appId, File _file) throws RestClientException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling uploadApplicationLogo");
        }
        if (_file == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter '_file' when calling uploadApplicationLogo");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("appId", appId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (_file != null) {
            localVarFormParams.add((Object)"file", (Object)new FileSystemResource(_file));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/apps/{appId}/logo", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
}

