/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.Agent;

@ApiModel(description="An AgentPool is a collection of agents that serve a common purpose. An AgentPool has a unique ID within an org, and contains a collection of agents disjoint to every other AgentPool (i.e. no two AgentPools share an Agent).")
@JsonPropertyOrder(value={"agents", "id", "name", "operationalStatus", "type"})
public class AgentPool {
    public static final String JSON_PROPERTY_AGENTS = "agents";
    private List<Agent> agents = null;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPERATIONAL_STATUS = "operationalStatus";
    private String operationalStatus;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public AgentPool agents(List<Agent> agents) {
        this.agents = agents;
        return this;
    }

    public AgentPool addAgentsItem(Agent agentsItem) {
        if (this.agents == null) {
            this.agents = new ArrayList<Agent>();
        }
        this.agents.add(agentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="agents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Agent> getAgents() {
        return this.agents;
    }

    @JsonProperty(value="agents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAgents(List<Agent> agents) {
        this.agents = agents;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public AgentPool name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public AgentPool operationalStatus(String operationalStatus) {
        this.operationalStatus = operationalStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Operational status of a given agent")
    @JsonProperty(value="operationalStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOperationalStatus() {
        return this.operationalStatus;
    }

    @JsonProperty(value="operationalStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperationalStatus(String operationalStatus) {
        this.operationalStatus = operationalStatus;
    }

    public AgentPool type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Agent types that are being monitored")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentPool agentPool = (AgentPool)o;
        return Objects.equals(this.agents, agentPool.agents) && Objects.equals(this.id, agentPool.id) && Objects.equals(this.name, agentPool.name) && Objects.equals(this.operationalStatus, agentPool.operationalStatus) && Objects.equals(this.type, agentPool.type);
    }

    public int hashCode() {
        return Objects.hash(this.agents, this.id, this.name, this.operationalStatus, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentPool {\n");
        sb.append("    agents: ").append(this.toIndentedString(this.agents)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    operationalStatus: ").append(this.toIndentedString(this.operationalStatus)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

