/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.common.PagedList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.ActivateFactorRequest;
import org.openapitools.client.model.SecurityQuestion;
import org.openapitools.client.model.UserFactor;
import org.openapitools.client.model.VerifyFactorRequest;
import org.openapitools.client.model.VerifyUserFactorResponse;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.openapitools.client.api.UserFactorApi")
public class UserFactorApi {
    private ApiClient apiClient;

    public UserFactorApi() {
        this(new ApiClient());
    }

    @Autowired
    public UserFactorApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UserFactor activateFactor(String userId, String factorId, ActivateFactorRequest body) throws RestClientException {
        return (UserFactor)this.activateFactorWithHttpInfo(userId, factorId, body).getBody();
    }

    public <T> T activateFactor(Class<?> T, String userId, String factorId, ActivateFactorRequest body) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.activateFactorWithReturnType(T, userId, factorId, body).getBody(), T);
    }

    private ResponseEntity<UserFactor> activateFactorWithHttpInfo(String userId, String factorId, ActivateFactorRequest body) throws RestClientException {
        ActivateFactorRequest localVarPostBody = body;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling activateFactor");
        }
        if (factorId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling activateFactor");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("factorId", factorId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<UserFactor> localReturnType = new ParameterizedTypeReference<UserFactor>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}/lifecycle/activate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> activateFactorWithReturnType(Class<?> T, String userId, String factorId, ActivateFactorRequest body) throws RestClientException {
        ActivateFactorRequest localVarPostBody = body;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling activateFactor");
        }
        if (factorId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling activateFactor");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("factorId", factorId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}/lifecycle/activate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList activateFactorWithPaginationInfo(String userId, String factorId, ActivateFactorRequest body) throws RestClientException {
        ActivateFactorRequest localVarPostBody = body;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling activateFactor");
        }
        if (factorId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling activateFactor");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("factorId", factorId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<UserFactor> localReturnType = new ParameterizedTypeReference<UserFactor>(){};
        ResponseEntity<UserFactor> responseEntity = this.apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}/lifecycle/activate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<UserFactor> pagedList = new PagedList<UserFactor>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((UserFactor)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public void deleteFactor(String userId, String factorId, Boolean removeEnrollmentRecovery) throws RestClientException {
        this.deleteFactorWithHttpInfo(userId, factorId, removeEnrollmentRecovery);
    }

    private ResponseEntity<Void> deleteFactorWithHttpInfo(String userId, String factorId, Boolean removeEnrollmentRecovery) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling deleteFactor");
        }
        if (factorId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling deleteFactor");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("factorId", factorId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "removeEnrollmentRecovery", removeEnrollmentRecovery));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public UserFactor enrollFactor(String userId, UserFactor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate) throws RestClientException {
        return (UserFactor)this.enrollFactorWithHttpInfo(userId, body, updatePhone, templateId, tokenLifetimeSeconds, activate).getBody();
    }

    public <T> T enrollFactor(Class<?> T, String userId, UserFactor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.enrollFactorWithReturnType(T, userId, body, updatePhone, templateId, tokenLifetimeSeconds, activate).getBody(), T);
    }

    private ResponseEntity<UserFactor> enrollFactorWithHttpInfo(String userId, UserFactor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate) throws RestClientException {
        UserFactor localVarPostBody = body;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling enrollFactor");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling enrollFactor");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "updatePhone", updatePhone));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "templateId", templateId));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "tokenLifetimeSeconds", tokenLifetimeSeconds));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "activate", activate));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<UserFactor> localReturnType = new ParameterizedTypeReference<UserFactor>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/factors", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> enrollFactorWithReturnType(Class<?> T, String userId, UserFactor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate) throws RestClientException {
        UserFactor localVarPostBody = body;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling enrollFactor");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling enrollFactor");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "updatePhone", updatePhone));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "templateId", templateId));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "tokenLifetimeSeconds", tokenLifetimeSeconds));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "activate", activate));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/factors", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList enrollFactorWithPaginationInfo(String userId, UserFactor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate) throws RestClientException {
        UserFactor localVarPostBody = body;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling enrollFactor");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling enrollFactor");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "updatePhone", updatePhone));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "templateId", templateId));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "tokenLifetimeSeconds", tokenLifetimeSeconds));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "activate", activate));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<UserFactor> localReturnType = new ParameterizedTypeReference<UserFactor>(){};
        ResponseEntity<UserFactor> responseEntity = this.apiClient.invokeAPI("/api/v1/users/{userId}/factors", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<UserFactor> pagedList = new PagedList<UserFactor>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((UserFactor)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public UserFactor getFactor(String userId, String factorId) throws RestClientException {
        return (UserFactor)this.getFactorWithHttpInfo(userId, factorId).getBody();
    }

    private ResponseEntity<UserFactor> getFactorWithHttpInfo(String userId, String factorId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getFactor");
        }
        if (factorId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling getFactor");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("factorId", factorId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<UserFactor> localReturnType = new ParameterizedTypeReference<UserFactor>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getFactorWithPaginationInfo(String userId, String factorId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getFactor");
        }
        if (factorId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling getFactor");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("factorId", factorId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<UserFactor> localReturnType = new ParameterizedTypeReference<UserFactor>(){};
        ResponseEntity<UserFactor> responseEntity = this.apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<UserFactor> pagedList = new PagedList<UserFactor>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((UserFactor)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public VerifyUserFactorResponse getFactorTransactionStatus(String userId, String factorId, String transactionId) throws RestClientException {
        return (VerifyUserFactorResponse)this.getFactorTransactionStatusWithHttpInfo(userId, factorId, transactionId).getBody();
    }

    private ResponseEntity<VerifyUserFactorResponse> getFactorTransactionStatusWithHttpInfo(String userId, String factorId, String transactionId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getFactorTransactionStatus");
        }
        if (factorId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling getFactorTransactionStatus");
        }
        if (transactionId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'transactionId' when calling getFactorTransactionStatus");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("factorId", factorId);
        uriVariables.put("transactionId", transactionId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<VerifyUserFactorResponse> localReturnType = new ParameterizedTypeReference<VerifyUserFactorResponse>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}/transactions/{transactionId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getFactorTransactionStatusWithPaginationInfo(String userId, String factorId, String transactionId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getFactorTransactionStatus");
        }
        if (factorId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling getFactorTransactionStatus");
        }
        if (transactionId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'transactionId' when calling getFactorTransactionStatus");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("factorId", factorId);
        uriVariables.put("transactionId", transactionId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<VerifyUserFactorResponse> localReturnType = new ParameterizedTypeReference<VerifyUserFactorResponse>(){};
        ResponseEntity<VerifyUserFactorResponse> responseEntity = this.apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}/transactions/{transactionId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<VerifyUserFactorResponse> pagedList = new PagedList<VerifyUserFactorResponse>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((VerifyUserFactorResponse)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public List<UserFactor> listFactors(String userId) throws RestClientException {
        return (List)this.listFactorsWithHttpInfo(userId).getBody();
    }

    private ResponseEntity<List<UserFactor>> listFactorsWithHttpInfo(String userId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listFactors");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<List<UserFactor>> localReturnType = new ParameterizedTypeReference<List<UserFactor>>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/factors", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listFactorsWithPaginationInfo(String userId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listFactors");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<List<UserFactor>> localReturnType = new ParameterizedTypeReference<List<UserFactor>>(){};
        ResponseEntity<List<UserFactor>> responseEntity = this.apiClient.invokeAPI("/api/v1/users/{userId}/factors", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public List<UserFactor> listSupportedFactors(String userId) throws RestClientException {
        return (List)this.listSupportedFactorsWithHttpInfo(userId).getBody();
    }

    private ResponseEntity<List<UserFactor>> listSupportedFactorsWithHttpInfo(String userId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listSupportedFactors");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<List<UserFactor>> localReturnType = new ParameterizedTypeReference<List<UserFactor>>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/factors/catalog", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listSupportedFactorsWithPaginationInfo(String userId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listSupportedFactors");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<List<UserFactor>> localReturnType = new ParameterizedTypeReference<List<UserFactor>>(){};
        ResponseEntity<List<UserFactor>> responseEntity = this.apiClient.invokeAPI("/api/v1/users/{userId}/factors/catalog", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public List<SecurityQuestion> listSupportedSecurityQuestions(String userId) throws RestClientException {
        return (List)this.listSupportedSecurityQuestionsWithHttpInfo(userId).getBody();
    }

    private ResponseEntity<List<SecurityQuestion>> listSupportedSecurityQuestionsWithHttpInfo(String userId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listSupportedSecurityQuestions");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token"};
        ParameterizedTypeReference<List<SecurityQuestion>> localReturnType = new ParameterizedTypeReference<List<SecurityQuestion>>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/factors/questions", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listSupportedSecurityQuestionsWithPaginationInfo(String userId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listSupportedSecurityQuestions");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token"};
        ParameterizedTypeReference<List<SecurityQuestion>> localReturnType = new ParameterizedTypeReference<List<SecurityQuestion>>(){};
        ResponseEntity<List<SecurityQuestion>> responseEntity = this.apiClient.invokeAPI("/api/v1/users/{userId}/factors/questions", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public VerifyUserFactorResponse verifyFactor(String userId, String factorId, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage, VerifyFactorRequest body) throws RestClientException {
        return (VerifyUserFactorResponse)this.verifyFactorWithHttpInfo(userId, factorId, templateId, tokenLifetimeSeconds, xForwardedFor, userAgent, acceptLanguage, body).getBody();
    }

    public <T> T verifyFactor(Class<?> T, String userId, String factorId, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage, VerifyFactorRequest body) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.verifyFactorWithReturnType(T, userId, factorId, templateId, tokenLifetimeSeconds, xForwardedFor, userAgent, acceptLanguage, body).getBody(), T);
    }

    private ResponseEntity<VerifyUserFactorResponse> verifyFactorWithHttpInfo(String userId, String factorId, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage, VerifyFactorRequest body) throws RestClientException {
        VerifyFactorRequest localVarPostBody = body;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling verifyFactor");
        }
        if (factorId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling verifyFactor");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("factorId", factorId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "templateId", templateId));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "tokenLifetimeSeconds", tokenLifetimeSeconds));
        if (xForwardedFor != null) {
            localVarHeaderParams.add("X-Forwarded-For", this.apiClient.parameterToString(xForwardedFor));
        }
        if (userAgent != null) {
            localVarHeaderParams.add("User-Agent", this.apiClient.parameterToString(userAgent));
        }
        if (acceptLanguage != null) {
            localVarHeaderParams.add("Accept-Language", this.apiClient.parameterToString(acceptLanguage));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<VerifyUserFactorResponse> localReturnType = new ParameterizedTypeReference<VerifyUserFactorResponse>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}/verify", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> verifyFactorWithReturnType(Class<?> T, String userId, String factorId, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage, VerifyFactorRequest body) throws RestClientException {
        VerifyFactorRequest localVarPostBody = body;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling verifyFactor");
        }
        if (factorId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling verifyFactor");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("factorId", factorId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "templateId", templateId));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "tokenLifetimeSeconds", tokenLifetimeSeconds));
        if (xForwardedFor != null) {
            localVarHeaderParams.add("X-Forwarded-For", this.apiClient.parameterToString(xForwardedFor));
        }
        if (userAgent != null) {
            localVarHeaderParams.add("User-Agent", this.apiClient.parameterToString(userAgent));
        }
        if (acceptLanguage != null) {
            localVarHeaderParams.add("Accept-Language", this.apiClient.parameterToString(acceptLanguage));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}/verify", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList verifyFactorWithPaginationInfo(String userId, String factorId, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage, VerifyFactorRequest body) throws RestClientException {
        VerifyFactorRequest localVarPostBody = body;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling verifyFactor");
        }
        if (factorId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling verifyFactor");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("factorId", factorId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "templateId", templateId));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "tokenLifetimeSeconds", tokenLifetimeSeconds));
        if (xForwardedFor != null) {
            localVarHeaderParams.add("X-Forwarded-For", this.apiClient.parameterToString(xForwardedFor));
        }
        if (userAgent != null) {
            localVarHeaderParams.add("User-Agent", this.apiClient.parameterToString(userAgent));
        }
        if (acceptLanguage != null) {
            localVarHeaderParams.add("Accept-Language", this.apiClient.parameterToString(acceptLanguage));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<VerifyUserFactorResponse> localReturnType = new ParameterizedTypeReference<VerifyUserFactorResponse>(){};
        ResponseEntity<VerifyUserFactorResponse> responseEntity = this.apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}/verify", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<VerifyUserFactorResponse> pagedList = new PagedList<VerifyUserFactorResponse>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((VerifyUserFactorResponse)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
}

