/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.common.PagedList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.Subscription;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.openapitools.client.api.SubscriptionApi")
public class SubscriptionApi {
    private ApiClient apiClient;

    public SubscriptionApi() {
        this(new ApiClient());
    }

    @Autowired
    public SubscriptionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Subscription getRoleSubscriptionByNotificationType(String roleTypeOrRoleId, String notificationType) throws RestClientException {
        return (Subscription)this.getRoleSubscriptionByNotificationTypeWithHttpInfo(roleTypeOrRoleId, notificationType).getBody();
    }

    private ResponseEntity<Subscription> getRoleSubscriptionByNotificationTypeWithHttpInfo(String roleTypeOrRoleId, String notificationType) throws RestClientException {
        Object localVarPostBody = null;
        if (roleTypeOrRoleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleTypeOrRoleId' when calling getRoleSubscriptionByNotificationType");
        }
        if (notificationType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'notificationType' when calling getRoleSubscriptionByNotificationType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("roleTypeOrRoleId", roleTypeOrRoleId);
        uriVariables.put("notificationType", notificationType);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<Subscription> localReturnType = new ParameterizedTypeReference<Subscription>(){};
        return this.apiClient.invokeAPI("/api/v1/roles/{roleTypeOrRoleId}/subscriptions/{notificationType}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getRoleSubscriptionByNotificationTypeWithPaginationInfo(String roleTypeOrRoleId, String notificationType) throws RestClientException {
        Object localVarPostBody = null;
        if (roleTypeOrRoleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleTypeOrRoleId' when calling getRoleSubscriptionByNotificationType");
        }
        if (notificationType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'notificationType' when calling getRoleSubscriptionByNotificationType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("roleTypeOrRoleId", roleTypeOrRoleId);
        uriVariables.put("notificationType", notificationType);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<Subscription> localReturnType = new ParameterizedTypeReference<Subscription>(){};
        ResponseEntity<Subscription> responseEntity = this.apiClient.invokeAPI("/api/v1/roles/{roleTypeOrRoleId}/subscriptions/{notificationType}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<Subscription> pagedList = new PagedList<Subscription>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((Subscription)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public Subscription getUserSubscriptionByNotificationType(String userId, String notificationType) throws RestClientException {
        return (Subscription)this.getUserSubscriptionByNotificationTypeWithHttpInfo(userId, notificationType).getBody();
    }

    private ResponseEntity<Subscription> getUserSubscriptionByNotificationTypeWithHttpInfo(String userId, String notificationType) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getUserSubscriptionByNotificationType");
        }
        if (notificationType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'notificationType' when calling getUserSubscriptionByNotificationType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("notificationType", notificationType);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<Subscription> localReturnType = new ParameterizedTypeReference<Subscription>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/subscriptions/{notificationType}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getUserSubscriptionByNotificationTypeWithPaginationInfo(String userId, String notificationType) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getUserSubscriptionByNotificationType");
        }
        if (notificationType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'notificationType' when calling getUserSubscriptionByNotificationType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("notificationType", notificationType);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<Subscription> localReturnType = new ParameterizedTypeReference<Subscription>(){};
        ResponseEntity<Subscription> responseEntity = this.apiClient.invokeAPI("/api/v1/users/{userId}/subscriptions/{notificationType}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<Subscription> pagedList = new PagedList<Subscription>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((Subscription)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public List<Subscription> listRoleSubscriptions(String roleTypeOrRoleId) throws RestClientException {
        return (List)this.listRoleSubscriptionsWithHttpInfo(roleTypeOrRoleId).getBody();
    }

    private ResponseEntity<List<Subscription>> listRoleSubscriptionsWithHttpInfo(String roleTypeOrRoleId) throws RestClientException {
        Object localVarPostBody = null;
        if (roleTypeOrRoleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleTypeOrRoleId' when calling listRoleSubscriptions");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("roleTypeOrRoleId", roleTypeOrRoleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<List<Subscription>> localReturnType = new ParameterizedTypeReference<List<Subscription>>(){};
        return this.apiClient.invokeAPI("/api/v1/roles/{roleTypeOrRoleId}/subscriptions", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listRoleSubscriptionsWithPaginationInfo(String roleTypeOrRoleId) throws RestClientException {
        Object localVarPostBody = null;
        if (roleTypeOrRoleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleTypeOrRoleId' when calling listRoleSubscriptions");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("roleTypeOrRoleId", roleTypeOrRoleId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<List<Subscription>> localReturnType = new ParameterizedTypeReference<List<Subscription>>(){};
        ResponseEntity<List<Subscription>> responseEntity = this.apiClient.invokeAPI("/api/v1/roles/{roleTypeOrRoleId}/subscriptions", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public List<Subscription> listUserSubscriptions(String userId) throws RestClientException {
        return (List)this.listUserSubscriptionsWithHttpInfo(userId).getBody();
    }

    private ResponseEntity<List<Subscription>> listUserSubscriptionsWithHttpInfo(String userId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listUserSubscriptions");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<List<Subscription>> localReturnType = new ParameterizedTypeReference<List<Subscription>>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/subscriptions", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listUserSubscriptionsWithPaginationInfo(String userId) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listUserSubscriptions");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<List<Subscription>> localReturnType = new ParameterizedTypeReference<List<Subscription>>(){};
        ResponseEntity<List<Subscription>> responseEntity = this.apiClient.invokeAPI("/api/v1/users/{userId}/subscriptions", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public void subscribeRoleSubscriptionByNotificationType(String roleTypeOrRoleId, String notificationType) throws RestClientException {
        this.subscribeRoleSubscriptionByNotificationTypeWithHttpInfo(roleTypeOrRoleId, notificationType);
    }

    private ResponseEntity<Void> subscribeRoleSubscriptionByNotificationTypeWithHttpInfo(String roleTypeOrRoleId, String notificationType) throws RestClientException {
        Object localVarPostBody = null;
        if (roleTypeOrRoleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleTypeOrRoleId' when calling subscribeRoleSubscriptionByNotificationType");
        }
        if (notificationType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'notificationType' when calling subscribeRoleSubscriptionByNotificationType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("roleTypeOrRoleId", roleTypeOrRoleId);
        uriVariables.put("notificationType", notificationType);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/roles/{roleTypeOrRoleId}/subscriptions/{notificationType}/subscribe", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void subscribeUserSubscriptionByNotificationType(String userId, String notificationType) throws RestClientException {
        this.subscribeUserSubscriptionByNotificationTypeWithHttpInfo(userId, notificationType);
    }

    private ResponseEntity<Void> subscribeUserSubscriptionByNotificationTypeWithHttpInfo(String userId, String notificationType) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling subscribeUserSubscriptionByNotificationType");
        }
        if (notificationType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'notificationType' when calling subscribeUserSubscriptionByNotificationType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("notificationType", notificationType);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/subscriptions/{notificationType}/subscribe", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void unsubscribeRoleSubscriptionByNotificationType(String roleTypeOrRoleId, String notificationType) throws RestClientException {
        this.unsubscribeRoleSubscriptionByNotificationTypeWithHttpInfo(roleTypeOrRoleId, notificationType);
    }

    private ResponseEntity<Void> unsubscribeRoleSubscriptionByNotificationTypeWithHttpInfo(String roleTypeOrRoleId, String notificationType) throws RestClientException {
        Object localVarPostBody = null;
        if (roleTypeOrRoleId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleTypeOrRoleId' when calling unsubscribeRoleSubscriptionByNotificationType");
        }
        if (notificationType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'notificationType' when calling unsubscribeRoleSubscriptionByNotificationType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("roleTypeOrRoleId", roleTypeOrRoleId);
        uriVariables.put("notificationType", notificationType);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/roles/{roleTypeOrRoleId}/subscriptions/{notificationType}/unsubscribe", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void unsubscribeUserSubscriptionByNotificationType(String userId, String notificationType) throws RestClientException {
        this.unsubscribeUserSubscriptionByNotificationTypeWithHttpInfo(userId, notificationType);
    }

    private ResponseEntity<Void> unsubscribeUserSubscriptionByNotificationTypeWithHttpInfo(String userId, String notificationType) throws RestClientException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling unsubscribeUserSubscriptionByNotificationType");
        }
        if (notificationType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'notificationType' when calling unsubscribeUserSubscriptionByNotificationType");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("userId", userId);
        uriVariables.put("notificationType", notificationType);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/users/{userId}/subscriptions/{notificationType}/unsubscribe", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
}

