/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.lang;

import com.okta.sdk.lang.Assert;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class Duration
implements Comparable<Duration>,
Cloneable {
    private final long value;
    private final TimeUnit timeUnit;

    public Duration(long value, TimeUnit timeUnit) {
        Assert.notNull((Object)timeUnit, "TimeUnit argument cannot be null.");
        this.value = value;
        this.timeUnit = timeUnit;
    }

    public long getValue() {
        return this.value;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public int compareTo(Duration duration) {
        long converted = this.timeUnit.convert(duration.getValue(), duration.getTimeUnit());
        return Long.compare(this.value, converted);
    }

    public boolean isLessThan(Duration duration) {
        return this.compareTo(duration) < 0;
    }

    public boolean isGreaterThan(Duration duration) {
        return this.compareTo(duration) > 0;
    }

    public boolean isEquivalentTo(Duration duration) {
        return this.compareTo(duration) == 0;
    }

    public String toString() {
        return this.value + " " + this.timeUnit.name().toLowerCase(Locale.ENGLISH);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration duration = (Duration)o;
        return this.value == duration.value && this.timeUnit == duration.timeUnit;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 31 * result + (this.timeUnit != null ? this.timeUnit.hashCode() : 0);
        return result;
    }

    public Duration clone() {
        try {
            return (Duration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Unable to clone Object direct subclass! " + e.getMessage());
        }
    }
}

