/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource;

import com.okta.sdk.error.Error;
import com.okta.sdk.error.ErrorCause;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.lang.Strings;
import java.util.List;

public class ResourceException
extends RuntimeException
implements Error {
    private final Error error;

    private static String buildExceptionMessage(Error error) {
        Assert.notNull(error, "Error argument cannot be null.");
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP ").append(error.getStatus()).append(", Okta ").append(error.getCode()).append(" (").append(error.getMessage()).append(")");
        String errorId = error.getId();
        if (Strings.hasText(errorId)) {
            sb.append(", ErrorId ").append(errorId);
        }
        return sb.toString();
    }

    public ResourceException(Error error) {
        super(ResourceException.buildExceptionMessage(error));
        this.error = error;
    }

    @Override
    public int getStatus() {
        return this.error.getStatus();
    }

    @Override
    public String getCode() {
        return this.error.getCode();
    }

    @Override
    public String getId() {
        return this.error.getId();
    }

    @Override
    public List<ErrorCause> getCauses() {
        return this.error.getCauses();
    }

    public Error getOktaError() {
        return this.error;
    }
}

