/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt.impl.jjwt;

import com.okta.commons.lang.Assert;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.IncorrectClaimException;
import io.jsonwebtoken.Jws;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

@FunctionalInterface
interface ClaimsValidator {
    public void validateClaims(Jws<Claims> var1);

    public static ClaimsValidator compositeClaimsValidator(ClaimsValidator ... claimsValidators) {
        return new CompositeClaimsValidator(Arrays.stream(claimsValidators).collect(Collectors.toSet()));
    }

    public static final class ContainsAudienceClaimsValidator
    implements ClaimsValidator {
        private final String expectedAudience;

        ContainsAudienceClaimsValidator(String expectedAudience) {
            Assert.notNull((Object)expectedAudience, (String)"expectedAudience cannot be null");
            this.expectedAudience = expectedAudience;
        }

        @Override
        public void validateClaims(Jws<Claims> jws) {
            Object actual = ((Claims)jws.getBody()).get((Object)"aud");
            if (!(actual instanceof Collection && new HashSet((Collection)actual).contains(this.expectedAudience) || actual instanceof String && actual.equals(this.expectedAudience))) {
                throw new IncorrectClaimException(jws.getHeader(), (Claims)jws.getBody(), "Claim `aud` was invalid, it did not contain the expected value of: " + this.expectedAudience);
            }
        }
    }

    public static final class CompositeClaimsValidator
    implements ClaimsValidator {
        private final Set<ClaimsValidator> claimsValidators = new HashSet<ClaimsValidator>();

        CompositeClaimsValidator(Set<ClaimsValidator> claimsValidators) {
            this.claimsValidators.addAll(claimsValidators);
        }

        @Override
        public void validateClaims(Jws<Claims> jws) {
            this.claimsValidators.forEach(claimsValidator -> claimsValidator.validateClaims(jws));
        }
    }
}

