/*
 * Decompiled with CFR 0.152.
 */
package com.okta.idx.sdk.api.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.okta.idx.sdk.api.client.IDXClient;
import com.okta.idx.sdk.api.exception.ProcessingException;
import com.okta.idx.sdk.api.model.App;
import com.okta.idx.sdk.api.model.AuthenticatorEnrollments;
import com.okta.idx.sdk.api.model.Authenticators;
import com.okta.idx.sdk.api.model.Cancel;
import com.okta.idx.sdk.api.model.CurrentAuthenticatorEnrollment;
import com.okta.idx.sdk.api.model.Messages;
import com.okta.idx.sdk.api.model.Remediation;
import com.okta.idx.sdk.api.model.SuccessResponse;
import com.okta.idx.sdk.api.model.User;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class IDXResponse {
    private static final ObjectMapper objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private String stateHandle;
    private String version;
    private String expiresAt;
    private String intent;
    private Remediation remediation;
    private Messages messages;
    private AuthenticatorEnrollments authenticatorEnrollments;
    private CurrentAuthenticatorEnrollment currentAuthenticatorEnrollment;
    private CurrentAuthenticatorEnrollment currentAuthenticator;
    private Authenticators authenticators;
    private User user;
    private App app;
    private SuccessResponse successWithInteractionCode;
    private Cancel cancel;

    public Remediation remediation() {
        return this.remediation;
    }

    public IDXResponse cancel(IDXClient client) throws ProcessingException {
        return client.cancel(this.stateHandle);
    }

    public SuccessResponse successWithInteractionCode() {
        return this.successWithInteractionCode;
    }

    public boolean isLoginSuccessful() {
        return this.successWithInteractionCode != null;
    }

    public String raw() throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)this);
    }

    public String getStateHandle() {
        return this.stateHandle;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public AuthenticatorEnrollments getAuthenticatorEnrollments() {
        return this.authenticatorEnrollments;
    }

    public User getUser() {
        return this.user;
    }

    public Authenticators getAuthenticators() {
        return this.authenticators;
    }

    public CurrentAuthenticatorEnrollment getCurrentAuthenticatorEnrollment() {
        return this.currentAuthenticatorEnrollment;
    }

    public CurrentAuthenticatorEnrollment getCurrentAuthenticator() {
        return this.currentAuthenticator;
    }

    public SuccessResponse getSuccessWithInteractionCode() {
        return this.successWithInteractionCode;
    }
}

