/*
 * Decompiled with CFR 0.152.
 */
package com.okta.idx.sdk.api.model;

import com.okta.commons.lang.Assert;
import java.util.LinkedHashMap;
import java.util.Map;

public class RequestContext {
    public static final String X_DEVICE_TOKEN = "X-Device-Token";
    public static final String X_OKTA_USER_AGENT_EXTENDED = "X-Okta-User-Agent-Extended";
    public static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private final Map<String, String> headers = new LinkedHashMap<String, String>();

    public RequestContext setUserAgent(String value) {
        Assert.hasText((String)value, (String)"X-Okta-User-Agent-Extended cannot be empty");
        this.headers.put(X_OKTA_USER_AGENT_EXTENDED, value);
        return this;
    }

    public RequestContext setDeviceToken(String value) {
        Assert.hasText((String)value, (String)"X-Device-Token cannot be empty");
        this.headers.put(X_DEVICE_TOKEN, value);
        return this;
    }

    public RequestContext setIpAddress(String value) {
        Assert.hasText((String)value, (String)"X-Forwarded-For cannot be empty");
        this.headers.put(X_FORWARDED_FOR, value);
        return this;
    }

    public Map<String, String> getAllHeaders() {
        return this.headers;
    }

    public String getUserAgent() {
        return this.headers.get(X_OKTA_USER_AGENT_EXTENDED);
    }

    public String getDeviceToken() {
        return this.headers.get(X_DEVICE_TOKEN);
    }

    public String getIpAddress() {
        return this.headers.get(X_FORWARDED_FOR);
    }
}

