/*
 * Decompiled with CFR 0.152.
 */
package com.okta.idx.sdk.api.client;

import com.okta.commons.http.Response;
import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Strings;
import com.okta.idx.sdk.api.client.AuthenticationTransaction;
import com.okta.idx.sdk.api.client.Authenticator;
import com.okta.idx.sdk.api.client.Clients;
import com.okta.idx.sdk.api.client.IDXClient;
import com.okta.idx.sdk.api.client.ProceedContext;
import com.okta.idx.sdk.api.client.WrapperUtil;
import com.okta.idx.sdk.api.exception.ProcessingException;
import com.okta.idx.sdk.api.model.AuthenticationOptions;
import com.okta.idx.sdk.api.model.AuthenticationStatus;
import com.okta.idx.sdk.api.model.AuthenticatorEnrollment;
import com.okta.idx.sdk.api.model.AuthenticatorEnrollments;
import com.okta.idx.sdk.api.model.Credentials;
import com.okta.idx.sdk.api.model.EmailTokenType;
import com.okta.idx.sdk.api.model.FormValue;
import com.okta.idx.sdk.api.model.IDXClientContext;
import com.okta.idx.sdk.api.model.PollInfo;
import com.okta.idx.sdk.api.model.Recover;
import com.okta.idx.sdk.api.model.RemediationOption;
import com.okta.idx.sdk.api.model.RequestContext;
import com.okta.idx.sdk.api.model.TokenType;
import com.okta.idx.sdk.api.model.UserProfile;
import com.okta.idx.sdk.api.model.VerifyAuthenticatorAnswer;
import com.okta.idx.sdk.api.model.VerifyAuthenticatorOptions;
import com.okta.idx.sdk.api.model.VerifyChannelDataOptions;
import com.okta.idx.sdk.api.request.AnswerChallengeRequest;
import com.okta.idx.sdk.api.request.AnswerChallengeRequestBuilder;
import com.okta.idx.sdk.api.request.ChallengeRequest;
import com.okta.idx.sdk.api.request.ChallengeRequestBuilder;
import com.okta.idx.sdk.api.request.EnrollRequest;
import com.okta.idx.sdk.api.request.EnrollRequestBuilder;
import com.okta.idx.sdk.api.request.EnrollUserProfileUpdateRequest;
import com.okta.idx.sdk.api.request.EnrollUserProfileUpdateRequestBuilder;
import com.okta.idx.sdk.api.request.IdentifyRequest;
import com.okta.idx.sdk.api.request.IdentifyRequestBuilder;
import com.okta.idx.sdk.api.request.PollRequest;
import com.okta.idx.sdk.api.request.PollRequestBuilder;
import com.okta.idx.sdk.api.request.RecoverRequest;
import com.okta.idx.sdk.api.request.RecoverRequestBuilder;
import com.okta.idx.sdk.api.request.SkipAuthenticatorEnrollmentRequest;
import com.okta.idx.sdk.api.request.SkipAuthenticatorEnrollmentRequestBuilder;
import com.okta.idx.sdk.api.request.WebAuthnRequest;
import com.okta.idx.sdk.api.response.AuthenticationResponse;
import com.okta.idx.sdk.api.response.ErrorResponse;
import com.okta.idx.sdk.api.response.IDXResponse;
import com.okta.idx.sdk.api.response.TokenResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDXAuthenticationWrapper {
    private static final Logger logger = LoggerFactory.getLogger(IDXAuthenticationWrapper.class);
    private final IDXClient client;

    public IDXAuthenticationWrapper() {
        this.client = Clients.builder().build();
    }

    public IDXAuthenticationWrapper(String issuer, String clientId, String clientSecret, Set<String> scopes, String redirectUri) {
        this.client = Clients.builder().setIssuer(issuer).setClientId(clientId).setClientSecret(clientSecret).setScopes(scopes).setRedirectUri(redirectUri).build();
    }

    public AuthenticationResponse authenticate(AuthenticationOptions authenticationOptions, ProceedContext proceedContext) {
        try {
            boolean isIdentifyInOneStep = proceedContext.isIdentifyInOneStep();
            AuthenticationTransaction identifyTransaction = AuthenticationTransaction.proceed(this.client, proceedContext, () -> {
                IdentifyRequest identifyRequest;
                if (isIdentifyInOneStep) {
                    Credentials credentials = new Credentials();
                    credentials.setPasscode(authenticationOptions.getPassword());
                    identifyRequest = IdentifyRequestBuilder.builder().withIdentifier(authenticationOptions.getUsername()).withCredentials(credentials).withStateHandle(proceedContext.getStateHandle()).build();
                } else {
                    identifyRequest = IdentifyRequestBuilder.builder().withIdentifier(authenticationOptions.getUsername()).withStateHandle(proceedContext.getStateHandle()).build();
                }
                return this.client.identify(identifyRequest, proceedContext.getHref());
            });
            AuthenticationResponse identifyResponse = identifyTransaction.asAuthenticationResponse();
            if (isIdentifyInOneStep || identifyResponse.getErrors() != null && !identifyResponse.getErrors().isEmpty()) {
                return identifyResponse;
            }
            if (identifyResponse.getAuthenticators() != null && identifyResponse.getAuthenticators().size() > 1) {
                return identifyResponse;
            }
            AuthenticationTransaction passwordTransaction = this.selectPasswordOrEmailAuthenticatorIfNeeded(identifyTransaction);
            if (Strings.isEmpty((Object)authenticationOptions.getPassword())) {
                return passwordTransaction.asAuthenticationResponse(AuthenticationStatus.AWAITING_AUTHENTICATOR_VERIFICATION);
            }
            AuthenticationTransaction answerTransaction = passwordTransaction.proceed(() -> {
                Credentials credentials = new Credentials();
                credentials.setPasscode(authenticationOptions.getPassword());
                AnswerChallengeRequest passwordAuthenticatorAnswerChallengeRequest = AnswerChallengeRequestBuilder.builder().withStateHandle(passwordTransaction.getStateHandle()).withCredentials(credentials).build();
                return passwordTransaction.getRemediationOption("challenge-authenticator").proceed(this.client, passwordAuthenticatorAnswerChallengeRequest);
            });
            return answerTransaction.asAuthenticationResponse();
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse recoverPassword(String username, ProceedContext proceedContext) {
        try {
            boolean isIdentifyInOneStep = proceedContext.isIdentifyInOneStep();
            if (isIdentifyInOneStep) {
                AuthenticationTransaction recoverTransaction = AuthenticationTransaction.proceed(this.client, proceedContext, () -> {
                    RecoverRequest recoverRequest = RecoverRequestBuilder.builder().withStateHandle(WrapperUtil.getStateHandle(proceedContext.getIdxResponse().getCurrentAuthenticator().value().getRecover().formValues())).build();
                    return this.client.recover(recoverRequest, null);
                });
                RemediationOption remediationOption = recoverTransaction.getRemediationOption("identify-recovery");
                IdentifyRequest identifyRequest = IdentifyRequestBuilder.builder().withIdentifier(username).withStateHandle(WrapperUtil.getStateHandle(remediationOption.form())).build();
                return recoverTransaction.proceed(() -> remediationOption.proceed(this.client, identifyRequest)).asAuthenticationResponse(AuthenticationStatus.AWAITING_AUTHENTICATOR_SELECTION);
            }
            AuthenticationTransaction identifyTransaction = AuthenticationTransaction.proceed(this.client, proceedContext, () -> {
                IdentifyRequest identifyRequest = IdentifyRequestBuilder.builder().withIdentifier(username).withStateHandle(proceedContext.getStateHandle()).build();
                return this.client.identify(identifyRequest, proceedContext.getHref());
            });
            IDXResponse identifyResponse = identifyTransaction.getResponse();
            if (identifyResponse.getMessages() != null) {
                return identifyTransaction.asAuthenticationResponse(AuthenticationStatus.AWAITING_USER_EMAIL_ACTIVATION);
            }
            if (identifyResponse.getCurrentAuthenticatorEnrollment() == null) {
                identifyTransaction = this.selectPasswordOrEmailAuthenticatorIfNeeded(identifyTransaction);
            }
            Recover recover = identifyTransaction.getResponse().getCurrentAuthenticatorEnrollment().value().getRecover();
            AuthenticationTransaction finalIdentifyTransaction = identifyTransaction;
            AuthenticationTransaction recoverTransaction = identifyTransaction.proceed(() -> {
                RecoverRequest recoverRequest = RecoverRequestBuilder.builder().withStateHandle(finalIdentifyTransaction.asAuthenticationResponse().getProceedContext().getStateHandle()).build();
                return recover.proceed(this.client, recoverRequest);
            });
            return recoverTransaction.asAuthenticationResponse(AuthenticationStatus.AWAITING_AUTHENTICATOR_SELECTION);
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse register(ProceedContext proceedContext, UserProfile userProfile, Credentials credentials) {
        try {
            AuthenticationTransaction enrollTransaction = AuthenticationTransaction.proceed(this.client, proceedContext, () -> {
                EnrollUserProfileUpdateRequest enrollUserProfileUpdateRequest = EnrollUserProfileUpdateRequestBuilder.builder().withUserProfile(userProfile).withCredentials(credentials).withStateHandle(proceedContext.getStateHandle()).build();
                return this.client.enrollUpdateUserProfile(enrollUserProfileUpdateRequest, proceedContext.getHref());
            });
            enrollTransaction.getRemediationOption("select-authenticator-enroll");
            return enrollTransaction.asAuthenticationResponse(AuthenticationStatus.AWAITING_AUTHENTICATOR_SELECTION);
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse selectAuthenticator(ProceedContext proceedContext, Authenticator authenticator) {
        try {
            return AuthenticationTransaction.proceed(this.client, proceedContext, () -> {
                com.okta.idx.sdk.api.model.Authenticator authenticatorRequest = new com.okta.idx.sdk.api.model.Authenticator();
                authenticatorRequest.setId(authenticator.getId());
                authenticatorRequest.setMethodType(authenticator.getType());
                if (authenticator.hasNestedFactors() && authenticator.getFactors().size() == 1) {
                    Authenticator.Factor factor = authenticator.getFactors().get(0);
                    authenticatorRequest.setMethodType(factor.getMethod());
                    authenticatorRequest.setEnrollmentId(factor.getEnrollmentId());
                }
                ChallengeRequest request = ChallengeRequestBuilder.builder().withStateHandle(proceedContext.getStateHandle()).withAuthenticator(authenticatorRequest).build();
                return this.client.challenge(request, proceedContext.getHref());
            }).asAuthenticationResponse();
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse selectFactor(ProceedContext proceedContext, Authenticator.Factor factor) {
        try {
            return AuthenticationTransaction.proceed(this.client, proceedContext, () -> {
                com.okta.idx.sdk.api.model.Authenticator authenticator = new com.okta.idx.sdk.api.model.Authenticator();
                authenticator.setId(factor.getId());
                authenticator.setEnrollmentId(factor.getEnrollmentId());
                authenticator.setMethodType(factor.getMethod());
                if (factor.getChannel() != null) {
                    authenticator.setChannel(factor.getChannel());
                    authenticator.setMethodType(null);
                }
                ChallengeRequest request = ChallengeRequestBuilder.builder().withStateHandle(proceedContext.getStateHandle()).withAuthenticator(authenticator).build();
                return this.client.challenge(request, proceedContext.getHref());
            }).asAuthenticationResponse();
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse enrollAuthenticator(ProceedContext proceedContext, String authenticatorId) {
        try {
            AuthenticationResponse authenticationResponse = AuthenticationTransaction.proceed(this.client, proceedContext, () -> {
                com.okta.idx.sdk.api.model.Authenticator authenticator = new com.okta.idx.sdk.api.model.Authenticator();
                authenticator.setId(authenticatorId);
                EnrollRequest enrollRequest = EnrollRequestBuilder.builder().withAuthenticator(authenticator).withStateHandle(proceedContext.getStateHandle()).build();
                return this.client.enroll(enrollRequest, proceedContext.getHref());
            }).asAuthenticationResponse();
            if (authenticationResponse.getWebAuthnParams() != null) {
                AuthenticatorEnrollments authenticatorEnrollments = authenticationResponse.getAuthenticatorEnrollments();
                Optional<AuthenticatorEnrollment> authenticatorEnrollmentOptional = authenticatorEnrollments.stream().filter(x -> "security_key".equals(x.getType())).findAny();
                authenticatorEnrollmentOptional.ifPresent(authenticatorEnrollment -> authenticationResponse.getWebAuthnParams().setWebauthnCredentialId(authenticatorEnrollment.getCredentialId()));
            }
            return authenticationResponse;
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse verifyAuthenticator(ProceedContext proceedContext, VerifyAuthenticatorOptions verifyAuthenticatorOptions) {
        try {
            Credentials credentials = new Credentials();
            credentials.setPasscode(verifyAuthenticatorOptions.getCode().toCharArray());
            AnswerChallengeRequest challengeAuthenticatorRequest = AnswerChallengeRequestBuilder.builder().withStateHandle(proceedContext.getStateHandle()).withCredentials(credentials).build();
            return AuthenticationTransaction.proceed(this.client, proceedContext, () -> this.client.answerChallenge(challengeAuthenticatorRequest, proceedContext.getHref())).asAuthenticationResponse(AuthenticationStatus.AWAITING_PASSWORD_RESET);
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse verifyAuthenticator(ProceedContext proceedContext, VerifyAuthenticatorAnswer verifyAuthenticatorAnswer) {
        try {
            Credentials credentials = new Credentials();
            credentials.setQuestion(verifyAuthenticatorAnswer.getQuestion());
            credentials.setQuestionKey(verifyAuthenticatorAnswer.getQuestionKey());
            credentials.setAnswer(verifyAuthenticatorAnswer.getAnswer().toCharArray());
            AnswerChallengeRequest challengeAuthenticatorRequest = AnswerChallengeRequestBuilder.builder().withStateHandle(proceedContext.getStateHandle()).withCredentials(credentials).build();
            return AuthenticationTransaction.proceed(this.client, proceedContext, () -> this.client.answerChallenge(challengeAuthenticatorRequest, proceedContext.getHref())).asAuthenticationResponse(AuthenticationStatus.AWAITING_PASSWORD_RESET);
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse verifyAuthenticator(ProceedContext proceedContext, VerifyChannelDataOptions verifyChannelDataOptions) {
        try {
            AnswerChallengeRequestBuilder builder = AnswerChallengeRequestBuilder.builder().withStateHandle(proceedContext.getStateHandle());
            if ("phoneNumber".equals(verifyChannelDataOptions.getChannelName())) {
                builder.withPhoneNumber(verifyChannelDataOptions.value());
            }
            if ("email".equals(verifyChannelDataOptions.getChannelName())) {
                builder.withEmail(verifyChannelDataOptions.value());
            }
            if ("totp".equals(verifyChannelDataOptions.getChannelName())) {
                Credentials credentials = new Credentials();
                credentials.setTotp(verifyChannelDataOptions.value());
                builder.withCredentials(credentials);
            }
            AnswerChallengeRequest challengeAuthenticatorRequest = builder.build();
            return AuthenticationTransaction.proceed(this.client, proceedContext, () -> this.client.answerChallenge(challengeAuthenticatorRequest, proceedContext.getHref())).asAuthenticationResponse(AuthenticationStatus.AWAITING_POLL_ENROLLMENT);
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse verifyWebAuthn(ProceedContext proceedContext, WebAuthnRequest webauthnRequest) {
        try {
            Credentials credentials = new Credentials();
            credentials.setClientData(webauthnRequest.getClientData());
            if (webauthnRequest.getAttestation() != null) {
                credentials.setAttestation(webauthnRequest.getAttestation());
            }
            if (webauthnRequest.getAuthenticatorData() != null) {
                credentials.setAuthenticatorData(webauthnRequest.getAuthenticatorData());
            }
            if (webauthnRequest.getSignatureData() != null) {
                credentials.setSignatureData(webauthnRequest.getSignatureData());
            }
            AnswerChallengeRequest challengeAuthenticatorRequest = AnswerChallengeRequestBuilder.builder().withStateHandle(proceedContext.getStateHandle()).withCredentials(credentials).build();
            return AuthenticationTransaction.proceed(this.client, proceedContext, () -> this.client.answerChallenge(challengeAuthenticatorRequest, proceedContext.getHref())).asAuthenticationResponse();
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse submitPhoneAuthenticator(ProceedContext proceedContext, String phone, Authenticator.Factor factor) {
        try {
            Assert.notNull((Object)proceedContext, (String)"proceed context cannot be null");
            com.okta.idx.sdk.api.model.Authenticator phoneAuthenticator = new com.okta.idx.sdk.api.model.Authenticator();
            phoneAuthenticator.setId(factor.getId());
            phoneAuthenticator.setMethodType(factor.getMethod());
            phoneAuthenticator.setPhoneNumber(phone);
            EnrollRequest enrollRequest = EnrollRequestBuilder.builder().withAuthenticator(phoneAuthenticator).withStateHandle(proceedContext.getStateHandle()).build();
            return AuthenticationTransaction.proceed(this.client, proceedContext, () -> this.client.enroll(enrollRequest, proceedContext.getHref())).asAuthenticationResponse();
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse skipAuthenticatorEnrollment(ProceedContext proceedContext) {
        try {
            SkipAuthenticatorEnrollmentRequest skipAuthenticatorEnrollmentRequest = SkipAuthenticatorEnrollmentRequestBuilder.builder().withStateHandle(proceedContext.getStateHandle()).build();
            return AuthenticationTransaction.proceed(this.client, proceedContext, () -> this.client.skip(skipAuthenticatorEnrollmentRequest, proceedContext.getSkipHref())).asAuthenticationResponse(AuthenticationStatus.SKIP_COMPLETE);
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse resend(ProceedContext proceedContext) {
        try {
            return AuthenticationTransaction.proceed(this.client, proceedContext, () -> {
                SkipAuthenticatorEnrollmentRequest skipAuthenticatorEnrollmentRequest = SkipAuthenticatorEnrollmentRequestBuilder.builder().withStateHandle(proceedContext.getStateHandle()).build();
                return this.client.skip(skipAuthenticatorEnrollmentRequest, proceedContext.getResendHref());
            }).asAuthenticationResponse();
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse cancel(ProceedContext proceedContext) {
        try {
            return AuthenticationTransaction.proceed(this.client, proceedContext, () -> this.client.cancel(proceedContext.getStateHandle())).asAuthenticationResponse();
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse poll(ProceedContext proceedContext) {
        try {
            return AuthenticationTransaction.proceed(this.client, proceedContext, () -> {
                PollRequest pollRequest = PollRequestBuilder.builder().withStateHandle(proceedContext.getStateHandle()).build();
                String href = proceedContext.getPollInfo() != null ? proceedContext.getPollInfo().getHref() : proceedContext.getHref();
                return this.client.poll(pollRequest, href);
            }).asAuthenticationResponse();
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public IDXClientContext getClientContext() throws ProcessingException {
        try {
            return this.client.interact();
        }
        catch (ProcessingException e) {
            logger.error("Error occurred:", (Throwable)e);
            ErrorResponse errorResponse = e.getErrorResponse();
            logger.error("Error details: {}, {}", (Object)errorResponse.getError(), (Object)errorResponse.getErrorDescription());
            throw e;
        }
    }

    public void revokeToken(TokenType tokenType, String token) {
        try {
            this.client.revokeToken(tokenType.toString(), token);
        }
        catch (ProcessingException e) {
            logger.error("Exception occurred", (Throwable)e);
        }
    }

    public AuthenticationResponse introspect(IDXClientContext clientContext) {
        try {
            return AuthenticationTransaction.introspect(this.client, clientContext).asAuthenticationResponse();
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
    }

    public AuthenticationResponse fetchSignUpFormValues(ProceedContext proceedContext) {
        AuthenticationResponse newUserRegistrationResponse = new AuthenticationResponse();
        try {
            AuthenticationTransaction enrollTransaction = AuthenticationTransaction.proceed(this.client, proceedContext, () -> {
                EnrollRequest enrollRequest = EnrollRequestBuilder.builder().withStateHandle(proceedContext.getStateHandle()).build();
                return this.client.enroll(enrollRequest, proceedContext.getSelectProfileEnrollHref());
            });
            RemediationOption enrollProfileRemediationOption = enrollTransaction.getRemediationOption("enroll-profile");
            List enrollProfileFormValues = enrollProfileRemediationOption.form().stream().filter(x -> "userProfile".equals(x.getName())).collect(Collectors.toList());
            List credentialFormValues = enrollProfileRemediationOption.form().stream().filter(x -> "credentials".equals(x.getName())).collect(Collectors.toList());
            List<FormValue> formValues = Stream.concat(enrollProfileFormValues.stream(), credentialFormValues.stream()).collect(Collectors.toList());
            newUserRegistrationResponse.setFormValues(formValues);
            newUserRegistrationResponse.setProceedContext(enrollTransaction.createProceedContext());
            return newUserRegistrationResponse;
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    private AuthenticationTransaction selectPasswordOrEmailAuthenticatorIfNeeded(AuthenticationTransaction authenticationTransaction) throws ProcessingException {
        Optional<RemediationOption> challengeRemediationOptionOptional = authenticationTransaction.getOptionalRemediationOption("challenge-authenticator");
        if (challengeRemediationOptionOptional.isPresent()) {
            return authenticationTransaction;
        }
        Optional<RemediationOption> remediationOptionOptional = authenticationTransaction.getOptionalRemediationOption("select-authenticator-authenticate");
        if (!remediationOptionOptional.isPresent()) {
            return authenticationTransaction;
        }
        Map<String, String> authenticatorOptions = remediationOptionOptional.get().getAuthenticatorOptions();
        com.okta.idx.sdk.api.model.Authenticator authenticator = new com.okta.idx.sdk.api.model.Authenticator();
        if (authenticatorOptions.get("password") != null) {
            authenticator.setId(authenticatorOptions.get("password"));
        } else if (authenticatorOptions.get("email") != null) {
            authenticator.setId(authenticatorOptions.get("email"));
        }
        ChallengeRequest selectAuthenticatorRequest = ChallengeRequestBuilder.builder().withStateHandle(authenticationTransaction.getStateHandle()).withAuthenticator(authenticator).build();
        return authenticationTransaction.proceed(() -> ((RemediationOption)remediationOptionOptional.get()).proceed(this.client, selectAuthenticatorRequest));
    }

    public Response verifyEmailToken(String token) throws ProcessingException {
        return AuthenticationTransaction.verifyEmailToken(this.client, token);
    }

    public PollInfo getPollInfo(AuthenticationResponse authenticationResponse) {
        return authenticationResponse.getProceedContext().getPollInfo();
    }

    public boolean isSkipAuthenticatorPresent(ProceedContext proceedContext) {
        return proceedContext.getSkipHref() != null;
    }

    public AuthenticationResponse begin() {
        return this.begin(null);
    }

    public AuthenticationResponse begin(RequestContext requestContext) {
        try {
            return AuthenticationTransaction.create(this.client, null, null, requestContext).asAuthenticationResponse();
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse beginPasswordRecovery(String token, RequestContext requestContext) {
        try {
            return AuthenticationTransaction.create(this.client, token, EmailTokenType.RECOVERY_TOKEN, requestContext).asAuthenticationResponse();
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse beginUserActivation(String token, RequestContext requestContext) {
        try {
            return AuthenticationTransaction.create(this.client, token, EmailTokenType.ACTIVATION_TOKEN, requestContext).asAuthenticationResponse();
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        catch (IllegalArgumentException e) {
            return WrapperUtil.handleIllegalArgumentException(e);
        }
    }

    public AuthenticationResponse fetchTokenWithInteractionCode(ProceedContext proceedContext, String interactionCode) {
        AuthenticationResponse authenticationResponse = new AuthenticationResponse();
        try {
            TokenResponse tokenResponse = this.client.token("interaction_code", interactionCode, proceedContext.getClientContext());
            authenticationResponse.setTokenResponse(tokenResponse);
        }
        catch (ProcessingException e) {
            return WrapperUtil.handleProcessingException(e);
        }
        return authenticationResponse;
    }
}

