/*
 * Decompiled with CFR 0.152.
 */
package com.ogaclejapan.smarttablayout;

import android.support.v4.view.MarginLayoutParamsCompat;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;

final class Utils {
    static int getMeasuredWidth(View v) {
        return v == null ? 0 : v.getMeasuredWidth();
    }

    static int getWidth(View v) {
        return v == null ? 0 : v.getWidth();
    }

    static int getWidthWithMargin(View v) {
        return Utils.getWidth(v) + Utils.getMarginHorizontally(v);
    }

    static int getStart(View v) {
        return Utils.getStart(v, false);
    }

    static int getStart(View v, boolean withoutPadding) {
        if (v == null) {
            return 0;
        }
        if (Utils.isLayoutRtl(v)) {
            return withoutPadding ? v.getRight() - Utils.getPaddingStart(v) : v.getRight();
        }
        return withoutPadding ? v.getLeft() + Utils.getPaddingStart(v) : v.getLeft();
    }

    static int getEnd(View v) {
        return Utils.getEnd(v, false);
    }

    static int getEnd(View v, boolean withoutPadding) {
        if (v == null) {
            return 0;
        }
        if (Utils.isLayoutRtl(v)) {
            return withoutPadding ? v.getLeft() + Utils.getPaddingEnd(v) : v.getLeft();
        }
        return withoutPadding ? v.getRight() - Utils.getPaddingEnd(v) : v.getRight();
    }

    static int getPaddingStart(View v) {
        if (v == null) {
            return 0;
        }
        return ViewCompat.getPaddingStart((View)v);
    }

    static int getPaddingEnd(View v) {
        if (v == null) {
            return 0;
        }
        return ViewCompat.getPaddingEnd((View)v);
    }

    static int getPaddingHorizontally(View v) {
        if (v == null) {
            return 0;
        }
        return v.getPaddingLeft() + v.getPaddingRight();
    }

    static int getMarginStart(View v) {
        if (v == null) {
            return 0;
        }
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
        return MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)lp);
    }

    static int getMarginEnd(View v) {
        if (v == null) {
            return 0;
        }
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
        return MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)lp);
    }

    static int getMarginHorizontally(View v) {
        if (v == null) {
            return 0;
        }
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
        return MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)lp) + MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)lp);
    }

    static boolean isLayoutRtl(View v) {
        return ViewCompat.getLayoutDirection((View)v) == 1;
    }

    private Utils() {
    }
}

