/*
 * Decompiled with CFR 0.152.
 */
package com.ogaclejapan.smarttablayout;

import android.support.v4.view.MarginLayoutParamsCompat;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;

final class Utils {
    static int getMeasuredWidth(View v) {
        return v == null ? 0 : v.getMeasuredWidth();
    }

    static int getWidth(View v) {
        return v == null ? 0 : v.getWidth();
    }

    static int getRight(View v) {
        return Utils.getRight(v, false);
    }

    static int getRight(View v, boolean withoutPadding) {
        if (v == null) {
            return 0;
        }
        return withoutPadding ? v.getRight() - ViewCompat.getPaddingEnd((View)v) : v.getRight();
    }

    static int getLeft(View v) {
        return Utils.getLeft(v, false);
    }

    static int getLeft(View v, boolean withoutPadding) {
        if (v == null) {
            return 0;
        }
        return withoutPadding ? v.getLeft() + ViewCompat.getPaddingStart((View)v) : v.getLeft();
    }

    static int getMarginStart(View v) {
        if (v == null) {
            return 0;
        }
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
        return MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)lp);
    }

    static int getMarginEnd(View v) {
        if (v == null) {
            return 0;
        }
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
        return MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)lp);
    }

    static int getMarginHorizontally(View v) {
        if (v == null) {
            return 0;
        }
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
        return MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)lp) + MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)lp);
    }

    private Utils() {
    }
}

