/*
 * Decompiled with CFR 0.152.
 */
package com.ogaclejapan.smarttablayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.os.Build;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ogaclejapan.smarttablayout.R;
import com.ogaclejapan.smarttablayout.SmartTabIndicationInterpolator;
import com.ogaclejapan.smarttablayout.SmartTabStrip;

public class SmartTabLayout
extends HorizontalScrollView {
    private static final boolean DEFAULT_DISTRIBUTE_EVENLY = false;
    private static final int TITLE_OFFSET_DIPS = 24;
    private static final int TAB_VIEW_PADDING_DIPS = 16;
    private static final boolean TAB_VIEW_TEXT_ALL_CAPS = true;
    private static final int TAB_VIEW_TEXT_SIZE_SP = 12;
    private static final int TAB_VIEW_TEXT_COLOR = -67108864;
    private static final int TAB_VIEW_TEXT_MIN_WIDTH = 0;
    private int mTitleOffset;
    private boolean mTabViewTextAllCaps;
    private int mTabViewTextColor;
    private float mTabViewTextSize;
    private int mTabViewTextHorizontalPadding;
    private int mTabViewTextMinWidth;
    private int mTabViewLayoutId;
    private int mTabViewTextViewId;
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mViewPagerPageChangeListener;
    private boolean mDistributeEvenly;
    protected final SmartTabStrip mTabStrip;

    public SmartTabLayout(Context context) {
        this(context, null);
    }

    public SmartTabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SmartTabLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setHorizontalScrollBarEnabled(false);
        this.setFillViewport(true);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        float density = dm.density;
        boolean textAllCaps = true;
        int textColor = -67108864;
        float textSize = TypedValue.applyDimension((int)2, (float)12.0f, (DisplayMetrics)dm);
        int textHorizontalPadding = (int)(16.0f * density);
        int textMinWidth = (int)(0.0f * density);
        boolean distributeEvenly = false;
        int textLayoutId = -1;
        int textViewId = -1;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.stl_SmartTabLayout, defStyle, 0);
        textAllCaps = a.getBoolean(R.styleable.stl_SmartTabLayout_stl_defaultTabTextAllCaps, textAllCaps);
        textColor = a.getColor(R.styleable.stl_SmartTabLayout_stl_defaultTabTextColor, textColor);
        textSize = a.getDimension(R.styleable.stl_SmartTabLayout_stl_defaultTabTextSize, textSize);
        textHorizontalPadding = a.getDimensionPixelSize(R.styleable.stl_SmartTabLayout_stl_defaultTabTextHorizontalPadding, textHorizontalPadding);
        textMinWidth = a.getDimensionPixelSize(R.styleable.stl_SmartTabLayout_stl_defaultTabTextMinWidth, textMinWidth);
        textLayoutId = a.getResourceId(R.styleable.stl_SmartTabLayout_stl_customTabTextLayoutId, textLayoutId);
        textViewId = a.getResourceId(R.styleable.stl_SmartTabLayout_stl_customTabTextViewId, textViewId);
        distributeEvenly = a.getBoolean(R.styleable.stl_SmartTabLayout_stl_distributeEvenly, distributeEvenly);
        a.recycle();
        this.mTitleOffset = (int)(24.0f * density);
        this.mTabViewTextAllCaps = textAllCaps;
        this.mTabViewTextColor = textColor;
        this.mTabViewTextSize = textSize;
        this.mTabViewTextHorizontalPadding = textHorizontalPadding;
        this.mTabViewTextMinWidth = textMinWidth;
        this.mTabViewLayoutId = textLayoutId;
        this.mTabViewTextViewId = textViewId;
        this.mDistributeEvenly = distributeEvenly;
        this.mTabStrip = new SmartTabStrip(context, attrs);
        if (distributeEvenly && this.mTabStrip.isIndicatorAlwaysInCenter()) {
            throw new UnsupportedOperationException("'distributeEvenly' and 'indicatorAlwaysInCenter' both use does not support");
        }
        this.addView((View)this.mTabStrip, -1, -1);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mTabStrip.isIndicatorAlwaysInCenter() && this.getChildCount() > 0) {
            int left = (w - this.mTabStrip.getChildMeasuredWidthAt(0)) / 2;
            int right = (w - this.mTabStrip.getChildMeasuredWidthAt(this.getChildCount() - 1)) / 2;
            this.setPadding(left, this.getPaddingTop(), right, this.getPaddingBottom());
            this.setClipToPadding(false);
        }
    }

    public void setIndicationInterpolator(SmartTabIndicationInterpolator interpolator) {
        this.mTabStrip.setIndicationInterpolator(interpolator);
    }

    public void setCustomTabColorizer(TabColorizer tabColorizer) {
        this.mTabStrip.setCustomTabColorizer(tabColorizer);
    }

    public void setDistributeEvenly(boolean distributeEvenly) {
        this.mDistributeEvenly = distributeEvenly;
    }

    public void setSelectedIndicatorColors(int ... colors) {
        this.mTabStrip.setSelectedIndicatorColors(colors);
    }

    public void setDividerColors(int ... colors) {
        this.mTabStrip.setDividerColors(colors);
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mViewPagerPageChangeListener = listener;
    }

    public void setCustomTabView(int layoutResId, int textViewId) {
        this.mTabViewLayoutId = layoutResId;
        this.mTabViewTextViewId = textViewId;
    }

    public void setViewPager(ViewPager viewPager) {
        this.mTabStrip.removeAllViews();
        this.mViewPager = viewPager;
        if (viewPager != null) {
            viewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new InternalViewPagerListener());
            this.populateTabStrip();
        }
    }

    protected TextView createDefaultTabView(Context context) {
        TextView textView = new TextView(context);
        textView.setGravity(17);
        textView.setTextColor(this.mTabViewTextColor);
        textView.setTextSize(0, this.mTabViewTextSize);
        textView.setTypeface(Typeface.DEFAULT_BOLD);
        textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1));
        if (Build.VERSION.SDK_INT >= 11) {
            TypedValue outValue = new TypedValue();
            this.getContext().getTheme().resolveAttribute(16843534, outValue, true);
            textView.setBackgroundResource(outValue.resourceId);
        }
        if (Build.VERSION.SDK_INT >= 14) {
            textView.setAllCaps(this.mTabViewTextAllCaps);
        }
        textView.setPadding(this.mTabViewTextHorizontalPadding, 0, this.mTabViewTextHorizontalPadding, 0);
        if (this.mTabViewTextMinWidth > 0) {
            textView.setMinWidth(this.mTabViewTextMinWidth);
        }
        return textView;
    }

    private void populateTabStrip() {
        PagerAdapter adapter = this.mViewPager.getAdapter();
        TabClickListener tabClickListener = new TabClickListener();
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        for (int i = 0; i < adapter.getCount(); ++i) {
            View tabView = null;
            TextView tabTitleView = null;
            if (this.mTabViewLayoutId != -1) {
                tabView = inflater.inflate(this.mTabViewLayoutId, (ViewGroup)this.mTabStrip, false);
            }
            if (this.mTabViewTextViewId != -1 && tabView != null) {
                tabTitleView = (TextView)tabView.findViewById(this.mTabViewTextViewId);
            }
            if (tabView == null) {
                tabView = this.createDefaultTabView(this.getContext());
            }
            if (tabTitleView == null && TextView.class.isInstance(tabView)) {
                tabTitleView = (TextView)tabView;
            }
            if (tabTitleView == null) {
                throw new IllegalStateException("tabTitleView not found.");
            }
            if (this.mDistributeEvenly) {
                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)tabView.getLayoutParams();
                lp.width = 0;
                lp.weight = 1.0f;
            }
            tabTitleView.setText(adapter.getPageTitle(i));
            tabView.setOnClickListener((View.OnClickListener)tabClickListener);
            this.mTabStrip.addView(tabView);
            if (i != this.mViewPager.getCurrentItem()) continue;
            tabView.setSelected(true);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mViewPager != null) {
            this.scrollToTab(this.mViewPager.getCurrentItem(), 0);
        }
    }

    private void scrollToTab(int tabIndex, int positionOffset) {
        int tabStripChildCount = this.mTabStrip.getChildCount();
        if (tabStripChildCount == 0 || tabIndex < 0 || tabIndex >= tabStripChildCount) {
            return;
        }
        View selectedChild = this.mTabStrip.getChildAt(tabIndex);
        if (selectedChild != null) {
            int targetScrollX = selectedChild.getLeft() + positionOffset;
            if (this.mTabStrip.isIndicatorAlwaysInCenter()) {
                targetScrollX -= (this.mTabStrip.getChildWidthAt(0) - selectedChild.getWidth()) / 2;
            } else if (tabIndex > 0 || positionOffset > 0) {
                targetScrollX -= this.mTitleOffset;
            }
            this.scrollTo(targetScrollX, 0);
        }
    }

    private class TabClickListener
    implements View.OnClickListener {
        private TabClickListener() {
        }

        public void onClick(View v) {
            for (int i = 0; i < SmartTabLayout.this.mTabStrip.getChildCount(); ++i) {
                if (v != SmartTabLayout.this.mTabStrip.getChildAt(i)) continue;
                SmartTabLayout.this.mViewPager.setCurrentItem(i);
                return;
            }
        }
    }

    private class InternalViewPagerListener
    implements ViewPager.OnPageChangeListener {
        private int mScrollState;

        private InternalViewPagerListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            int extraOffset;
            int tabStripChildCount = SmartTabLayout.this.mTabStrip.getChildCount();
            if (tabStripChildCount == 0 || position < 0 || position >= tabStripChildCount) {
                return;
            }
            SmartTabLayout.this.mTabStrip.onViewPagerPageChanged(position, positionOffset);
            View selectedTitle = SmartTabLayout.this.mTabStrip.getChildAt(position);
            int n = extraOffset = selectedTitle != null ? (int)(positionOffset * (float)selectedTitle.getWidth()) : 0;
            if (0.0f < positionOffset && positionOffset < 1.0f && SmartTabLayout.this.mTabStrip.isIndicatorAlwaysInCenter()) {
                int current = SmartTabLayout.this.mTabStrip.getChildWidthAt(position) / 2;
                int next = SmartTabLayout.this.mTabStrip.getChildWidthAt(position + 1) / 2;
                extraOffset = Math.round(positionOffset * (float)(current + next));
            }
            SmartTabLayout.this.scrollToTab(position, extraOffset);
            if (SmartTabLayout.this.mViewPagerPageChangeListener != null) {
                SmartTabLayout.this.mViewPagerPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }
        }

        public void onPageScrollStateChanged(int state) {
            this.mScrollState = state;
            if (SmartTabLayout.this.mViewPagerPageChangeListener != null) {
                SmartTabLayout.this.mViewPagerPageChangeListener.onPageScrollStateChanged(state);
            }
        }

        public void onPageSelected(int position) {
            if (this.mScrollState == 0) {
                SmartTabLayout.this.mTabStrip.onViewPagerPageChanged(position, 0.0f);
                SmartTabLayout.this.scrollToTab(position, 0);
            }
            int size = SmartTabLayout.this.mTabStrip.getChildCount();
            for (int i = 0; i < size; ++i) {
                SmartTabLayout.this.mTabStrip.getChildAt(i).setSelected(position == i);
            }
            if (SmartTabLayout.this.mViewPagerPageChangeListener != null) {
                SmartTabLayout.this.mViewPagerPageChangeListener.onPageSelected(position);
            }
        }
    }

    public static interface TabColorizer {
        public int getIndicatorColor(int var1);

        public int getDividerColor(int var1);
    }
}

